/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.applapi;

import com.comsol.model.dbimodel.GeomSequence;
import com.comsol.util.classes.an;
import com.comsol.util.methods.FlStringUtil;
import com.comsol.util.methods.q;
import java.util.stream.Stream;

public final class SDimType
extends Enum<SDimType> {
    public static final /* enum */ SDimType ZEROD;
    public static final /* enum */ SDimType ONED;
    public static final /* enum */ SDimType TWOD;
    public static final /* enum */ SDimType THREED;
    public static final /* enum */ SDimType AXI1D;
    public static final /* enum */ SDimType AXI2D;
    public static final /* enum */ SDimType ND;
    public static final /* enum */ SDimType AXIND;
    public static final SDimType[] VALUES;
    public static final SDimType[] VALUES_GEOMETRICAL;
    public static final SDimType[] VALUES_ABSTRACT;
    public static final SDimType[] VALUES_NONABSTRACT;
    private int nSDim;
    private boolean isAxi;
    private String[] defaultCoordNames;
    private int[] inPlaneInd;
    private int[] outOfPlaneInd;
    private String descr;
    private static final /* synthetic */ SDimType[] a;

    static {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        ZEROD = new SDimType(-1, false, new String[]{"x", "y", "z"}, new int[0], nArray, "0D");
        ONED = new SDimType(1, false, new String[]{"x", "y", "z"}, new int[1], new int[]{1, 2}, "1D");
        int[] nArray2 = new int[2];
        nArray2[1] = 1;
        TWOD = new SDimType(2, false, new String[]{"x", "y", "z"}, nArray2, new int[]{2}, "2D");
        int[] nArray3 = new int[3];
        nArray3[1] = 1;
        nArray3[2] = 2;
        THREED = new SDimType(3, false, new String[]{"x", "y", "z"}, nArray3, new int[0], "3D");
        AXI1D = new SDimType(1, true, new String[]{"r", "phi", "z"}, new int[1], new int[]{1, 2}, "Axial_symmetry_(1D)");
        int[] nArray4 = new int[2];
        nArray4[1] = 2;
        AXI2D = new SDimType(2, true, new String[]{"r", "phi", "z"}, nArray4, new int[]{1}, "Axial_symmetry_(2D)");
        int[] nArray5 = new int[3];
        nArray5[1] = 1;
        nArray5[2] = 2;
        ND = new SDimType(0, false, new String[0], new int[0], nArray5, "ND");
        int[] nArray6 = new int[3];
        nArray6[1] = 1;
        nArray6[2] = 2;
        AXIND = new SDimType(0, true, new String[0], new int[0], nArray6, "#AXIND");
        a = new SDimType[]{ZEROD, ONED, TWOD, THREED, AXI1D, AXI2D, ND, AXIND};
        VALUES = SDimType.values();
        VALUES_GEOMETRICAL = (SDimType[])q.a((Object[])VALUES, (Object[])new SDimType[]{ZEROD, ND, AXIND});
        VALUES_ABSTRACT = new SDimType[]{ND, AXIND};
        VALUES_NONABSTRACT = (SDimType[])q.a((Object[])VALUES, (Object[])VALUES_ABSTRACT);
    }

    private SDimType(int n3, boolean bl2, String[] stringArray, int[] nArray, int[] nArray2, String string2) {
        this.nSDim = n3;
        this.isAxi = bl2;
        this.defaultCoordNames = stringArray;
        this.inPlaneInd = nArray;
        this.outOfPlaneInd = nArray2;
        this.descr = string2;
    }

    public int getNSDim() {
        return this.nSDim;
    }

    public boolean isAxi() {
        return this.isAxi;
    }

    public String[] getDefaultCoordNames() {
        return this.defaultCoordNames;
    }

    public int[] getInPlaneInd() {
        return this.inPlaneInd;
    }

    public int[] getOutOfPlaneInd() {
        return this.outOfPlaneInd;
    }

    public int getRadialAxisInd() {
        if (this.isAxi) {
            return this.inPlaneInd[0];
        }
        throw new RuntimeException("The_radial_axis_is_only_defined_for");
    }

    public String getDescr() {
        return this.descr;
    }

    public String[] make3Vector(String[] stringArray) {
        String[] stringArray2 = FlStringUtil.array((int)3, (String)"0");
        int n2 = 0;
        while (n2 < this.nSDim) {
            stringArray2[this.inPlaneInd[n2]] = stringArray[n2];
            ++n2;
        }
        return stringArray2;
    }

    public double[] make3Vector(double[] dArray) {
        double[] dArray2 = new double[3];
        int n2 = 0;
        while (n2 < this.nSDim) {
            dArray2[this.inPlaneInd[n2]] = dArray[n2];
            ++n2;
        }
        return dArray2;
    }

    public String[] makeNSDimVector(String[] stringArray) {
        String[] stringArray2 = new String[this.nSDim];
        int n2 = 0;
        while (n2 < this.nSDim) {
            stringArray2[n2] = stringArray[this.inPlaneInd[n2]];
            ++n2;
        }
        return stringArray2;
    }

    public String[] setZeroOutOfPlane(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        int n2 = 0;
        while (n2 < this.outOfPlaneInd.length) {
            stringArray2[this.outOfPlaneInd[n2]] = "0";
            ++n2;
        }
        return stringArray2;
    }

    public static SDimType settingsToType(int n2, boolean bl2) {
        switch (n2) {
            case -1: 
            case 0: {
                return ZEROD;
            }
            case 1: {
                return bl2 ? AXI1D : ONED;
            }
            case 2: {
                return bl2 ? AXI2D : TWOD;
            }
            case 3: {
                return THREED;
            }
        }
        throw new RuntimeException("Invalid space dimension: " + n2 + "D.");
    }

    public static String getMeshTime(GeomSequence geomSequence) {
        if (geomSequence != null && geomSequence.getSpatialFrame().isSplitFromFrame(geomSequence.getMeshFrame())) {
            return "TIME";
        }
        return SDimType.getPublicTime();
    }

    public static String getPublicTime() {
        return "t";
    }

    public static SDimType getType(int n2, boolean bl2) {
        SDimType[] sDimTypeArray = SDimType.values();
        int n3 = sDimTypeArray.length;
        int n4 = 0;
        while (n4 < n3) {
            SDimType sDimType = sDimTypeArray[n4];
            if (sDimType.getNSDim() == n2 && sDimType.isAxi() == bl2) {
                return sDimType;
            }
            ++n4;
        }
        return ND;
    }

    public static SDimType[] getTypesByDim(int ... nArray) {
        an an2 = new an(nArray);
        return (SDimType[])Stream.of(SDimType.values()).filter(sDimType -> an2.contains(sDimType.nSDim)).toArray(SDimType[]::new);
    }

    public static SDimType[] values() {
        SDimType[] sDimTypeArray = a;
        int n2 = sDimTypeArray.length;
        SDimType[] sDimTypeArray2 = new SDimType[n2];
        System.arraycopy(a, 0, sDimTypeArray2, 0, n2);
        return sDimTypeArray2;
    }

    public static SDimType valueOf(String string) {
        return Enum.valueOf(SDimType.class, string);
    }
}

