/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.automodeling;

import com.comsol.model.dbimodel.MeshSequence;
import com.comsol.model.operations.HAutoTable;
import com.comsol.model.operations.IPredefinedTable;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.methods.FlStringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public interface IAutoMeshSuggestion {
    public Collection<BoundaryIdentitySet> getBoundaryIdentitySets(int var1, int var2);

    public Collection<SequenceSetupError> getSetupErrors();

    public String[] getMaximalElementsSize(int var1);

    public PreferredTable[] getPreferredTable(int var1);

    public BoundaryLayer[] getBoundaryLayers();

    public EdgeDistribution[] getEdgeDistributions();

    public int[][] entitiesToMesh();

    public List<LayerDomains> getStructuredLayerDomain();

    public int[] getStructuredMeshEntities(int var1);

    public boolean getOptimizeSecondOrder();

    public boolean getOptimizeAvoidTooSmall();

    public boolean getOptimizeAvoidTooLarge();

    public MeshOptimizationLevel getOptimizationLevel();

    public static class BoundaryIdentitySet {
        final int[] a;
        final int[] b;

        public BoundaryIdentitySet(int[] nArray, int[] nArray2) {
            this.a = nArray;
            this.b = nArray2;
        }
    }

    public static class BoundaryLayer {
        private final int[] g;
        private final int[] h;
        double a;
        int b;
        double c = 1.0;
        String d = null;
        SharpCornersMethod e = SharpCornersMethod.TRIM;
        boolean f = false;

        public String toString() {
            return "BL: dom = " + Arrays.toString(this.g) + ", bnd = " + Arrays.toString(this.h);
        }

        BoundaryLayer(int[] nArray, int[] nArray2, int n2, double d2) {
            this.g = nArray;
            this.h = nArray2;
            this.a = d2;
            this.b = n2;
        }

        BoundaryLayer(int[] nArray, int[] nArray2, int n2, double d2, double d3) {
            this.g = nArray;
            this.h = nArray2;
            this.a = d2;
            this.b = n2;
            this.c = d3;
        }

        BoundaryLayer(int[] nArray, int[] nArray2, int n2, double d2, String string) {
            this.g = nArray;
            this.h = nArray2;
            this.a = d2;
            this.b = n2;
            this.d = string;
        }

        BoundaryLayer(int[] nArray, int[] nArray2, int n2, double d2, double d3, SharpCornersMethod sharpCornersMethod, boolean bl2) {
            this.g = nArray;
            this.h = nArray2;
            this.a = d2;
            this.b = n2;
            this.c = d3;
            this.e = sharpCornersMethod;
            this.f = bl2;
        }

        public int[] getDomain() {
            return this.g;
        }

        public int[] getBoundaries() {
            return this.h;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            BoundaryLayer boundaryLayer = (BoundaryLayer)object;
            return boundaryLayer.a == this.a && boundaryLayer.b == this.b && boundaryLayer.c == this.c && FlStringUtil.equals((String)boundaryLayer.d, (String)this.d);
        }

        public int hashCode() {
            return this.b + (int)(this.a * 997.0 + this.c * 997.0) + (this.d != null ? this.d.hashCode() : 0);
        }
    }

    public static class EdgeDistribution {
        final int[] a;
        final int b;
        final boolean c;

        public EdgeDistribution(int[] nArray, boolean bl2, int n2) {
            this.a = nArray;
            this.c = bl2;
            this.b = n2;
        }

        public String toString() {
            String string = "Edge distribution: " + FlStringUtil.strValueOf((int[])this.a) + ": " + this.b;
            if (this.c) {
                string = String.valueOf(string) + " VOID ONLY";
            }
            string = String.valueOf(string) + "\n";
            return string;
        }
    }

    public static class LayerDomains
    implements Comparable<LayerDomains> {
        final int[] a;
        final int b;
        final boolean c;
        final int[] d;

        public LayerDomains(int[] nArray, int n2, boolean bl2, int[] nArray2) {
            this.a = nArray;
            this.b = n2;
            this.c = bl2;
            this.d = nArray2;
        }

        public String toString() {
            return "Layer domains: " + FlStringUtil.strValueOf((int[])this.a) + "\n";
        }

        @Override
        public int compareTo(LayerDomains layerDomains) {
            return this.b - layerDomains.b;
        }
    }

    public static enum MeshOptimizationLevel {
        NoOpinion,
        Basic,
        Medium,
        High;

    }

    public static class PreferredTable
    implements Comparable<PreferredTable> {
        private int a;
        private int[] b;
        private final int c;
        private final IPredefinedTable d;
        private MeshSequence e;
        private double f;

        void a(MeshSequence meshSequence, double d2) {
            this.f = d2;
            this.e = meshSequence;
        }

        public String toString() {
            String string = "Dim: " + this.a + ", " + Arrays.toString(this.b) + ": hauto = " + this.c;
            if (this.d != null) {
                if (this.d.useCustomSize()) {
                    string = String.valueOf(string) + " (custom)";
                }
                string = String.valueOf(string) + " " + this.d.getDescription();
            }
            return string;
        }

        public PreferredTable(int n2, int[] nArray, int n3, IPredefinedTable iPredefinedTable) {
            this.a = n2;
            this.b = nArray;
            this.c = n3;
            this.d = iPredefinedTable;
        }

        public int hashCode() {
            int n2 = this.c;
            n2 = 31 * n2 + this.d.hashCode();
            return n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            PreferredTable preferredTable = (PreferredTable)object;
            return this.c == preferredTable.c && this.d.equals(preferredTable.d);
        }

        @Override
        public int compareTo(PreferredTable preferredTable) {
            if (this == preferredTable) {
                return 0;
            }
            HAutoTable.HAutoCollection hAutoCollection = this.d.getTable(this.e.getSDim());
            HAutoTable.HAutoCollection hAutoCollection2 = preferredTable.d.getTable(this.e.getSDim());
            int n2 = hAutoCollection.hauto[this.a()].compareTo(hAutoCollection2.hauto[preferredTable.a()], this.e);
            if (n2 != 0) {
                return n2;
            }
            int n3 = hAutoCollection.hauto[5].compareTo(hAutoCollection.hauto[5], this.e);
            if (n3 != 0) {
                return n3;
            }
            if (this.c < preferredTable.c) {
                return 1;
            }
            if (this.c > preferredTable.c) {
                return -1;
            }
            return 0;
        }

        private int a() {
            int n2 = this.c + (int)this.f;
            if (n2 < 1) {
                n2 = 1;
            } else if (n2 > 9) {
                n2 = 9;
            }
            return n2;
        }

        public String getTableName() {
            return this.d.toString();
        }

        public boolean useCustomSize() {
            return this.d != null && this.d.useCustomSize();
        }

        public int getHAuto() {
            return this.c;
        }

        public IPredefinedTable getTable() {
            return this.d;
        }

        public void setDim(int n2) {
            this.a = n2;
        }

        public int getDim() {
            return this.a;
        }

        public void setDom(int[] nArray) {
            this.b = nArray;
        }

        public int[] getDom() {
            return this.b;
        }
    }

    public static class SequenceSetupError {
        private final String a;
        private final String b;
        private final int c;
        private final int[] d;

        public SequenceSetupError(String string) {
            this(string, string);
        }

        public SequenceSetupError(String string, String string2) {
            this(string, string2, -1, null);
        }

        public SequenceSetupError(String string, String string2, int n2, int[] nArray) {
            this.a = string;
            this.b = string2;
            this.c = n2;
            this.d = nArray;
        }

        public FlException getExectionToThrow() {
            return new FlException(this.a);
        }

        private String a(int n2, int n3) {
            switch (n2) {
                case 0: {
                    return "Point";
                }
                case 1: {
                    return "Edge";
                }
                case 2: {
                    if (n3 == 3) {
                        return "Face";
                    }
                    return "Domain";
                }
                case 3: {
                    return "Domain";
                }
            }
            return null;
        }

        public FlException getDetailException(int n2) {
            FlException flException = new FlException(this.b);
            if (this.c != -1) {
                flException.addParameterPair(this.a(this.c, n2), FlStringUtil.delimitedString((String[])FlStringUtil.valueOf((int[])this.d), (String)","));
            }
            return flException;
        }

        public boolean process(ArrayList<SequenceSetupError> arrayList) {
            for (SequenceSetupError sequenceSetupError : arrayList) {
                if (!sequenceSetupError.b.equals(this.b) || this.c != sequenceSetupError.c || this.d != sequenceSetupError.d && !Arrays.equals(this.d, sequenceSetupError.d)) continue;
                return false;
            }
            arrayList.add(this);
            return true;
        }
    }

    public static enum SharpCornersMethod {
        SPLIT,
        TRIM,
        NONE;

    }
}

