/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.database;

import com.comsol.model.database.DatabaseDescriptor;
import com.comsol.util.classes.t;
import com.comsol.util.interfaces.b;
import com.comsol.util.methods.FlStringUtil;
import com.comsol.util.methods.q;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class DatabaseModelDescriptor {
    private final DatabaseDescriptor a;
    private final UUID b;
    private final UUID c;
    private final DatabaseModelType d;
    private final String e;

    public DatabaseModelDescriptor(DatabaseDescriptor databaseDescriptor, UUID uUID, UUID uUID2, DatabaseModelType databaseModelType, String string) {
        Objects.requireNonNull(databaseDescriptor, "databaseDescriptor");
        Objects.requireNonNull(uUID, "dbModelKey");
        Objects.requireNonNull(databaseModelType, "databaseModelType");
        Objects.requireNonNull(uUID2, "dbModelVersionKey");
        this.a = databaseDescriptor;
        this.b = uUID;
        this.c = uUID2;
        this.d = databaseModelType;
        this.e = string;
    }

    public DatabaseDescriptor getDatabaseDescriptor() {
        return this.a;
    }

    public UUID getDbModelKey() {
        return this.b;
    }

    public UUID getDbModelVersionKey() {
        return this.c;
    }

    public DatabaseModelType getDatabaseModelType() {
        return this.d;
    }

    public String getModelVersionTitle() {
        return this.e;
    }

    public String[] toAttributePairs() {
        return (String[])q.b((Object[][])new String[][]{this.a.toAttributePairs(), {"databaseModelKey", this.b.toString(), "databaseModelVersionKey", this.c.toString(), "databaseModelTypeId", Integer.toString(this.d.a()), "databaseModelVersionTitle", this.e}});
    }

    public t toDbUri() {
        StringBuilder stringBuilder = new StringBuilder("db:///?");
        String[] stringArray = this.toAttributePairs();
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (n2 > 0) {
                stringBuilder.append("&");
            }
            stringBuilder.append(stringArray[n2]).append("=").append(FlStringUtil.encodeURIQueryElement((String)stringArray[n2 + 1]));
            n2 += 2;
        }
        return t.a((String)stringBuilder.toString());
    }

    public static DatabaseModelDescriptor fromDbUri(t t2) {
        if (!t2.n()) {
            throw new IllegalArgumentException("Not a database URI: " + t2.toString());
        }
        Map<String, String> map = DatabaseModelDescriptor.a(t2.e());
        DatabaseDescriptor databaseDescriptor = DatabaseDescriptor.fromQueryParameters(map);
        UUID uUID = UUID.fromString(map.get("databaseModelKey"));
        UUID uUID2 = UUID.fromString(map.get("databaseModelVersionKey"));
        DatabaseModelType databaseModelType = DatabaseModelDescriptor.a(map);
        String string = map.get("databaseModelVersionTitle");
        return new DatabaseModelDescriptor(databaseDescriptor, uUID, uUID2, databaseModelType, string);
    }

    private static Map<String, String> a(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String[] stringArray = string.split(Pattern.quote("&"));
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string2;
            String string3;
            String string4 = stringArray[n3];
            Object[] objectArray = string4.split(Pattern.quote("="), 2);
            switch (objectArray.length) {
                case 1: {
                    string3 = FlStringUtil.decodeURIQueryElement((String)objectArray[0]);
                    string2 = "";
                    break;
                }
                case 2: {
                    string3 = FlStringUtil.decodeURIQueryElement((String)objectArray[0]);
                    string2 = FlStringUtil.decodeURIQueryElement((String)objectArray[1]);
                    break;
                }
                default: {
                    throw new IllegalStateException("Internal error: Wrong number of segments: " + Arrays.toString(objectArray));
                }
            }
            hashMap.put(string3, string2);
            ++n3;
        }
        return hashMap;
    }

    public String toString() {
        return String.format("[DatabaseDescriptor = %s, DbModelKey = %s, DbModelVersionKey = %s, DatabaseModelType = %s, DbModelVersionTitle = %s]", this.a, this.b, this.c, this.d.name(), this.e);
    }

    public static DatabaseModelDescriptor fromAttributes(b b2) {
        return new DatabaseModelDescriptor(DatabaseDescriptor.fromAttributes(b2), UUID.fromString(b2.b("databaseModelKey")), UUID.fromString(b2.b("databaseModelVersionKey")), DatabaseModelDescriptor.a(b2), b2.b("databaseModelVersionTitle"));
    }

    private static DatabaseModelType a(Map<String, String> map) {
        return map.containsKey("databaseModelTypeId") ? DatabaseModelType.b(Integer.parseInt(map.get("databaseModelTypeId"))) : DatabaseModelType.NORMAL;
    }

    private static DatabaseModelType a(b b2) {
        String string = b2.b("databaseModelTypeId");
        return string != null ? DatabaseModelType.b(Integer.parseInt(string)) : DatabaseModelType.NORMAL;
    }

    public static enum DatabaseModelType {
        NORMAL(1),
        DRAFT(2),
        RECOVERY(3);

        private static final Map<Integer, DatabaseModelType> a;
        private final int typeId;

        static {
            a = Arrays.stream(DatabaseModelType.values()).collect(Collectors.toMap(DatabaseModelType::a, Function.identity()));
        }

        private DatabaseModelType(int n3) {
            this.typeId = n3;
        }

        private int a() {
            return this.typeId;
        }

        private static DatabaseModelType b(int n2) {
            return a.get(n2);
        }
    }
}

