/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.dbimodel;

import com.comsol.model.dbimodel.EVENT_TYPE;
import com.comsol.model.dbimodel.Init;
import com.comsol.model.dbimodel.InitList;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import java.util.List;

@PrimitiveModelEntity.TypeDoc(value="Solver event")
public interface Event
extends ModelEntity {
    public String getStart();

    public void setStart(String var1);

    public String getPeriod();

    public void setPeriod(String var1);

    public String getCondition();

    public void setCondition(String var1);

    public EVENT_TYPE getType();

    public void setType(EVENT_TYPE var1);

    @PrimitiveModelEntity.MethodDoc(doc="Sets the condition for triggering an implicit event. The event is triggered when the condition becomes true", ret="Event", type=PrimitiveModelEntity.MethodType.WRITE)
    public Event condition(@PrimitiveModelEntity.ParamDoc(name="expr", doc="A string expression") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the condition for triggering an implicit event", ret="A string expression", type=PrimitiveModelEntity.MethodType.READ)
    public String condition();

    public void createReset(Event var1, boolean var2);

    @PrimitiveModelEntity.MethodDoc(doc="Sets the period for triggering an explicit event", ret="A string expression", type=PrimitiveModelEntity.MethodType.WRITE)
    public Event period(@PrimitiveModelEntity.ParamDoc(name="expr", doc="A string expression") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the period for triggering an explicit event", ret="A string expression", type=PrimitiveModelEntity.MethodType.READ)
    public String period();

    @PrimitiveModelEntity.MethodDoc(doc="Returns the list of re-initialization conditions", ret="List of {@link Init} features", type=PrimitiveModelEntity.MethodType.ACCESS)
    public InitList<? extends Init> reinit();

    @PrimitiveModelEntity.MethodDoc(doc="Returns a re-initialization feature", ret="{@link Init} feature", type=PrimitiveModelEntity.MethodType.ACCESS)
    public Init reinit(@PrimitiveModelEntity.ParamDoc(name="tag", doc="Re-initialization feature tag") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Sets the start time for triggering an explicit event", ret="Event", type=PrimitiveModelEntity.MethodType.WRITE)
    public Event start(@PrimitiveModelEntity.ParamDoc(name="expr", doc="A string expression") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the start time for triggering an explicit event", ret="A string expression", type=PrimitiveModelEntity.MethodType.READ)
    public String start();

    public List<String> toReInitElementSyntax(EVENT_TYPE var1);

    public void setInitMethod(String var1);

    public String getInitMethod();
}

