/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.dbimodel;

import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.util.classes.CsAngleInfo;
import com.comsol.util.classes.CsBitSet;
import com.comsol.util.classes.GeomAdj;
import com.comsol.util.classes.JSparseInt;
import com.comsol.util.classes.m;
import com.comsol.util.classes.r;

@PrimitiveModelEntity.TypeDoc(value="Geometry information")
@PrimitiveModelEntity.PureInterface
public interface GeomInfo
extends ModelEntity {
    @PrimitiveModelEntity.MethodDoc(doc="Throws an exception if the geometry is invalid.", type=PrimitiveModelEntity.MethodType.READ)
    public void check();

    @PrimitiveModelEntity.MethodDoc(doc="Evaluates edge curvature at the specified parameters. The method is not implemented for meshes", ret="Vector of curvature values", type=PrimitiveModelEntity.MethodType.READ)
    public double[] edgeCurvature(@PrimitiveModelEntity.ParamDoc(name="edge", doc="Edge index") int var1, @PrimitiveModelEntity.ParamDoc(name="s", doc="Vector of parameter values") double[] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Evaluates the parameters to third order derivative values", ret="Matrix of third order derivative values", type=PrimitiveModelEntity.MethodType.READ)
    public double[][] edgeDDDX(@PrimitiveModelEntity.ParamDoc(name="edge", doc="Edge index") int var1, @PrimitiveModelEntity.ParamDoc(name="s", doc="Vector of parameter values") double[] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Evaluates the parameters to second order derivative values", ret="Matrix of second order derivative values", type=PrimitiveModelEntity.MethodType.READ)
    public double[][] edgeDDX(@PrimitiveModelEntity.ParamDoc(name="edge", doc="Edge index") int var1, @PrimitiveModelEntity.ParamDoc(name="s", doc="Vector of parameter values") double[] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Evaluates the parameters to first order derivative values", ret="Matrix of first order derivative values", type=PrimitiveModelEntity.MethodType.READ)
    public double[][] edgeDX(@PrimitiveModelEntity.ParamDoc(name="edge", doc="Edge index") int var1, @PrimitiveModelEntity.ParamDoc(name="s", doc="Vector of parameter values") double[] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Compute the \"maximum\" along a 3D edge of the angle (in radians) between the normal vectors of two faces that are adjacent to the edge. The \"maximum\" is defined as the value closest to pi/2. The method is vectorized so that the Nth entry in the returned array is the maximum along edge[N] of the angle between faces face1[N] and face2[N]. The edge and face numbers are one-based", ret="Vector of maximum angles", type=PrimitiveModelEntity.MethodType.READ)
    public double[] edgeMaxFaceAngle(@PrimitiveModelEntity.ParamDoc(name="edge", doc="Vector of edge indices") int[] var1, @PrimitiveModelEntity.ParamDoc(name="face1", doc="Vector of first face indices") int[] var2, @PrimitiveModelEntity.ParamDoc(name="face2", doc="Vector of second face indices") int[] var3);

    public double[] edgeMaxFaceAngle(int[] var1, int[] var2, int[] var3, boolean var4);

    @PrimitiveModelEntity.MethodDoc(doc="Evaluates the parameters to normal vector values in 2D", ret="Matrix of normal vector values", type=PrimitiveModelEntity.MethodType.READ)
    public double[][] edgeNormal(@PrimitiveModelEntity.ParamDoc(name="edge", doc="Vector of parameter values") int var1, @PrimitiveModelEntity.ParamDoc(name="s", doc="Vector of parameter values") double[] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the parameter range for evaluation on the edge", ret="Parameter range vector of length 2", type=PrimitiveModelEntity.MethodType.READ)
    public double[] edgeParamRange(@PrimitiveModelEntity.ParamDoc(name="edge", doc="Edge index") int var1);

    public double[] edgeTangentAtVtx(int var1, int var2);

    @PrimitiveModelEntity.MethodDoc(doc="Evaluates the parameters to torsion values", ret="Vector of torsion values", type=PrimitiveModelEntity.MethodType.READ)
    public double[] edgeTorsion(@PrimitiveModelEntity.ParamDoc(name="edge", doc="Edge index") int var1, @PrimitiveModelEntity.ParamDoc(name="s", doc="Vector of parameter values") double[] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Evaluates the parameters to coordinate values", ret="Matrix of coordinate values", type=PrimitiveModelEntity.MethodType.READ)
    public double[][] edgeX(@PrimitiveModelEntity.ParamDoc(name="edge", doc="Edge index") int var1, @PrimitiveModelEntity.ParamDoc(name="s", doc="Vector of parameter values") double[] var2);

    public double[][] edgeProject(int var1, double[][] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Evaluates the parameters to second order derivative values", ret="Rank 4 array of second order derivative values", type=PrimitiveModelEntity.MethodType.READ)
    public double[][][][] faceDDX(@PrimitiveModelEntity.ParamDoc(name="face", doc="Face index") int var1, @PrimitiveModelEntity.ParamDoc(name="param", doc="Matrix of parameter values") double[][] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Evaluates the parameters to first order derivative values", ret="Rank 3 array of first order derivative values", type=PrimitiveModelEntity.MethodType.READ)
    public double[][][] faceDX(@PrimitiveModelEntity.ParamDoc(name="face", doc="Face index") int var1, @PrimitiveModelEntity.ParamDoc(name="param", doc="Matrix of parameter values") double[][] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Evaluates the parameters to the first fundamental form values", ret="Matrix of first fundamental form values", type=PrimitiveModelEntity.MethodType.READ)
    public double[][][] faceFF1(@PrimitiveModelEntity.ParamDoc(name="face", doc="Face index") int var1, @PrimitiveModelEntity.ParamDoc(name="param", doc="Matrix of parameter values") double[][] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Evaluates the parameters to the second fundamental form values", ret="Matrix of second fundamental form values", type=PrimitiveModelEntity.MethodType.READ)
    public double[][][] faceFF2(@PrimitiveModelEntity.ParamDoc(name="face", doc="Face index") int var1, @PrimitiveModelEntity.ParamDoc(name="param", doc="Matrix of parameter values") double[][] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Evaluates the parameters to Gauss curvature values", ret="Matrix of Gauss curvature values", type=PrimitiveModelEntity.MethodType.READ)
    public double[] faceGaussCurvature(@PrimitiveModelEntity.ParamDoc(name="face", doc="Face index") int var1, @PrimitiveModelEntity.ParamDoc(name="param", doc="Matrix of parameter values") double[][] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Evaluates the parameters to mean curvature values", ret="Matrix of mean curvature values", type=PrimitiveModelEntity.MethodType.READ)
    public double[] faceMeanCurvature(@PrimitiveModelEntity.ParamDoc(name="face", doc="Face index") int var1, @PrimitiveModelEntity.ParamDoc(name="param", doc="Matrix of parameter values") double[][] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Evaluates the parameters to normal vector values", ret="Matrix of normal vector values", type=PrimitiveModelEntity.MethodType.READ)
    public double[][] faceNormal(@PrimitiveModelEntity.ParamDoc(name="face", doc="Face index") int var1, @PrimitiveModelEntity.ParamDoc(name="param", doc="Matrix of parameter values") double[][] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Returns two parameter ranges for evaluation on the face", ret="Matrix of normal vector values", type=PrimitiveModelEntity.MethodType.READ)
    public double[] faceParamRange(@PrimitiveModelEntity.ParamDoc(name="face", doc="Face index") int var1);

    @PrimitiveModelEntity.MethodDoc(doc="Evaluates the parameters to coordinate values", ret="Matrix of coordinate values", type=PrimitiveModelEntity.MethodType.READ)
    public double[][] faceX(@PrimitiveModelEntity.ParamDoc(name="face", doc="Face index") int var1, @PrimitiveModelEntity.ParamDoc(name="param", doc="Matrix of parameter values") double[][] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Gets adjacency between entities in dimensions fromDim and toDim. A row A[fromIdx] in the returned matrix A contains the 1-based entities in dimension toDim that are adjacent to entity fromIdx in dimension fromDim. fromIdx is a 1-based entity number. If fromDim==sdim, fromIdx=0 means the void regions", ret="Adjacency matrix", type=PrimitiveModelEntity.MethodType.READ)
    public int[][] getAdj(@PrimitiveModelEntity.ParamDoc(name="fromDim", doc="From dimension") int var1, @PrimitiveModelEntity.ParamDoc(name="toDim", doc="To dimension") int var2);

    @PrimitiveModelEntity.MethodDoc(doc="Gets adjacent entities in dimension toDim to entity fromIdx in dimension fromDim. fromIdx is a 1-based entity number, and the returned entity numbers are also 1-based", ret="Adjacency vector", type=PrimitiveModelEntity.MethodType.READ)
    public int[] getAdj(@PrimitiveModelEntity.ParamDoc(name="fromDim", doc="From dimension") int var1, @PrimitiveModelEntity.ParamDoc(name="toDim", doc="To dimension") int var2, @PrimitiveModelEntity.ParamDoc(name="fromIdx", doc="From entity") int var3);

    @PrimitiveModelEntity.MethodDoc(doc="Get relative orientation between adjacent entities in dimensions fromDim to toDim. The returned array has the same size as getAdj(fromDim,toDim). A value 1 means that the entities have the same orientation, and -1 means that they have the opposite orientation. A value 2 means that the relative orientation is undefined, since the the lower-dimensional entity is interior to the higher-dimensional entity.", ret="Adjacency matrix", type=PrimitiveModelEntity.MethodType.READ)
    public int[][] getAdjOrient(@PrimitiveModelEntity.ParamDoc(name="fromDim", doc="From dimension") int var1, @PrimitiveModelEntity.ParamDoc(name="toDim", doc="To dimension") int var2);

    @PrimitiveModelEntity.MethodDoc(doc="Get relative orientation between entity fromIdx in dimension fromDim and its adjacent entities in dimension toDim. The returned array has the same length as getAdj(fromDim,toDim,fromIdx). fromIdx is a 1-based entity number. A value 1 means that the entities have the same orientation, and -1 means that they have the opposite orientation. A value 2 means that the relative orientation is undefined, since the the lower-dimensional entity is interior to the higher-dimensional entity.", ret="Adjacency vector", type=PrimitiveModelEntity.MethodType.READ)
    public int[] getAdjOrient(@PrimitiveModelEntity.ParamDoc(name="fromDim", doc="From dimension") int var1, @PrimitiveModelEntity.ParamDoc(name="toDim", doc="To dimension") int var2, @PrimitiveModelEntity.ParamDoc(name="fromIdx", doc="From entity") int var3);

    @PrimitiveModelEntity.MethodDoc(doc="Gets extended adjacency between entities in dimensions fromDim and toDim. A row A[fromIdx+offset] in the returned matrix A contains the 1-based entities in dimension toDim that are adjacent to entity fromIdx in dimension fromDim. If toDim=getSDim(), the entity numbers can also by negative or 0, representing finite/infinite void regions. fromIdx is a 1-based entity number. If fromDim=getSDim(), fromIdx can also be negative or 0, representing finite/infinite void regions. If fromDim=getSDim(), offset is the number of finite void regions, otherwise offset=0. Note: If voidsAreLabeled() is false, then there might be finite void regions that are denoted with 0 instead of a negative number.", ret="Adjacency matrix", type=PrimitiveModelEntity.MethodType.READ)
    public int[][] getAdjExt(@PrimitiveModelEntity.ParamDoc(name="fromDim", doc="From dimension") int var1, @PrimitiveModelEntity.ParamDoc(name="toDim", doc="To dimension") int var2);

    @PrimitiveModelEntity.MethodDoc(doc="Gets adjacent entities in dimension toDim to entity fromIdx in dimension fromDim. The returned array contains the 1-based entities in dimension toDim that are adjacent to entity fromIdx in dimension fromDim. If toDim=getSDim(), the entity numbers can also by negative or 0, representing finite/infinite void regions. fromIdx is a 1-based entity number. If fromDim=getSDim(), fromIdx can also be negative or 0, representing finite/infinite void regions. Note: If voidsAreLabeled() is false, then there might be finite void regions that are denoted with 0 instead of a negative number.", ret="Adjacency vector", type=PrimitiveModelEntity.MethodType.READ)
    public int[] getAdjExt(@PrimitiveModelEntity.ParamDoc(name="fromDim", doc="From dimension") int var1, @PrimitiveModelEntity.ParamDoc(name="toDim", doc="To dimension") int var2, @PrimitiveModelEntity.ParamDoc(name="fromIdx", doc="From entity") int var3);

    @PrimitiveModelEntity.MethodDoc(doc="Get relative orientation between adjacent entities in dimensions fromDim to toDim. The returned array has the same size as getAdjExt(fromDim,toDim). A value 1 means that the entities have the same orientation, and -1 means that they have the opposite orientation. A value 2 means that the relative orientation is undefined, since the the lower-dimensional entity is interior to the higher-dimensional entity. The return value is undefined if abs(fromDim-toDim)!=1.", ret="Orientation matrix", type=PrimitiveModelEntity.MethodType.READ)
    public int[][] getAdjExtOrient(@PrimitiveModelEntity.ParamDoc(name="fromDim", doc="From dimension") int var1, @PrimitiveModelEntity.ParamDoc(name="toDim", doc="To dimension") int var2);

    @PrimitiveModelEntity.MethodDoc(doc="Get relative orientation between entity fromIdx in dimension fromDim and its adjacent entities in dimension toDim. The returned array has the same length as getAdjExt(fromDim,toDim,fromIdx). fromIdx is a 1-based entity number. If fromDim=getSDim(), fromIdx can also be negative or 0, representing finite/infinite void regions. A value 1 means that the entities have the same orientation, and -1 means that they have the opposite orientation. A value 2 means that the relative orientation is undefined, since the the lower-dimensional entity is interior to the higher-dimensional entity.", ret="Orientation vector", type=PrimitiveModelEntity.MethodType.READ)
    public int[] getAdjExtOrient(@PrimitiveModelEntity.ParamDoc(name="fromDim", doc="From dimension") int var1, @PrimitiveModelEntity.ParamDoc(name="toDim", doc="To dimension") int var2, @PrimitiveModelEntity.ParamDoc(name="fromIdx", doc="From entity") int var3);

    @PrimitiveModelEntity.MethodDoc(doc="Gets adjacency between entities in dimensions fromDim and toDim. The returned matrix A has three rows.<br>A[0] are 1-based from-entity indices.<br>A[1] are 1-based to-entity indices.<br>A[2] are orientation values (1, -1, or 2).<br>For domains, domain 0 means the void regions. Zeros can occur in both from-domains and to-domains", ret="Adjacency matrix", type=PrimitiveModelEntity.MethodType.READ)
    public int[][] getAdjSparse(@PrimitiveModelEntity.ParamDoc(name="fromDim", doc="From dimension") int var1, @PrimitiveModelEntity.ParamDoc(name="toDim", doc="To dimension") int var2);

    public int[][] getAdjMesh(int var1, int var2);

    public int[] getAdjMesh(int var1, int var2, int var3);

    public JSparseInt[][] getAssocHistory();

    @PrimitiveModelEntity.MethodDoc(doc="Returns bounding box of object", ret="Bounding box coordinates,  ([xmin, xmax, ymin, ymax, ...]  depending on dimension).", type=PrimitiveModelEntity.MethodType.READ)
    public double[] getBoundingBox();

    @PrimitiveModelEntity.MethodDoc(doc="Gets edge matrix", ret="Edge matrix", type=PrimitiveModelEntity.MethodType.READ)
    public double[][] getEdge();

    @PrimitiveModelEntity.MethodDoc(doc="Gets face matrix", ret="Face matrix", type=PrimitiveModelEntity.MethodType.READ)
    public double[][] getFace();

    public GeomAdj getGeomAdj();

    public GeomAdj getGeomAdjMesh();

    @PrimitiveModelEntity.MethodDoc(doc="Gets number of boundaries", ret="Number of boundaries", type=PrimitiveModelEntity.MethodType.READ)
    public int getNBoundaries();

    public int getNConComps();

    @PrimitiveModelEntity.MethodDoc(doc="Gets number of domains", ret="Number of domains", type=PrimitiveModelEntity.MethodType.READ)
    public int getNDomains();

    @PrimitiveModelEntity.MethodDoc(doc="Gets number of edges", ret="Number of edges", type=PrimitiveModelEntity.MethodType.READ)
    public int getNEdges();

    @PrimitiveModelEntity.MethodDoc(doc="Gets number of faces", ret="Number of faces", type=PrimitiveModelEntity.MethodType.READ)
    public int getNFaces();

    @PrimitiveModelEntity.MethodDoc(doc="Gets number of entities of each dimension", ret="Vector with number of entities of each dimension", type=PrimitiveModelEntity.MethodType.READ)
    public int[] getNEntities();

    @PrimitiveModelEntity.MethodDoc(doc="Get number of entities in mesh construction geometry", ret="Number of entities", type=PrimitiveModelEntity.MethodType.READ)
    public int[] getNEntitiesMesh();

    @PrimitiveModelEntity.MethodDoc(doc="Gets number of finite void regions", ret="Number of finite void regions", type=PrimitiveModelEntity.MethodType.READ)
    public int getNFiniteVoids();

    @PrimitiveModelEntity.MethodDoc(doc="Gets number of vertices", ret="Number of vertices", type=PrimitiveModelEntity.MethodType.READ)
    public int getNVertices();

    @PrimitiveModelEntity.MethodDoc(doc="Gets parameter edges (embeddings of edges in faces)", ret="Matrix of parameter edges", type=PrimitiveModelEntity.MethodType.READ)
    public double[][] getPEdge();

    @PrimitiveModelEntity.MethodDoc(doc="Gets parameter vertices (embeddings of vertices in faces)", ret="Matrix of parameter vertices", type=PrimitiveModelEntity.MethodType.READ)
    public double[][] getPVertex();

    @PrimitiveModelEntity.MethodDoc(doc="Returns the domain index for each vertex. For non-isolated vertices, the domain index is NaN", ret="Domain indices", type=PrimitiveModelEntity.MethodType.READ)
    public double[] getSD();

    @PrimitiveModelEntity.MethodDoc(doc="Returns the space dimension", ret="Space dimension", type=PrimitiveModelEntity.MethodType.READ)
    public int getSDim();

    @PrimitiveModelEntity.MethodDoc(doc="Returns a 2 x (number of edges) matrix with start and end points for edges", ret="Start and end matrix", type=PrimitiveModelEntity.MethodType.READ)
    public int[][] getStartEnd();

    public int[][] getStartEndMesh();

    @PrimitiveModelEntity.MethodDoc(doc="Returns the object type: solid, surface, curve, point, mixed, or empty", ret="Object type", type=PrimitiveModelEntity.MethodType.READ)
    public String getType();

    @PrimitiveModelEntity.MethodDoc(doc="Returns the up and down domain number for all boundaries in the first and second row of the returned matrix. Domain number 0 is used for all void regions", ret="Up and down matrix", type=PrimitiveModelEntity.MethodType.READ)
    public int[][] getUpDown();

    @PrimitiveModelEntity.MethodDoc(doc="Returns the up and down domain number for all boundaries in the first and second row of the returned matrix, using the extended domain numbering. Domain number 0 is used for the infinite void region. Negative domain numbers are used for finite void regions. Note: If voidsAreLabeled() is false, then there might be finite void regions that are denoted with 0 instead of a negative number.", ret="Up and down matrix", type=PrimitiveModelEntity.MethodType.READ)
    public int[][] getUpDownExt();

    public int[][] getUpDownMesh();

    @PrimitiveModelEntity.MethodDoc(doc="Gets vertices", ret="Vertex information", type=PrimitiveModelEntity.MethodType.READ)
    public double[][] getVertex();

    @PrimitiveModelEntity.MethodDoc(doc="Get point coordinates as a sdim x (number of points) matrix", ret="Coordinate matrix", type=PrimitiveModelEntity.MethodType.READ)
    public double[][] getVertexCoord();

    public double[][] getVertexCoordMesh();

    @PrimitiveModelEntity.MethodDoc(doc="Returns the domain index for each vertex. For non-isolated vertices, the domain index is -1", ret="Domain index", type=PrimitiveModelEntity.MethodType.READ)
    public int[] getVertexDomain();

    @PrimitiveModelEntity.MethodDoc(doc="Gets vertices", ret="Vertex information", type=PrimitiveModelEntity.MethodType.READ)
    public double[][] getVtx();

    @PrimitiveModelEntity.MethodDoc(doc="Checks if the object is represented using the CAD Import Module's geometry kernel", ret="<code>true</code> if CAD representation", type=PrimitiveModelEntity.MethodType.READ)
    public boolean hasCadRep();

    public boolean hasVirtualRep();

    @PrimitiveModelEntity.MethodDoc(doc="Check if an object exists", ret="<code>true</code> if object exists", type=PrimitiveModelEntity.MethodType.READ)
    public boolean exists();

    public double getEdgeLength(int var1);

    public double getGScale();

    public double getGTol();

    public boolean[] getEntityLinear(int var1);

    public boolean[] isEdgeCircular();

    public boolean[] isFaceCylindrical();

    public boolean[] isFaceSpherical();

    public int[] getEdgeSpannedDimension();

    public boolean[] isFaceVirtual();

    public float[][] getRenderVertices();

    public float[][] getRenderVertices(int var1, int[] var2);

    public int[][] getRenderElements(String var1);

    public int[][] getRenderElements(int var1, int[] var2);

    public float[][] getRenderNormals(int[] var1);

    public double[][] getEdgeMfdCtrl(int var1);

    public int getEdgeMfdDeg(int var1);

    public int[] mapGeomToMeshGeom(int var1, int[] var2);

    public CsBitSet mapGeomToMeshGeom(int var1, CsBitSet var2);

    public int[] mapMeshGeomToGeom(int var1, int[] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Returns <code>true</code> if all finite void regions are labeled with negative domain indices in the serialization (mphtxt/mphbin file). This also affects the domain indices in getAdjExt(), getAdjOrientExt(), getUpDownExt(), getFace(), getEdge(), and getVertex()", ret="<code>false</code> if some finite void regions might be denoted with 0 in the serialization, like in version 4.2", type=PrimitiveModelEntity.MethodType.READ)
    public boolean voidsAreLabeled();

    public CsAngleInfo getMaxAngles(int var1);

    public boolean isImportedMeshType();

    public r classifyLinearEntities(int var1, int[] var2);

    public m getCurvatureProperties(int var1, int var2, boolean var3);
}

