/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.dbimodel;

import com.comsol.model.dbimodel.HistoryBlock;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.history.MethodCall;
import java.util.stream.Stream;

@PrimitiveModelEntity.TypeDoc(value="Modeling history")
public interface History
extends ModelEntity {
    public Stream<String> getActions();

    public HistoryBlock getLastBlock();

    public void addNewBlockIfLastIsLarge();

    public boolean shouldLog();

    @PrimitiveModelEntity.MethodDoc(doc="Removes the most recent disabling of top-level API calls to the history. Calling enable() can be viewed as removing an entry from a stack of disable records; logging will only occur if the stack is empty.", type=PrimitiveModelEntity.MethodType.WRITE)
    public void enable();

    @PrimitiveModelEntity.MethodDoc(doc="Disables logging of top-level API calls to the history. Use this method sparingly; the normal state is that everything should be logged. The recommended usage pattern is to use a try-finally block as follows:<br>\n <pre>\n   try {\n     model.hist().disable();\n     // perform transient operations here but do not log them\n     // ...\n   } finally {\n     model.hist().enable();\n   }\n </pre>\nCalling <code>disable()</code> can be viewed as adding an entry to a stack of disable records; logging will only occur if the stack is empty.", type=PrimitiveModelEntity.MethodType.WRITE)
    public void disable();

    public void incrementLogLevel();

    public void decrementLogLevel();

    @PrimitiveModelEntity.MethodDoc(doc="Clears the model history. See also {@link Model#resetHist()} for how to generate a shorter, but still functional history.")
    public void clear();

    @PrimitiveModelEntity.MethodDoc(doc="Enables or disables history logging for certain methods where the arguments typically are very large objects", type=PrimitiveModelEntity.MethodType.WRITE)
    public void complete(@PrimitiveModelEntity.ParamDoc(name="isComplete", doc="<code>true</code> for complete logging") boolean var1);

    @PrimitiveModelEntity.MethodDoc(doc="Checks if the history logging performs complete logging", ret="<code>true</code> if logging is complete", type=PrimitiveModelEntity.MethodType.WRITE)
    public boolean isComplete();

    public void log(MethodCall var1);

    @Override
    default public boolean includeInComparison() {
        return false;
    }
}

