/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.dbimodel;

import com.comsol.model.dbimodel.MeshSelectionContainer;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.SelectionEntity;
import com.comsol.nativemph.util.MeshStatUtil;

@PrimitiveModelEntity.TypeDoc(value="Mesh statistics")
public interface MeshStatistics
extends MeshSelectionContainer,
SelectionEntity {
    public static final String[] measures = new String[]{"skewness", "maxangle", "volcircum", "vollength", "condition", "growth"};
    public static final String[] descriptions = new String[]{"Skewness", "Maximum_angle", "Volume_versus_circumradius", "Volume_versus_length", "Condition_number", "Growth_rate"};
    public static final String[] measureVariables = new String[]{"qualskewness", "qualmaxangle", "qual", "qualvollength", "qualcondition", "qualgrowth"};

    @PrimitiveModelEntity.MethodDoc(doc="Gets the number of elements", ret="Number of elements", type=PrimitiveModelEntity.MethodType.READ)
    public int getNumElem();

    @PrimitiveModelEntity.MethodDoc(doc="Gets the number of elements of a specific type", ret="Number of elements", type=PrimitiveModelEntity.MethodType.READ)
    public int getNumElem(@PrimitiveModelEntity.ParamDoc(name="type", doc="Mesh type") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Gets the element types in the mesh", ret="Vector of element types", type=PrimitiveModelEntity.MethodType.READ)
    public String[] getTypes();

    @PrimitiveModelEntity.MethodDoc(doc="Gets the element type descriptions", ret="Vector of element type descriptions", type=PrimitiveModelEntity.MethodType.READ)
    public String[] getTypeDescriptions();

    @PrimitiveModelEntity.MethodDoc(doc="Retrieves the minimal quality in mesh", ret="Minimal quality", type=PrimitiveModelEntity.MethodType.READ)
    public double getMinQuality();

    @PrimitiveModelEntity.MethodDoc(doc="Retrieves the minimal quality in mesh of a certain element type", ret="Minimal quality", type=PrimitiveModelEntity.MethodType.READ)
    public double getMinQuality(@PrimitiveModelEntity.ParamDoc(name="type", doc="Element type") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Retrieves the mean quality in mesh", ret="Mean quality", type=PrimitiveModelEntity.MethodType.READ)
    public double getMeanQuality();

    @PrimitiveModelEntity.MethodDoc(doc="Retrieves the mean quality in mesh of a certain element type", ret="Mean quality", type=PrimitiveModelEntity.MethodType.READ)
    public double getMeanQuality(@PrimitiveModelEntity.ParamDoc(name="type", doc="Element type") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Retrieves the quality distribution", ret="Number of elements in each quality distribution slices", type=PrimitiveModelEntity.MethodType.READ)
    public int[] getQualityDistr(@PrimitiveModelEntity.ParamDoc(name="size", doc="Number of quality distribution slices") int var1);

    @PrimitiveModelEntity.MethodDoc(doc="Retrieves the quality distribution of a certain element type", ret="Number of elements in each quality distribution slices", type=PrimitiveModelEntity.MethodType.READ)
    public int[] getQualityDistr(@PrimitiveModelEntity.ParamDoc(name="type", doc="Element type") String var1, @PrimitiveModelEntity.ParamDoc(name="size", doc="Number of quality distribution slices") int var2);

    @PrimitiveModelEntity.MethodDoc(doc="Gets maximum dimension of mesh of a certain type", ret="Maximum dimension", type=PrimitiveModelEntity.MethodType.READ)
    public int getMaxDimension(@PrimitiveModelEntity.ParamDoc(name="type", doc="Mesh type") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Gets the minimum volume of element", ret="Minimum volume", type=PrimitiveModelEntity.MethodType.READ)
    public double getMinVolume();

    @PrimitiveModelEntity.MethodDoc(doc="Gets the minimum volume of a certain element type", ret="Minimum volume", type=PrimitiveModelEntity.MethodType.READ)
    public double getMinVolume(@PrimitiveModelEntity.ParamDoc(name="type", doc="Element type") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Gets the maximum volume of an element", ret="Maximum volume", type=PrimitiveModelEntity.MethodType.READ)
    public double getMaxVolume();

    @PrimitiveModelEntity.MethodDoc(doc="Gets the maximum volume of a certain element type", ret="Maximum volume", type=PrimitiveModelEntity.MethodType.READ)
    public double getMaxVolume(@PrimitiveModelEntity.ParamDoc(name="type", doc=" Element type") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Gets total volume of mesh", ret="Mesh volume", type=PrimitiveModelEntity.MethodType.READ)
    public double getVolume();

    @PrimitiveModelEntity.MethodDoc(doc="Gets total volume of the mesh for a certain element type", ret="Mesh volume", type=PrimitiveModelEntity.MethodType.READ)
    public double getVolume(@PrimitiveModelEntity.ParamDoc(name="type", doc="Element type") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Retrieves the maximum growth rate in mesh", ret="Maximum growth rate", type=PrimitiveModelEntity.MethodType.READ)
    public double getMaxGrowthRate();

    @PrimitiveModelEntity.MethodDoc(doc="Retrieves the mean growth rate in mesh", ret="Mean growth rate", type=PrimitiveModelEntity.MethodType.READ)
    public double getMeanGrowthRate();

    @PrimitiveModelEntity.MethodDoc(doc="Check if all selected entities have a mesh", ret="<code>true</code> if meshed", type=PrimitiveModelEntity.MethodType.READ)
    public boolean isComplete();

    @PrimitiveModelEntity.MethodDoc(doc="Checks if the mesh is empty", ret="<code>true</code> if the mesh is empty", type=PrimitiveModelEntity.MethodType.READ)
    public boolean isEmpty();

    public MeshStatUtil getStatUtil();

    @PrimitiveModelEntity.MethodDoc(doc="Gets the number of mesh vertices (in the selection) ", ret="Number of vertices", type=PrimitiveModelEntity.MethodType.READ)
    public int getNumVertex();

    @PrimitiveModelEntity.MethodDoc(doc="Retrieves the quality measure", ret="Quality measure", type=PrimitiveModelEntity.MethodType.READ)
    public String getQualityMeasure();

    @PrimitiveModelEntity.MethodDoc(doc="Sets the quality measure", ret="Mesh statistics", type=PrimitiveModelEntity.MethodType.WRITE)
    public MeshStatistics setQualityMeasure(@PrimitiveModelEntity.ParamDoc(name="measure", doc="One of \"volcircum\", \"maxangle\", \"condition\", \"vollength\", \"growth\", and \"skewness\"") String var1);

    default public String[] getMeasures() {
        return measures;
    }

    default public String[] getMeasureDescriptions() {
        return descriptions;
    }

    public boolean hasQualityMeasureBeenForced();

    public void setGUIShown(boolean var1);

    public boolean getGUIShown();

    public void clearStatUtil();

    @Override
    default public boolean includeInComparison() {
        return false;
    }
}

