/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.dbimodel;

import com.comsol.model.dbimodel.ExpressionBase;
import com.comsol.model.dbimodel.PrimitiveModelEntity;

@PrimitiveModelEntity.TypeDoc(value="Base interface for sets of parameters")
@PrimitiveModelEntity.PureInterface
public interface ParamBase
extends ExpressionBase {
    @PrimitiveModelEntity.MethodDoc(doc="Evaluates an expression, including functions, parameters and units. If the result is not a real scalar, an error is given.", ret="The evaluated real value", type=PrimitiveModelEntity.MethodType.READ)
    public double evaluate(@PrimitiveModelEntity.ParamDoc(name="expression", doc="The expression.") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Evaluates an expression, including functions, parameters and units. The result is converted to the specified unit. If the result is not a real scalar, an error is given.", ret="The evaluated real value in the given unit.", type=PrimitiveModelEntity.MethodType.READ)
    public double evaluate(@PrimitiveModelEntity.ParamDoc(name="expression", doc="The expression.") String var1, @PrimitiveModelEntity.ParamDoc(name="unit", doc="The unit.") String var2);

    @PrimitiveModelEntity.MethodDoc(doc="Evaluates an expression, including functions, parameters and units. If the result is not a complex scalar, an error is given.", ret="The evaluated value as an array of two doubles with the real and imaginary part.", type=PrimitiveModelEntity.MethodType.READ)
    public double[] evaluateComplex(@PrimitiveModelEntity.ParamDoc(name="expression", doc="The parameter name.") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Evaluates an expression, including functions, parameters and units. The result is converted to the specified unit. If the result is not a complex scalar, an error is given.", ret="The value of the parameter in the given unit as an array of two doubles with the real and imaginary part.", type=PrimitiveModelEntity.MethodType.READ)
    public double[] evaluateComplex(@PrimitiveModelEntity.ParamDoc(name="expression", doc="The expression.") String var1, @PrimitiveModelEntity.ParamDoc(name="unit", doc="The unit.") String var2);

    @PrimitiveModelEntity.MethodDoc(doc="Evaluates the unit of an expression", ret="The unit as a string. Returns <code>null</code> if the parameter has no unit defined, or if the model does not use units.", type=PrimitiveModelEntity.MethodType.READ)
    public String evaluateUnit(@PrimitiveModelEntity.ParamDoc(name="expr", doc="The expression.") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Loads from a file.")
    public void loadFile(@PrimitiveModelEntity.ParamDoc(name="path", doc="Path to file") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Loads from a file using a specified delimiter.")
    public void loadFile(@PrimitiveModelEntity.ParamDoc(name="path", doc="Path to file") String var1, @PrimitiveModelEntity.ParamDoc(name="delim", doc="Delimiter to use") char var2);

    @PrimitiveModelEntity.MethodDoc(doc="Loads from a file using a specified delimiter.")
    public void loadFile(@PrimitiveModelEntity.ParamDoc(name="path", doc="Path to file") String var1, @PrimitiveModelEntity.ParamDoc(name="delim", doc="Delimiter to use") char var2, @PrimitiveModelEntity.ParamDoc(name="separateUnitColumns", doc="True to split expression columns into expression and unit") boolean var3);

    @PrimitiveModelEntity.MethodDoc(doc="Loads from an Excel-file with a specified range to read, or a cell to start from, in the specified sheet.")
    public void loadFile(@PrimitiveModelEntity.ParamDoc(name="path", doc="Path to file") String var1, @PrimitiveModelEntity.ParamDoc(name="sheet", doc="The Excel-sheet to use") String var2, @PrimitiveModelEntity.ParamDoc(name="range", doc="The range, or a starting cell") String var3);

    @PrimitiveModelEntity.MethodDoc(doc="Loads from an Excel-file with a specified range to read, or a cell to start from, in the specified sheet.")
    public void loadFile(@PrimitiveModelEntity.ParamDoc(name="path", doc="Path to file") String var1, @PrimitiveModelEntity.ParamDoc(name="sheet", doc="The Excel-sheet to use") String var2, @PrimitiveModelEntity.ParamDoc(name="range", doc="The range, or a starting cell") String var3, @PrimitiveModelEntity.ParamDoc(name="separateUnitColumns", doc="True to split expression columns into expression and unit") boolean var4);

    @PrimitiveModelEntity.MethodDoc(doc="Saves to a file.")
    public void saveFile(@PrimitiveModelEntity.ParamDoc(name="path", doc="Path to file") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Saves to a file using a specified delimiter.")
    public void saveFile(@PrimitiveModelEntity.ParamDoc(name="path", doc="Path to file") String var1, @PrimitiveModelEntity.ParamDoc(name="delim", doc="Delimiter to use") char var2);

    @PrimitiveModelEntity.MethodDoc(doc="Saves to a file using a specified delimiter.")
    public void saveFile(@PrimitiveModelEntity.ParamDoc(name="path", doc="Path to file") String var1, @PrimitiveModelEntity.ParamDoc(name="delim", doc="Delimiter to use") char var2, @PrimitiveModelEntity.ParamDoc(name="separateUnitColumns", doc="True to split expression columns into expression and unit") boolean var3);

    @PrimitiveModelEntity.MethodDoc(doc="Saves to an Excel-file in a specified range, or at a cell to start from, in a specified sheet.")
    public void saveFile(@PrimitiveModelEntity.ParamDoc(name="path", doc="Path to file") String var1, @PrimitiveModelEntity.ParamDoc(name="sheet", doc="The Excel-sheet to use") String var2, @PrimitiveModelEntity.ParamDoc(name="range", doc="The range, or a starting cell") String var3, @PrimitiveModelEntity.ParamDoc(name="includeHeaders", doc="True if column headers are to be written") boolean var4, @PrimitiveModelEntity.ParamDoc(name="overwrite", doc="True if an existing file is to be overwritten, or if an error should be cast in that instance.") boolean var5);

    @PrimitiveModelEntity.MethodDoc(doc="Saves to an Excel-file in a specified range, or at a cell to start from, in a specified sheet.")
    public void saveFile(@PrimitiveModelEntity.ParamDoc(name="path", doc="Path to file") String var1, @PrimitiveModelEntity.ParamDoc(name="sheet", doc="The Excel-sheet to use") String var2, @PrimitiveModelEntity.ParamDoc(name="range", doc="The range, or a starting cell") String var3, @PrimitiveModelEntity.ParamDoc(name="includeHeaders", doc="True if column headers are to be written") boolean var4, @PrimitiveModelEntity.ParamDoc(name="overwrite", doc="True if an existing file is to be overwritten, or if an error should be cast in that instance.") boolean var5, @PrimitiveModelEntity.ParamDoc(name="separateUnitColumns", doc="True to split expression columns into expression and unit") boolean var6);

    public int getSortedColumn();

    public void setSortedColumn(int var1);

    public boolean isVisible();

    public void setVisible(boolean var1);
}

