/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.dbimodel;

import com.comsol.model.dbimodel.IFeatureListCreate;
import com.comsol.model.dbimodel.LocalSelection;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.dbimodel.ResultBaseFeature;
import com.comsol.model.dbimodel.ResultFeatureList;
import com.comsol.model.dbimodel.TableFeature;
import com.comsol.model.dbimodel.ViewBase;
import com.comsol.model.dbimodel.ViewFeature;
import com.comsol.nativemph.post.PostData;
import com.comsol.nativeutil.data.RenderPostData;

@PrimitiveModelEntity.TypeDoc(value="Post features represent plots, plot groups and their attributes")
public interface ResultFeature
extends IFeatureListCreate<ResultFeature>,
ResultBaseFeature,
ViewBase,
ViewFeature {
    public void plot(RenderPostData[][] var1);

    @PrimitiveModelEntity.MethodDoc(doc="Generate and render data for plot group", type=PrimitiveModelEntity.MethodType.WRITE)
    public void run();

    public PostData[] getPostData();

    @PrimitiveModelEntity.MethodDoc(doc="Gets the list of sub-features for this ResultFeature", ret="List of result features", type=PrimitiveModelEntity.MethodType.ACCESS)
    public ResultFeatureList<? extends PropFeature> feature();

    @PrimitiveModelEntity.MethodDoc(doc="Get the sub-feature with the given name, or an exception otherwise", ret="Result feature", type=PrimitiveModelEntity.MethodType.ACCESS)
    public ResultFeature feature(@PrimitiveModelEntity.ParamDoc(name="tag", doc="Result feature tag") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Resolves the plot group this result feature belongs to. If the feature is a plot group, returns itself.", ret="The plot group", type=PrimitiveModelEntity.MethodType.ACCESS)
    public ResultFeature getPlotGroup();

    @PrimitiveModelEntity.MethodDoc(doc="Returns <code>true</code> if this result feature is a plot group.", ret="<code>true</code> if a plot group.", type=PrimitiveModelEntity.MethodType.READ)
    public boolean isPlotGroup();

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Returns a selection property", ret="Requested selection property", type=PrimitiveModelEntity.MethodType.ACCESS)
    public LocalSelection selection(@PrimitiveModelEntity.ParamDoc(name="name", doc="Selection property name") String var1);

    public String getPlotGroupID();

    public RenderPostData[] getRenderPostData();

    public RenderPostData[][] getGroupRenderPostData();

    @PrimitiveModelEntity.MethodDoc(doc="Gets the element each vertex belongs to", ret="Vector of element index for each vertex", type=PrimitiveModelEntity.MethodType.READ)
    public int[] getVertexElements(@PrimitiveModelEntity.ParamDoc(name="renderIndex", doc="Rendering index indicating rendering type within plot") int var1, @PrimitiveModelEntity.ParamDoc(name="groupIndex", doc="Group index indicating groups or part within rendering group index") int var2);

    @PrimitiveModelEntity.MethodDoc(doc="Gets the vertex coordinates", ret="Matrix of vertex coordinates with each column corresponding to a single vertex", type=PrimitiveModelEntity.MethodType.READ)
    public float[][] getVertices(@PrimitiveModelEntity.ParamDoc(name="renderIndex", doc="Rendering index indicating rendering type within plot") int var1, @PrimitiveModelEntity.ParamDoc(name="groupIndex", doc="Group index indicating groups or part within rendering group index") int var2);

    @PrimitiveModelEntity.MethodDoc(doc="Gets the vertex normals", ret="Matrix of vertex normals with each column corresponding to a single vertex. Empty if no normals are available for the plot.", type=PrimitiveModelEntity.MethodType.READ)
    public float[][] getNormals(@PrimitiveModelEntity.ParamDoc(name="renderIndex", doc="Rendering index indicating rendering type within plot") int var1, @PrimitiveModelEntity.ParamDoc(name="groupIndex", doc="Group index indicating groups or part within rendering group index") int var2);

    @PrimitiveModelEntity.MethodDoc(doc="Get the elements for the boundary of the current plot, if applicable", ret="Matrix of boundary indices", type=PrimitiveModelEntity.MethodType.READ)
    public int[][] getBoundaryElements(@PrimitiveModelEntity.ParamDoc(name="renderIndex", doc="Rendering index indicating rendering type within plot") int var1, @PrimitiveModelEntity.ParamDoc(name="groupIndex", doc="Group index indicating groups or part within rendering group index") int var2);

    @PrimitiveModelEntity.MethodDoc(doc="Gets the elements of the plot", ret="Matrix of element indices", type=PrimitiveModelEntity.MethodType.READ)
    public int[][] getElements(@PrimitiveModelEntity.ParamDoc(name="renderIndex", doc="Rendering index indicating rendering type within plot") int var1, @PrimitiveModelEntity.ParamDoc(name="groupIndex", doc="Group index indicating groups or part within rendering group index") int var2);

    @PrimitiveModelEntity.MethodDoc(doc="Get the data vector for a specific data type", ret="Data associated with each vertex of the plot", type=PrimitiveModelEntity.MethodType.READ)
    public float[] getData(@PrimitiveModelEntity.ParamDoc(name="renderIndex", doc="Rendering index indicating rendering type within plot") int var1, @PrimitiveModelEntity.ParamDoc(name="groupIndex", doc="Group index indicating groups or part within rendering group index") int var2, @PrimitiveModelEntity.ParamDoc(name="dataType", doc="Plot data type; use getDataTypes to determine supported plot data types") String var3);

    @PrimitiveModelEntity.MethodDoc(doc="Get the maximum and minimum data for a specific data type", ret="Two elements vector with minimum and maximum values", type=PrimitiveModelEntity.MethodType.READ)
    public float[] getDataMinMax(@PrimitiveModelEntity.ParamDoc(name="renderIndex", doc="Rendering index indicating rendering type within plot") int var1, @PrimitiveModelEntity.ParamDoc(name="groupIndex", doc="Group index indicating groups or part within rendering group index") int var2, @PrimitiveModelEntity.ParamDoc(name="dataType", doc="Plot data type; use getDataTypes to determine supported plot data types") String var3);

    @PrimitiveModelEntity.MethodDoc(doc="Gets the available data types within the plot", ret="Available plot data types within the plot, for example, <code><i>Color</i></code>", type=PrimitiveModelEntity.MethodType.READ)
    public String[] getDataTypes(@PrimitiveModelEntity.ParamDoc(name="renderIndex", doc="Rendering index indicating rendering type within plot") int var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the number of rendering types within the plot", ret="Number of rendering types with a plot", type=PrimitiveModelEntity.MethodType.READ)
    public int getRenderGroups();

    @PrimitiveModelEntity.MethodDoc(doc="Retrieves the number of groups for a rendering type", ret="Number of groups", type=PrimitiveModelEntity.MethodType.READ)
    public int getGroups(@PrimitiveModelEntity.ParamDoc(name="renderIndex", doc="Rendering type index") int var1);

    @PrimitiveModelEntity.MethodDoc(doc="Get this feature's space dimension. This is the same as the plot group's dimension.", ret="Space dimension", type=PrimitiveModelEntity.MethodType.READ)
    public int getSDim();

    public String getAutoTitle();

    public void roughPreview();

    public double[][][] getGroupBoundingBox();

    public boolean hasColorAttr();

    public boolean hasHeightAttr();

    public ResultFeature getHeightFeature();

    public boolean hasLegend();

    public ResultFeature getExportAttr();

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Create a result feature", ret="Created result feature", type=PrimitiveModelEntity.MethodType.WRITE)
    public ResultFeature create(@PrimitiveModelEntity.ParamDoc(name="tag", doc="Feature tag") String var1, @PrimitiveModelEntity.ParamDoc(name="type", doc="Type of feature") String var2);

    public TableFeature getTable();

    public String getTargetAxisSourceForView();

    public void setTargetAxisSourceForView(String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the view to use when plotting the plot group to which the feature belongs.", ret="The view to use; null if none.", type=PrimitiveModelEntity.MethodType.WRITE)
    public ViewFeature prepareView(@PrimitiveModelEntity.ParamDoc(name="create", doc="If true, the view is created if needed.") boolean var1);

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Returns the units of the coordinate axes for the plot group to which the feature belong; null for 1D plot groups.", ret="An array of length 2 or 3 containing LaTeX-formatted units, or null if no units are available.", type=PrimitiveModelEntity.MethodType.READ)
    public String[] getAxisUnits();

    public void setStoredPlotData(PostData[] var1, long var2);

    public void clearStoredPlotData();

    public boolean hasStoredPlotData();

    public PostData[] getStoredPlotData(long var1);
}

