/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.dbimodel;

import com.comsol.model.dbimodel.Frame;
import com.comsol.model.dbimodel.LocalSelection;
import com.comsol.model.dbimodel.MultiphysicsContributor;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.SelectionEntity;
import com.comsol.model.dbimodel.ShapeFeature;
import com.comsol.model.dbimodel.ShapeFeatureList;
import com.comsol.model.dbimodel.StudyContainer;
import com.comsol.model.dbimodel.StudyFeature;
import com.comsol.model.dbimodel.XDLocalSelection;
import com.comsol.model.method.ShapeMethod;

@PrimitiveModelEntity.TypeDoc(value="Shape function")
public interface Shape
extends MultiphysicsContributor,
SelectionEntity,
StudyContainer {
    public boolean isCreateTimeVars();

    @Override
    public ShapeMethod method();

    public void setCreateTimeVars(boolean var1);

    @PrimitiveModelEntity.MethodDoc(doc="Return all shape features of the shape function", ret="List of shape features", type=PrimitiveModelEntity.MethodType.ACCESS)
    public ShapeFeatureList<? extends ShapeFeature> feature();

    @PrimitiveModelEntity.MethodDoc(doc="Return the frame associated with the shape function", ret="Frame tag", type=PrimitiveModelEntity.MethodType.READ)
    public String frame();

    @PrimitiveModelEntity.MethodDoc(doc="Sets the frame of the shape feature", ret="Shape function", type=PrimitiveModelEntity.MethodType.WRITE)
    public Shape frame(@PrimitiveModelEntity.ParamDoc(name="frameTag", doc="Frame tag") String var1);

    public StudyFeature getErrestOrAdapStudyFeature();

    public void setErrestOrAdapStudyFeature(StudyFeature var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the value type of the shape function", ret="Value type", type=PrimitiveModelEntity.MethodType.READ)
    public String valuetype();

    @PrimitiveModelEntity.MethodDoc(doc="Sets the value type of the shape function", ret="Shape function", type=PrimitiveModelEntity.MethodType.WRITE)
    public Shape valuetype(@PrimitiveModelEntity.ParamDoc(name="type", doc="Value type") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns a shape feature with given tag", ret="Shape feature", type=PrimitiveModelEntity.MethodType.ACCESS)
    public ShapeFeature feature(@PrimitiveModelEntity.ParamDoc(name="tag", doc="Shape feature tag") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the field variables associate with the shape function", ret="Field variable tags", type=PrimitiveModelEntity.MethodType.READ)
    public String[] fieldVariable();

    @PrimitiveModelEntity.MethodDoc(doc="Returns the element set condition associated with the shape function", ret="Element set tag", type=PrimitiveModelEntity.MethodType.READ)
    public String elementSet();

    @PrimitiveModelEntity.MethodDoc(doc="Sets the mesh element set condition to the given string", ret="Element set condition", type=PrimitiveModelEntity.MethodType.WRITE)
    public Shape elementSet(@PrimitiveModelEntity.ParamDoc(name="expr", doc="Element set condition") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Return slit selection", ret="Selection", type=PrimitiveModelEntity.MethodType.ACCESS)
    public LocalSelection slits();

    public void createReset(Shape var1, boolean var2);

    public String timeDerivativeMultiplier();

    public Shape timeDerivativeMultiplier(String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the name of the up flux variable (an empty string if the variable name has not been set.)", ret="Name of up flux variable", type=PrimitiveModelEntity.MethodType.READ)
    public String upFlux();

    @PrimitiveModelEntity.MethodDoc(doc="Sets the name of the up flux variables", ret="Shape function", type=PrimitiveModelEntity.MethodType.WRITE)
    public Shape upFlux(@PrimitiveModelEntity.ParamDoc(name="fluxName", doc="Name of up flux variable") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the name of the down flux variable (an empty string if the variable name has not been set.)", ret="Name of down flux variable", type=PrimitiveModelEntity.MethodType.READ)
    public String downFlux();

    @PrimitiveModelEntity.MethodDoc(doc="Sets the name of the down flux variable", ret="Shape function", type=PrimitiveModelEntity.MethodType.WRITE)
    public Shape downFlux(@PrimitiveModelEntity.ParamDoc(name="fluxName", doc="Name of down flux variable") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Sets expressions for the domain flux in a given frame. This is required to make the boundary flux variables produce accurate results. Only Lagrange shape functions support boundary flux variables.", ret="Shape function", type=PrimitiveModelEntity.MethodType.WRITE)
    public Shape domainFlux(@PrimitiveModelEntity.ParamDoc(name="domFlux", doc="Matrix of boundary flux expressions") String[][] var1, @PrimitiveModelEntity.ParamDoc(name="frameTag", doc="Frame tag") String var2);

    @PrimitiveModelEntity.MethodDoc(doc="Returns whether smoothing is applied in the computation of boundary flux", ret="Whether smoothing is applied in the computation of boundary flux", type=PrimitiveModelEntity.MethodType.READ)
    public boolean smoothBoundaryFlux();

    @PrimitiveModelEntity.MethodDoc(doc="Sets whether smoothing is applied in the computation of boundary flux", ret="Shape function", type=PrimitiveModelEntity.MethodType.WRITE)
    public Shape smoothBoundaryFlux(@PrimitiveModelEntity.ParamDoc(name="smooth", doc="Whether smoothing should be applied") boolean var1);

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Returns the shape function's selection", ret="Selection", type=PrimitiveModelEntity.MethodType.ACCESS)
    public XDLocalSelection selection();

    @PrimitiveModelEntity.MethodDoc(doc="Use {@link #fieldVariable()} instead", type=PrimitiveModelEntity.MethodType.READ)
    @Deprecated
    public String[] fieldvariable();

    @PrimitiveModelEntity.MethodDoc(doc="Use {@link #elementSet()} instead", type=PrimitiveModelEntity.MethodType.READ)
    @Deprecated
    public String elementset();

    @PrimitiveModelEntity.MethodDoc(doc="Use {@link #elementSet(String)} instead", type=PrimitiveModelEntity.MethodType.READ)
    @Deprecated
    public Shape elementset(String var1);

    public String getFrameIdentifier();

    public String[][] getDomainFlux();

    public Frame getDomainFluxFrame();

    public Frame getFrame();

    @PrimitiveModelEntity.MethodDoc(doc="Creates shape feature and adds it to the list of children", ret="Created shape feature", type=PrimitiveModelEntity.MethodType.WRITE)
    public ShapeFeature create(@PrimitiveModelEntity.ParamDoc(name="tag", doc="Shape function feature tag") String var1, @PrimitiveModelEntity.ParamDoc(name="sfname", doc="Shape function type: shape function name or a shape function with arguments") String var2);
}

