/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.dbmodel;

import com.comsol.model.data.Node;
import com.comsol.model.dbimodel.Group;
import com.comsol.model.dbimodel.GroupList;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbmodel.GroupDb;
import com.comsol.model.dbmodel.ModelDbUtil;
import com.comsol.model.dbmodel.ModelEntityListDb;
import com.comsol.model.definitions.GroupDefinitions;
import com.comsol.model.definitions.IDefinitionsInfo;
import com.comsol.model.element.ElConst;
import com.comsol.model.element.ElemRecordField;
import com.comsol.model.element.IElementSyntaxContributor;
import com.comsol.model.util.ElementWriter;
import com.comsol.model.util.MultiphysicsUtil;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.methods.q;
import java.util.List;
import java.util.Vector;

public class GroupListDb
extends ModelEntityListDb<Group>
implements GroupList<Group> {
    public GroupListDb(Node node) {
        super(node);
    }

    @Override
    public void move(String string, int n2) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ModelDbUtil.MethodHandle methodHandle = ModelDbUtil.beginHistoryLog(this, string, n2);){
            this.a(string, n2, "group");
            methodHandle.completeLog();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Group create(String string, String string2) {
        Throwable throwable = null;
        Object var4_5 = null;
        try (ModelDbUtil.MethodHandle methodHandle = ModelDbUtil.beginHistoryLog(this, string, string2);){
            if (!q.a((Object[])new String[]{"LoadGroup", "ConstraintGroup"}, (Object)string2)) {
                FlException flException = new FlException("Operation_cannot_be_created_in_this_context");
                flException.addParameterPair("Operation", string2);
                throw flException;
            }
            GroupDb groupDb = (GroupDb)this.f.createNode(string, "Group").getObjectEntity();
            groupDb.setType(string2);
            groupDb.setIdentifier(MultiphysicsUtil.getUniqueIdentifier(string, groupDb, this));
            groupDb.addFlag(ModelEntity.Flags.NODEACTIVATE);
            this.f.addChild(groupDb.getNode());
            groupDb.initialize();
            groupDb.getNode().sendInitializedEvent();
            return methodHandle.completeLog(groupDb);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void createReset(GroupList groupList, boolean bl2) {
        this.createResetCommon(groupList, bl2);
        for (Group group : this) {
            String string = group.tag();
            Group group2 = groupList.hasTag(string) ? groupList.get(string) : null;
            if (group2 == null) {
                group2 = groupList.create(string, group.type());
            }
            group.createReset(group2, bl2);
        }
    }

    @Override
    public void checkContains(String string) {
        super.checkContains(string);
        if (string.equals("default")) {
            throw new FlException("Group_tag_default_is_a_reserved_name");
        }
        if (string.equals("new")) {
            throw new FlException("Group_tag_new_is_a_reserved_name");
        }
    }

    @Override
    protected String c() {
        return "GroupList";
    }

    @Override
    protected String doGetDefaultName() {
        return "Load_and_constraint_groups";
    }

    @Override
    public List<String> toElementSyntax() {
        IElementSyntaxContributor iElementSyntaxContributor2;
        String[] stringArray = new String[this.size()];
        String[] stringArray2 = new String[stringArray.length];
        int n2 = 0;
        for (IElementSyntaxContributor iElementSyntaxContributor2 : this) {
            stringArray[n2] = "group." + iElementSyntaxContributor2.identifier();
            stringArray2[n2] = "0.0";
            ++n2;
        }
        iElementSyntaxContributor2 = new ElConst();
        ((ElConst)iElementSyntaxContributor2).addConst(stringArray, stringArray2, new String[0]);
        ElementWriter elementWriter = new ElementWriter();
        ((ElemRecordField)iElementSyntaxContributor2).toElemSyntax(elementWriter);
        Vector<String> vector = new Vector<String>(1);
        vector.add(elementWriter.toString());
        return vector;
    }

    @Override
    public IDefinitionsInfo<Group> getDefinitionsInfo() {
        return new GroupDefinitions(this);
    }
}

