/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.dbmodel.design;

import com.comsol.model.data.Node;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.dbimodel.design.Design;
import com.comsol.model.dbimodel.design.DesignMigrationEntityList;
import com.comsol.model.dbimodel.design.DesignMigrationVersion;
import com.comsol.model.dbmodel.design.DesignMigrationListDb;
import com.comsol.model.operations.OperationType;
import com.comsol.util.exceptions.FlException;

public class DesignMigrationEntityListDb
extends DesignMigrationListDb
implements DesignMigrationEntityList<PropFeature> {
    public DesignMigrationEntityListDb(Node node) {
        super(node);
    }

    @Override
    protected OperationType a() {
        return OperationType.DESIGNMIGRATION;
    }

    @Override
    public PropFeature resolveFeatureToCopy(String[] stringArray, Model model) {
        if (stringArray.length < 1) {
            throw new FlException("Found_no_feature_to_copy");
        }
        Design design = (Design)model;
        DesignMigrationVersion designMigrationVersion = null;
        if (design.migration().index(stringArray[0]) < 0) {
            throw new FlException("Found_no_feature_to_copy");
        }
        designMigrationVersion = (DesignMigrationVersion)design.migration().get(stringArray[0]);
        PropFeature propFeature = null;
        if (designMigrationVersion.getFeature().index(stringArray[1]) >= 0) {
            propFeature = (PropFeature)designMigrationVersion.getFeature().get(stringArray[1]);
        } else if (designMigrationVersion.physicsFeature().index(stringArray[1]) >= 0) {
            propFeature = (PropFeature)designMigrationVersion.physicsFeature().get(stringArray[1]);
        } else if (designMigrationVersion.physicsProperty().index(stringArray[1]) >= 0) {
            propFeature = (PropFeature)designMigrationVersion.physicsProperty().get(stringArray[1]);
        } else if (designMigrationVersion.physicsMaker().index(stringArray[1]) >= 0) {
            propFeature = (PropFeature)designMigrationVersion.physicsMaker().get(stringArray[1]);
        } else {
            throw new FlException("Found_no_feature_to_copy");
        }
        int n2 = 2;
        while (n2 < stringArray.length) {
            propFeature = (PropFeature)propFeature.getFeature().get(stringArray[n2]);
            ++n2;
        }
        return propFeature;
    }
}

