/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.matlib;

import com.comsol.model.matlib.ITensorSpec;
import com.comsol.util.methods.FlLocale;

public enum TensorSpecCommon implements ITensorSpec
{
    SCALAR("Scalar", new int[]{1, 1}),
    ONE_FORM("Covariant_vector", new int[]{3, 1}),
    DIRECTED_LINE_ELEMENT("Contravariant_vector", new int[]{3, 1}),
    TWO_FORM("Vector_density", new int[]{3, 1}),
    DIRECTED_AREA_ELEMENT("Directed_area_element", new int[]{3, 1}),
    THREE_FORM("Scalar_density", new int[]{1, 1}),
    VOLUME_ELEMENT("Volume_element", new int[]{1, 1}),
    LINE_DENSITY("Line_density", new int[]{1, 1}),
    LINE_ELEMENT("Line_element", new int[]{1, 1}),
    SURFACE_DENSITY("Surface_density", new int[]{1, 1}),
    AREA_ELEMENT("Area_element", new int[]{1, 1}),
    TENSOR("Mixed_contra-covariant_2_tensor", new int[]{3, 3}),
    METRIC("Covariant_2_tensor", new int[]{3, 3}),
    TENSOR_DENSITY("Contravariant_2_tensor_density", new int[]{3, 3}),
    POSITION("Position", new int[]{3, 1}),
    DISPLACEMENT("Displacement", new int[]{3, 1}),
    ROTATION("Rigid_body_rotation", new int[]{3, 1}),
    BASE_VECTOR("Base_vector", new int[]{3, 1}),
    VECTOR_BASIS("Vector_basis", new int[]{3, 3});

    private String tensorDescription;
    private int[] size;

    private TensorSpecCommon(String string2, int[] nArray) {
        this.tensorDescription = string2;
        this.size = nArray;
    }

    @Override
    public String getTypeID() {
        return this.name();
    }

    @Override
    public int[] getVariableSize() {
        return this.size;
    }

    @Override
    public String getDescription() {
        return this.tensorDescription;
    }

    @Override
    public String getComponentDescription(String string) {
        switch (this) {
            case SCALAR: 
            case THREE_FORM: {
                return string;
            }
            case ONE_FORM: 
            case TWO_FORM: {
                return String.valueOf(string) + "i, i=1,2,3";
            }
            case METRIC: {
                return String.valueOf(string) + "ij; i,j=" + FlLocale.getString((String)"material_index");
            }
            case TENSOR_DENSITY: {
                return String.valueOf(string) + "ij; i,j=" + FlLocale.getString((String)"material_index");
            }
            case VECTOR_BASIS: {
                return String.valueOf(string) + "ij; i=" + FlLocale.getString((String)"spatial_index") + ", j=" + FlLocale.getString((String)"material_index");
            }
        }
        throw new RuntimeException("Not_implemented");
    }
}

