/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.matlib;

import com.comsol.model.applapi.IPhysicalQuantity;
import com.comsol.model.matlib.ITensorSpec;
import com.comsol.model.matlib.IVariableID;
import com.comsol.model.param.ParamSpec;
import com.comsol.model.param.VectorSpec;
import com.comsol.model.util.UnitUtil;
import com.comsol.util.methods.q;

public class VariableIDUtil {
    public static String[][] getZeroMatrix(int[] nArray) {
        String[][] stringArray = new String[nArray[0]][nArray[1]];
        int n2 = 0;
        while (n2 < nArray[0]) {
            int n3 = 0;
            while (n3 < nArray[1]) {
                stringArray[n2][n3] = "0";
                ++n3;
            }
            ++n2;
        }
        return stringArray;
    }

    public static String[][] getUnitMatrix() {
        String[][] stringArray = new String[3][3];
        int n2 = 0;
        while (n2 < 3) {
            int n3 = 0;
            while (n3 < 3) {
                stringArray[n2][n3] = n2 == n3 ? "1" : "0";
                ++n3;
            }
            ++n2;
        }
        return stringArray;
    }

    public static String[][] makeIndexedComponents(String string, int[] nArray) {
        String[][] stringArray = new String[nArray[0]][nArray[1]];
        int n2 = 0;
        while (n2 < nArray[0]) {
            int n3 = 0;
            while (n3 < nArray[1]) {
                stringArray[n2][n3] = String.valueOf(string) + (nArray[0] > 1 ? Integer.valueOf(n2 + 1) : "") + (nArray[1] > 1 ? Integer.valueOf(n3 + 1) : "");
                ++n3;
            }
            ++n2;
        }
        return stringArray;
    }

    public static ParamSpec makeParamSpec(IVariableID iVariableID) {
        ParamSpec paramSpec = ParamSpec.fromSize(iVariableID.getTensorType().getVariableSize(), iVariableID.getDescription(), false);
        paramSpec.setUnit(iVariableID.getUnit());
        return paramSpec;
    }

    public static abstract class AbstractVariableID
    implements IVariableID {
        @Override
        public ParamSpec getParamSpecOrNull() {
            return VariableIDUtil.makeParamSpec(this);
        }

        @Override
        public String[][] getDefaultComponentValues() {
            return VariableIDUtil.getZeroMatrix(this.getTensorType().getVariableSize());
        }
    }

    public static class DynamicVariableID
    extends AbstractVariableID {
        String b;
        String c;
        String d;
        ITensorSpec e;
        String f;
        String g;
        String h;

        public DynamicVariableID(String string, String string2, String string3, ITensorSpec iTensorSpec, String string4, String string5, String string6) {
            this.b = string;
            this.c = string2;
            this.d = string3;
            this.e = iTensorSpec;
            this.f = string4;
            this.g = string5;
            this.h = string6;
        }

        @Override
        public String getID() {
            return this.b;
        }

        @Override
        public String getBaseName() {
            return this.c;
        }

        @Override
        public String getDescription() {
            return this.d;
        }

        @Override
        public ITensorSpec getTensorType() {
            return this.e;
        }

        @Override
        public String getUnit() {
            return this.f;
        }

        @Override
        public boolean canAssignFrom(IVariableID iVariableID, boolean bl2) {
            return iVariableID.getID().equals(this.getID());
        }

        @Override
        public boolean canAssignFrom(IPhysicalQuantity iPhysicalQuantity) {
            return this.h.equals(iPhysicalQuantity.fieldName());
        }

        @Override
        public String getTensorName(String string) {
            return String.valueOf(string) + this.c;
        }

        @Override
        public String[][] getTensorComponentNames(String string) {
            return VariableIDUtil.makeIndexedComponents(String.valueOf(string) + this.c, this.e.getVariableSize());
        }

        @Override
        public IVariableID.GroupPropertyPair getGroupPropertyPairOrNull() {
            return this.g == null ? null : new IVariableID.GroupPropertyPair(this.g, this.c);
        }

        public boolean equals(Object object) {
            return object instanceof IVariableID ? ((IVariableID)object).getID().equals(this.getID()) : false;
        }

        public String toString() {
            return "Dynamic varaible (" + this.getID() + ")";
        }

        public int hashCode() {
            return this.b.hashCode();
        }
    }

    public static class QuantityVariableID
    extends AbstractVariableID {
        private IPhysicalQuantity a;
        private String b = null;

        public QuantityVariableID(IPhysicalQuantity iPhysicalQuantity) {
            this.a = iPhysicalQuantity;
        }

        public QuantityVariableID(IPhysicalQuantity iPhysicalQuantity, String string) {
            this.a = iPhysicalQuantity;
            this.b = string;
        }

        @Override
        public String getID() {
            return "com.comsol.pq." + this.a.fieldName();
        }

        @Override
        public String getBaseName() {
            return this.a.varName();
        }

        @Override
        public String getDescription() {
            return this.a.descr();
        }

        @Override
        public ITensorSpec getTensorType() {
            return new ITensorSpec(){

                @Override
                public int[] getVariableSize() {
                    return a.size();
                }

                @Override
                public String getTypeID() {
                    return a.fieldName();
                }

                @Override
                public String getDescription() {
                    return "Matrix";
                }

                @Override
                public String getComponentDescription(String string) {
                    int[] nArray = a.size();
                    if (q.h((int[])nArray) == 1) {
                        return string;
                    }
                    if (nArray.length > 0 && nArray[0] > 1) {
                        if (nArray.length > 1 && nArray[1] > 1) {
                            return String.valueOf(string) + "ij";
                        }
                        return String.valueOf(string) + "i";
                    }
                    if (nArray.length > 1 && nArray[1] > 1) {
                        return String.valueOf(string) + "j";
                    }
                    return string;
                }
            };
        }

        @Override
        public String getUnit() {
            int[] nArray = this.a.dimension();
            return UnitUtil.getBaseUnitPowers(UnitUtil.unitSystem("SI"), nArray);
        }

        @Override
        public boolean canAssignFrom(IVariableID iVariableID, boolean bl2) {
            return iVariableID != null && iVariableID.canAssignFrom(this.a);
        }

        @Override
        public boolean canAssignFrom(IPhysicalQuantity iPhysicalQuantity) {
            return this.a.hasSameID(iPhysicalQuantity);
        }

        @Override
        public String getTensorName(String string) {
            return String.valueOf(string) + this.getBaseName();
        }

        @Override
        public String[][] getTensorComponentNames(String string) {
            return VariableIDUtil.makeIndexedComponents(this.getTensorName(string), this.getTensorType().getVariableSize());
        }

        @Override
        public IVariableID.GroupPropertyPair getGroupPropertyPairOrNull() {
            if (this.b != null) {
                return new IVariableID.GroupPropertyPair(this.b, this.getBaseName());
            }
            return this.a.isMaterialProp() ? new IVariableID.GroupPropertyPair("def", this.a.fieldName()) : null;
        }

        @Override
        public ParamSpec getParamSpecOrNull() {
            return ParamSpec.fromPhysicalQuantity(this.a);
        }

        public boolean equals(Object object) {
            return object instanceof IVariableID ? ((IVariableID)object).getID().equals(this.getID()) : false;
        }

        public String toString() {
            return "Quantity varaible (" + this.getID() + ")";
        }

        public int hashCode() {
            return this.getID().hashCode();
        }
    }

    public static class VariableIDImpl
    implements IVariableID {
        private String a;
        private String b;
        private String c;
        private ITensorSpec d;
        private String e;
        private String f;

        public VariableIDImpl(String string, String string2, String string3, ITensorSpec iTensorSpec, String string4, String string5) {
            this.a = string;
            this.b = string2;
            this.c = string3;
            this.d = iTensorSpec;
            this.e = string4;
            this.f = string5;
        }

        @Override
        public String getID() {
            return this.a;
        }

        public boolean equals(Object object) {
            return object instanceof IVariableID ? ((IVariableID)object).getID().equals(this.getID()) : false;
        }

        public String toString() {
            return "Varaible impl (" + this.getID() + ")";
        }

        @Override
        public String getBaseName() {
            return this.b;
        }

        @Override
        public String getDescription() {
            return this.c;
        }

        @Override
        public ITensorSpec getTensorType() {
            return this.d;
        }

        @Override
        public String getUnit() {
            return this.e;
        }

        @Override
        public boolean canAssignFrom(IVariableID iVariableID, boolean bl2) {
            return iVariableID.getID().equals(this.getID());
        }

        @Override
        public boolean canAssignFrom(IPhysicalQuantity iPhysicalQuantity) {
            return false;
        }

        @Override
        public String getTensorName(String string) {
            return String.valueOf(string) + this.b;
        }

        @Override
        public String[][] getTensorComponentNames(String string) {
            return VariableIDUtil.makeIndexedComponents(String.valueOf(string) + this.b, this.d.getVariableSize());
        }

        @Override
        public String[][] getDefaultComponentValues() {
            return VariableIDUtil.getZeroMatrix(this.getTensorType().getVariableSize());
        }

        @Override
        public IVariableID.GroupPropertyPair getGroupPropertyPairOrNull() {
            if (this.f != null) {
                return new IVariableID.GroupPropertyPair(this.f, this.b);
            }
            return null;
        }

        @Override
        public ParamSpec getParamSpecOrNull() {
            return VariableIDUtil.makeParamSpec(this);
        }
    }

    public static class VariableSizeArray
    implements ITensorSpec {
        @Override
        public String getTypeID() {
            return "VARIABLE_SIZE_ARRAY";
        }

        @Override
        public int[] getVariableSize() {
            return new int[]{-1, 1};
        }

        @Override
        public String getDescription() {
            return "Variable_size_array";
        }

        @Override
        public String getComponentDescription(String string) {
            return String.valueOf(string) + "i; i=1..n";
        }
    }

    public static class VariableSizeParameterArrayID
    extends DynamicVariableID {
        public VariableSizeParameterArrayID(String string, String string2, String string3) {
            super("VARIABLE_SIZE_PARAMETER_ARRAY", string, string2, new VariableSizeArray(), "1", string3, null);
        }

        @Override
        public String[][] getTensorComponentNames(String string) {
            throw new RuntimeException("Component_names_are_not_available_for_variable_length_parameters");
        }

        @Override
        public ParamSpec getParamSpecOrNull() {
            return new VectorSpec(0, this.d);
        }

        @Override
        public boolean canAssignFrom(IPhysicalQuantity iPhysicalQuantity) {
            return false;
        }

        @Override
        public boolean canAssignFrom(IVariableID iVariableID, boolean bl2) {
            return false;
        }

        @Override
        public boolean equals(IVariableID iVariableID) {
            return false;
        }

        @Override
        public String toString() {
            return "Varaible size parameter array (" + this.getID() + ")";
        }
    }

    public static class WrappedVariableID
    extends AbstractVariableID {
        private final IVariableID a;
        private String b = null;
        private String c = null;

        public WrappedVariableID(IVariableID iVariableID) {
            this.a = iVariableID;
        }

        public WrappedVariableID setBaseName(String string) {
            this.b = string;
            return this;
        }

        public WrappedVariableID setDescription(String string) {
            this.c = string;
            return this;
        }

        @Override
        public String getID() {
            return this.a.getID();
        }

        @Override
        public String getBaseName() {
            if (this.b != null) {
                return this.b;
            }
            return this.a.getBaseName();
        }

        @Override
        public String getDescription() {
            if (this.c != null) {
                return this.c;
            }
            return this.a.getDescription();
        }

        @Override
        public ITensorSpec getTensorType() {
            return this.a.getTensorType();
        }

        @Override
        public String getUnit() {
            return this.a.getUnit();
        }

        @Override
        public boolean canAssignFrom(IVariableID iVariableID, boolean bl2) {
            return this.a.canAssignFrom(iVariableID, bl2);
        }

        @Override
        public boolean canAssignFrom(IPhysicalQuantity iPhysicalQuantity) {
            return this.a.canAssignFrom(iPhysicalQuantity);
        }

        @Override
        public String getTensorName(String string) {
            return String.valueOf(string) + this.b;
        }

        @Override
        public String[][] getTensorComponentNames(String string) {
            return VariableIDUtil.makeIndexedComponents(String.valueOf(string) + this.b, this.getTensorType().getVariableSize());
        }

        @Override
        public IVariableID.GroupPropertyPair getGroupPropertyPairOrNull() {
            return this.a.getGroupPropertyPairOrNull();
        }

        public boolean equals(Object object) {
            return this.a.equals(object);
        }

        public String toString() {
            return "Wrapped variable: " + this.a;
        }

        public int hashCode() {
            return this.a.hashCode();
        }
    }
}

