/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.method;

import com.comsol.model.dbimodel.EvaluationFeature;
import com.comsol.model.dbimodel.EvaluationGroupFeature;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.dbimodel.PropFeatureList;
import com.comsol.model.dbmodel.ModelDbUtil;
import com.comsol.model.method.PropFeatureListMethod;
import com.comsol.util.exceptions.FlException;

public class EvaluationGroupFeatureListMethod<T extends EvaluationGroupFeature>
extends PropFeatureListMethod<T> {
    public EvaluationGroupFeatureListMethod(PrimitiveModelEntity primitiveModelEntity) {
        super(primitiveModelEntity);
    }

    @Override
    public PropFeature resolveFeatureToCopy(String[] stringArray, Model model) {
        if (stringArray.length == 0) {
            throw new FlException("Found_no_feature_to_copy");
        }
        EvaluationGroupFeature evaluationGroupFeature = model.result().evaluationGroup(stringArray[0]);
        if (stringArray.length > 1) {
            EvaluationFeature evaluationFeature = evaluationGroupFeature.feature(stringArray[1]);
            int n2 = 2;
            while (n2 < stringArray.length) {
                evaluationFeature = evaluationFeature.feature(stringArray[n2]);
                ++n2;
            }
            return evaluationFeature;
        }
        return evaluationGroupFeature;
    }

    @Override
    public void createReset(PropFeatureList propFeatureList, ModelEntity modelEntity, boolean bl2) {
        super.createReset(propFeatureList, modelEntity, bl2);
        if (!bl2) {
            for (PropFeature propFeature : this.getMe().getActiveList()) {
                if (!propFeature.getBoolean("hasbeenevaluated")) continue;
                ModelDbUtil.MethodHandle methodHandle = ModelDbUtil.beginHistoryLogName(propFeatureList.get(propFeature.tag()), "run");
                methodHandle.completeLog();
                methodHandle.close();
            }
        }
    }
}

