/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.method;

import com.comsol.model.applapi.MovingFrameAbstractContainer;
import com.comsol.model.applapi.SDimType;
import com.comsol.model.applapi.SharedQuantities;
import com.comsol.model.applapi.SharedQuantityContainer;
import com.comsol.model.dbimodel.EVAL;
import com.comsol.model.dbimodel.Frame;
import com.comsol.model.dbimodel.FrameFeature;
import com.comsol.model.dbimodel.FrameFeatureType;
import com.comsol.model.dbimodel.FrameList;
import com.comsol.model.dbimodel.FrameType;
import com.comsol.model.dbimodel.GeomSequence;
import com.comsol.model.dbimodel.ModelNode;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.StudyFeature;
import com.comsol.model.dbimodel.physics.EquationViewParent;
import com.comsol.model.dbimodel.physics.Physics;
import com.comsol.model.dbmodel.ModelDb;
import com.comsol.model.element.ElMesh;
import com.comsol.model.element.ElVar;
import com.comsol.model.element.ElemStringField;
import com.comsol.model.method.FrameFeatureMethod;
import com.comsol.model.method.ModelEntityMethod;
import com.comsol.model.method.internal.IFrameFeatureInternal;
import com.comsol.model.method.internal.IFrameInternal;
import com.comsol.model.method.internal.IModelInternal;
import com.comsol.model.method.internal.ISelectionInternal;
import com.comsol.model.savepoint.interfaces.IFrame;
import com.comsol.model.savepoint.interfaces.IModelNode;
import com.comsol.model.util.DeformedConfigUtil;
import com.comsol.model.util.DomainInfo;
import com.comsol.model.util.ElementWriter;
import com.comsol.model.util.LicenseRequirement;
import com.comsol.model.util.ModelEntityUtil;
import com.comsol.util.classes.n;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.methods.FlStringUtil;
import com.comsol.util.methods.q;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class FrameMethod
extends ModelEntityMethod {
    public FrameMethod(PrimitiveModelEntity primitiveModelEntity) {
        super(primitiveModelEntity);
    }

    @Override
    public IFrameInternal getMe() {
        return (IFrameInternal)this.u();
    }

    private GeomSequence f() {
        return this.getMe().getGeom();
    }

    @Override
    public IModelNode deduceScope() {
        return this.f().method().deduceScope();
    }

    @Override
    public String scope() {
        IModelNode iModelNode = this.getParentModel();
        if (iModelNode != null) {
            String string = FrameType.getFrameType(this.getMe()).getScope();
            return String.valueOf(iModelNode.scopeDot()) + string;
        }
        return "root";
    }

    public String[] coord() {
        String[] stringArray;
        boolean bl2 = this.f().isMainGeometry(false);
        if (bl2 || this.f().isDeformed()) {
            stringArray = this.f().getParentModel();
            if (bl2 && this.getMe().isSpatialFrame()) {
                return stringArray.spatialCoord();
            }
            if (this.getMe().isMaterialFrame()) {
                return stringArray.materialCoord();
            }
            if (this.getMe().isGeometryFrame()) {
                return stringArray.geometryCoord();
            }
            if (this.getMe().isMeshFrame()) {
                return stringArray.meshCoord();
            }
        }
        if ((stringArray = this.getMe().getCoord()) == null) {
            return new String[0];
        }
        String[] stringArray2 = new String[stringArray.length];
        System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
        return stringArray2;
    }

    public void coord(String[] stringArray) {
        Object object;
        boolean bl2 = false;
        if (this.f().isMainGeometry(false)) {
            object = this.getModel().modelNode(this.f().model());
            bl2 = true;
            if (this.getMe().isSpatialFrame()) {
                object.spatialCoord(stringArray);
            } else if (this.getMe().isMaterialFrame()) {
                object.materialCoord(stringArray);
            } else if (this.getMe().isGeometryFrame()) {
                object.geometryCoord(stringArray);
            } else if (this.getMe().isMeshFrame()) {
                object.meshCoord(stringArray);
            } else {
                bl2 = false;
            }
        }
        if (!bl2) {
            if (stringArray == null || stringArray.length != 3) {
                throw new FlException("Wrong_number_of_coordinates");
            }
            object = this.a(stringArray);
            if (object != null) {
                throw object;
            }
            String[] stringArray2 = this.coord();
            try {
                this.setCoord(stringArray, false);
            }
            catch (FlException flException) {
                this.setCoord(stringArray2, false);
                throw flException;
            }
        }
    }

    public void coord(int n2, String string) {
        if (n2 < 1 || 3 < n2) {
            throw new FlException("Index_out_of_bounds");
        }
        String[] stringArray = this.coord();
        stringArray[n2 - 1] = string;
        this.coord(stringArray);
    }

    public String[] getDefaultCoord(FrameType frameType) {
        String string;
        GeomSequence geomSequence = this.getModel().geom(this.getMe().geom());
        String[] stringArray = SDimType.settingsToType(geomSequence.getSDim(), geomSequence.isAxisymmetric()).getDefaultCoordNames();
        if (frameType != FrameType.spatial) {
            stringArray = FlStringUtil.toUpperCase((String[])stringArray);
            if (frameType == FrameType.mesh) {
                stringArray = FlStringUtil.append((String)"m", (String[])stringArray);
            } else if (frameType == FrameType.geometry) {
                stringArray = FlStringUtil.append((String)"g", (String[])stringArray);
            }
        }
        if ((string = geomSequence.method().getDefCoordNameSuffix()).length() != 0) {
            stringArray = FlStringUtil.append((String)string, (String[])stringArray);
        }
        if (this.a(stringArray) == null) {
            return stringArray;
        }
        int n2 = 1;
        String[] stringArray2;
        while (this.a(stringArray2 = FlStringUtil.append((String)String.valueOf(n2), (String[])stringArray)) != null) {
            ++n2;
        }
        return stringArray2;
    }

    private FlException a(String[] stringArray) {
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string = stringArray2[n3];
            if (!FlStringUtil.isVariableName((String)string) || string.contains(".")) {
                return new FlException("X_is_not_a_valid_coordinate_name#" + string);
            }
            ++n3;
        }
        return null;
    }

    private void h() {
        this.getConverter().resetUnitVars();
        if (!this.getModel().isDisableUpdates()) {
            this.getModel().physics().getVarData().updateVariables(null, this.f(), null, false, true, false, true);
        }
    }

    public void setCoord(String[] stringArray, boolean bl2) {
        IFrameInternal iFrameInternal = this.getMe();
        iFrameInternal.setRenameCoordinates(false);
        if (bl2 || !Arrays.equals(iFrameInternal.getCoord(), stringArray)) {
            iFrameInternal.setCoord(stringArray);
            if (iFrameInternal.isSpatialFrame() || iFrameInternal.isMaterialFrame() || iFrameInternal.isMeshFrame() || iFrameInternal.isGeometryFrame()) {
                this.h();
            }
        }
    }

    public void geometryFrame() {
        if (!this.getMe().isGeometryFrame()) {
            this.f().setGeometryFrame(this.getMe());
            this.h();
        }
    }

    public void materialFrame() {
        if (!this.getMe().isMaterialFrame()) {
            this.f().setMaterialFrame(this.getMe());
            this.h();
        }
    }

    public void meshFrame() {
        if (!this.getMe().isMeshFrame()) {
            this.f().setMeshFrame(this.getMe());
            this.h();
        }
    }

    public void spatialFrame() {
        if (!this.getMe().isSpatialFrame()) {
            this.f().setSpatialFrame(this.getMe());
            this.h();
        }
    }

    public String[] inPlaneCoord() {
        GeomSequence geomSequence = this.f();
        SDimType sDimType = SDimType.settingsToType(geomSequence.getSDim(), geomSequence.isAxisymmetric());
        return sDimType.makeNSDimVector(this.coord());
    }

    @Override
    public List<String> toElementSyntax() {
        Object object;
        if (!this.isActive()) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>(1);
        Vector<String> vector = new Vector<String>();
        IFrameInternal iFrameInternal = this.getMe();
        ElMesh elMesh = new ElMesh(this.identifier());
        String[] stringArray = this.inPlaneCoord();
        IModelInternal iModelInternal = this.getModel();
        boolean bl2 = this.f().isParticle() || this.f().isRay();
        boolean bl3 = !this.getMe().isSplitFromFrame(this.f().getMeshFrame());
        elMesh.set("equivmeshframe", new ElemStringField(bl3 ? "on" : "off"));
        if (iFrameInternal.isMeshFrame()) {
            String string;
            object = iFrameInternal.getParentModel();
            if (object != null && object.defineLocalCoord()) {
                elMesh.set("definelocalcoord", new ElemStringField("on"));
            }
            IFrameFeatureInternal iFrameFeatureInternal = iFrameInternal.constructFrameFeature();
            iFrameFeatureInternal.setTag("tmp");
            iFrameFeatureInternal.sorder(iFrameInternal.sorder());
            iFrameFeatureInternal.selection().geom(iFrameInternal.geom());
            ((ISelectionInternal)((Object)iFrameFeatureInternal.selection())).setIncludeMeshInterior(iModelInternal.method().hasMeshInterior());
            int[] nArray = ((FrameFeatureMethod)iFrameFeatureInternal.method()).addElMesh(elMesh, stringArray, iFrameInternal.getShapeType(), iFrameInternal.varNameSuffix());
            if (!bl2 && (string = ((FrameFeatureMethod)iFrameFeatureInternal.method()).getNormalVectorSyntax(stringArray, iFrameInternal, nArray)).length() > 0) {
                vector.add(string);
            }
        } else {
            object = iFrameInternal.sshape().tags();
            int n2 = ((String[])object).length - 1;
            while (n2 >= 0) {
                String string;
                IFrameFeatureInternal iFrameFeatureInternal = (IFrameFeatureInternal)iFrameInternal.sshape(object[n2]);
                ((ISelectionInternal)((Object)iFrameFeatureInternal.selection())).setIncludeMeshInterior(iModelInternal.method().hasMeshInterior());
                int[] nArray = ((FrameFeatureMethod)iFrameFeatureInternal.method()).addElMesh(elMesh, stringArray, "", iFrameInternal.varNameSuffix());
                if (!bl2 && (string = ((FrameFeatureMethod)iFrameFeatureInternal.method()).getNormalVectorSyntax(stringArray, iFrameInternal, nArray)).length() > 0) {
                    vector.add(string);
                }
                --n2;
            }
        }
        object = new ElementWriter();
        elMesh.toElemSyntax((n)object);
        arrayList.add(((ElementWriter)object).toString());
        arrayList.addAll(vector);
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    public List<String> toInitElementSyntax() {
        void var4_12;
        List<Object> list;
        IFrameInternal iFrameInternal = this.getMe();
        if (!this.isActive() || this.f().getXmeshIndex() < 0 || this.f().isParticle() || this.f().isRay()) {
            return new ArrayList<String>(0);
        }
        ModelNode modelNode = this.getModel().modelNode(this.f().model());
        if (!modelNode.defineAllFrames() && this.f().isMainGeometry(false) && (iFrameInternal.isGeometryFrame() || iFrameInternal.isMeshFrame())) {
            list = DeformedConfigUtil.getDeformedConfigs(this.f());
            for (GeomSequence geomSequence : list) {
                if (geomSequence.getXmeshIndex() < 0) continue;
                return Collections.emptyList();
            }
        }
        list = new ArrayList();
        boolean bl2 = false;
        if (iFrameInternal.isMeshFrame()) {
            int n2 = iFrameInternal.sorder();
        } else {
            for (FrameFeature frameFeature : iFrameInternal.sshape()) {
                int n3;
                if (((IFrameFeatureInternal)frameFeature).getType() != FrameFeatureType.FIXED) continue;
                n3 = Math.max(n3, frameFeature.sorder());
            }
        }
        if (var4_12 >= 2) {
            ElVar elVar = new ElVar();
            GeomSequence geomSequence = this.f();
            String[] stringArray = geomSequence.getMeshFrame().inPlaneCoord();
            String[] stringArray2 = this.inPlaneCoord();
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            int n4 = 2;
            while (n4 <= var4_12) {
                int n5 = 0;
                while (n5 < stringArray2.length) {
                    arrayList.add(String.valueOf(stringArray2[n5]) + "$" + n4);
                    arrayList2.add(String.valueOf(stringArray[n5]) + "g");
                    ++n5;
                }
                ++n4;
            }
            String[] stringArray3 = arrayList.toArray(new String[arrayList.size()]);
            String[] stringArray4 = arrayList2.toArray(new String[arrayList2.size()]);
            DomainInfo domainInfo = new DomainInfo();
            domainInfo.geom = geomSequence.getXmeshIndex();
            int n6 = 0;
            while (n6 <= geomSequence.getSDim()) {
                domainInfo.edim = n6;
                domainInfo.domains = q.a((int)1, (int)1, (int)geomSequence.getNEntities()[n6]);
                elVar.addVar(stringArray3, stringArray4, domainInfo);
                ++n6;
            }
            ElementWriter elementWriter = new ElementWriter();
            elVar.toElemSyntax(elementWriter);
            list.add(elementWriter.toString());
        }
        return list;
    }

    public boolean isRemovable() {
        if (this.isAutoGenerated()) {
            return true;
        }
        String string = this.getMe().geom();
        if (!FlStringUtil.contains((String[])this.getModel().geom().tags(), (String)string)) {
            return true;
        }
        int n2 = 0;
        for (Frame frame : (FrameList)this.getMe().getContainer()) {
            if (!frame.geom().equals(string)) continue;
            ++n2;
        }
        return n2 > 1;
    }

    public String getDvolName() {
        return this.f().isParticle() || this.f().isRay() ? "1" : "dvol" + this.varNameSuffix();
    }

    public String varNameSuffix() {
        return this.getMe().isMaterialFrame() ? "" : "_" + this.identifier();
    }

    public Frame getFixedRefFrame() {
        FrameFeature frameFeature;
        IFrameFeatureInternal iFrameFeatureInternal;
        EquationViewParent equationViewParent2;
        if (this.getMe().sshape().size() != 1) {
            return null;
        }
        if (this.getMe().isSpatialFrame()) {
            for (EquationViewParent equationViewParent2 : this.getMe().getPhysics()) {
                if (!equationViewParent2.isActive()) continue;
                return null;
            }
        }
        equationViewParent2 = null;
        Iterator<Physics> iterator = this.getMe().sshape().iterator();
        if (iterator.hasNext() && (iFrameFeatureInternal = (IFrameFeatureInternal)(frameFeature = (FrameFeature)iterator.next())).getType() == FrameFeatureType.FIXED_REF) {
            equationViewParent2 = iFrameFeatureInternal.getRefFrame();
        }
        if (equationViewParent2 != null) {
            for (Physics physics : equationViewParent2.getPhysics()) {
                if (!physics.isActive()) continue;
                return null;
            }
        }
        return equationViewParent2;
    }

    public boolean isSplitFromFrame(IFrame iFrame) {
        IFrameInternal iFrameInternal = (IFrameInternal)iFrame;
        if (this.n().equals(iFrame.tag())) {
            return false;
        }
        if (!this.getMe().geom().equals(iFrame.geom())) {
            return true;
        }
        FrameType frameType = FrameType.getFrameType(this.getMe());
        FrameType frameType2 = FrameType.getFrameType(iFrameInternal);
        if (frameType.ordinal() < frameType2.ordinal()) {
            IFrameInternal iFrameInternal2 = iFrameInternal.getFixedRefFrame();
            if (iFrameInternal2 != null) {
                return this.isSplitFromFrame(iFrameInternal2);
            }
        } else {
            IFrameInternal iFrameInternal3 = this.getMe().getFixedRefFrame();
            if (iFrameInternal3 != null) {
                return iFrame.isSplitFromFrame(iFrameInternal3);
            }
        }
        return true;
    }

    @Override
    public void batchKeySeed(StringBuilder stringBuilder) {
        if (this.f() == null || !this.f().isDeformed()) {
            super.batchKeySeed(stringBuilder);
        }
    }

    public String identifier() {
        IFrameInternal iFrameInternal = this.getMe();
        if (iFrameInternal.isMaterialFrame()) {
            return FrameType.material.name();
        }
        if (iFrameInternal.isSpatialFrame()) {
            return FrameType.spatial.name();
        }
        if (iFrameInternal.isGeometryFrame()) {
            return FrameType.geometry.name();
        }
        if (iFrameInternal.isMeshFrame()) {
            return FrameType.mesh.name();
        }
        return this.n();
    }

    public void createReset(Frame frame, boolean bl2) {
        IFrameInternal iFrameInternal = this.getMe();
        this.createResetCommon(frame, bl2);
        if (!bl2) {
            if (iFrameInternal.isGeometryFrame() && !frame.isGeometryFrame()) {
                frame.geometryFrame();
            }
            if (iFrameInternal.isMeshFrame() && !frame.isMeshFrame()) {
                frame.meshFrame();
            }
            if (iFrameInternal.isMaterialFrame() && !frame.isMaterialFrame()) {
                frame.materialFrame();
            }
            if (iFrameInternal.isSpatialFrame() && !frame.isSpatialFrame()) {
                frame.spatialFrame();
            }
            ((IFrameInternal)frame).setRenameCoordinates(true);
            Object[] objectArray = this.coord();
            if (!Arrays.equals(objectArray, frame.coord())) {
                frame.coord((String[])objectArray);
            }
            if (iFrameInternal.isMeshFrame() && iFrameInternal.sorder() != frame.sorder()) {
                ((IFrameInternal)frame).internalSetSorder(iFrameInternal.sorder());
            }
        } else if (!iFrameInternal.geom().equals(frame.geom())) {
            frame.geom(iFrameInternal.geom());
        }
        iFrameInternal.sshape().createReset(frame.sshape(), bl2);
    }

    @Override
    public void changeTag(String string, String string2) {
        if (this.getModel().selectionCacheEnabled()) {
            throw new IllegalStateException("Frame tags must not change during an internal update");
        }
        super.changeTag(string, string2);
    }

    public String[] getStoredCoordNames() {
        IFrameInternal iFrameInternal = this.getMe();
        if (!((ModelDb)this.getModel()).isReInitializingOldEmfCompleteSavePointModel() || iFrameInternal.isRenameCoordinates()) {
            return null;
        }
        return iFrameInternal.getCoord();
    }

    public LicenseRequirement[] multiphysics(StudyFeature studyFeature, EVAL eVAL) {
        String string;
        Object object;
        if (eVAL == EVAL.FINALIZE) {
            object = studyFeature != null ? ModelEntityUtil.getEntityPath(studyFeature) : "default";
            this.getMe().featureInfo("info").setStudyType((String)object);
        }
        if (eVAL != EVAL.SHAPE && eVAL != EVAL.VARIABLES) {
            return new LicenseRequirement[0];
        }
        object = this.getModel().physics().getVarData();
        SharedQuantityContainer sharedQuantityContainer = object.findSharedQuantityContainer(SharedQuantities.MovingFrame, string = this.getMe().getTag(), this.getModel());
        if (sharedQuantityContainer != null) {
            ((MovingFrameAbstractContainer)sharedQuantityContainer).doMultiphysics(this.getMe(), studyFeature, eVAL);
        }
        return new LicenseRequirement[0];
    }

    @Override
    public boolean isAutoGenerated() {
        return super.isAutoGenerated() || this.getMe().getGeom().isAutoGenerated();
    }
}

