/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.method;

import com.comsol.model.dbimodel.CopyPasteInfo;
import com.comsol.model.dbimodel.FunctionFeature;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.dbimodel.PropFeatureList;
import com.comsol.model.method.PropFeatureListMethod;
import com.comsol.model.operations.IFunctionOperation;
import com.comsol.model.operations.OperationManager;
import com.comsol.model.operations.OperationType;
import com.comsol.nativemph.xmesh.Xmesh;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.methods.FlStringUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FunctionFeatureListMethod<T extends FunctionFeature>
extends PropFeatureListMethod<T> {
    private boolean a = false;

    public FunctionFeatureListMethod(PrimitiveModelEntity primitiveModelEntity) {
        super(primitiveModelEntity);
    }

    @Override
    void a(PropFeature propFeature, PropFeature propFeature2, boolean bl2) {
        ((FunctionFeature)propFeature).createReset(propFeature2, bl2, this.a);
    }

    public String[] getAllowedOperations() {
        if (this.getMe().getContainer() instanceof FunctionFeature) {
            FunctionFeature functionFeature = (FunctionFeature)this.getMe().getContainer();
            return functionFeature.getOperation().getAllowedSubOperations();
        }
        return OperationManager.getAllowedSequenceOperations(OperationType.FUNCTION, this.getMe());
    }

    public void createReset(PropFeatureList<T> propFeatureList, boolean bl2, boolean bl3) {
        this.a = bl3;
        try {
            super.createReset(propFeatureList, null, bl2);
        }
        finally {
            this.a = false;
        }
    }

    public void updateBeforeSolve() {
        boolean bl2 = false;
        for (PropFeature propFeature : this.getMe()) {
            if (!propFeature.isActive() || !"MATLAB".equals(propFeature.getOperationID()) || !propFeature.getBoolean("clearsolve")) continue;
            bl2 = true;
        }
        if (bl2) {
            Xmesh.u();
            for (PropFeature propFeature : this.getMe()) {
                if (!propFeature.isActive() || !"MATLAB".equals(propFeature.getOperationID()) || !propFeature.getBoolean("clearsolve")) continue;
                propFeature.refresh();
            }
        }
    }

    public String[] files() {
        HashSet<String> hashSet = new HashSet<String>();
        for (PropFeature propFeature : this.getMe()) {
            if (propFeature.hasProperty("modelres")) {
                hashSet.add(propFeature.getString("modelres"));
            }
            if (propFeature.hasProperty("interpres")) {
                hashSet.add(propFeature.getString("interpres"));
            }
            Collections.addAll(hashSet, ((FunctionFeature)propFeature).feature().files());
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    @Override
    public List<String> toElementSyntax() {
        HashSet<String> hashSet = new HashSet<String>();
        for (PropFeature propFeature : this.getMe()) {
            String[] stringArray;
            if (!propFeature.isActive()) continue;
            FunctionFeature functionFeature = (FunctionFeature)propFeature;
            IFunctionOperation iFunctionOperation = (IFunctionOperation)propFeature.getOperation();
            String[] stringArray2 = stringArray = iFunctionOperation.getFunctionNames(functionFeature);
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                boolean bl2;
                String string = stringArray2[n3];
                if (hashSet.contains(string)) {
                    FlException flException = new FlException("Duplicate_function_name");
                    flException.addParameterPair("Function", functionFeature.getDisplayString());
                    flException.addParameterPair("Name", string);
                    throw flException;
                }
                boolean bl3 = bl2 = functionFeature.getDerivedFrom() != null || functionFeature.hasPropValue("relaxnamecheck") && functionFeature.getBoolean("relaxnamecheck");
                if (!(!bl2 && FlStringUtil.checkValidTag((String)string) || bl2 && FlStringUtil.isVariableName((String)string) || string.startsWith("root."))) {
                    FlException flException = new FlException("Invalid_function_name");
                    flException.addParameterPair("Function", functionFeature.getDisplayString());
                    flException.addParameterPair("Name", string);
                    throw flException;
                }
                hashSet.add(String.valueOf(functionFeature.scopeDot()) + string);
                ++n3;
            }
        }
        return super.toElementSyntax();
    }

    @Override
    public PropFeature resolveFeatureToCopy(String[] stringArray, Model model) {
        switch (stringArray.length) {
            case 1: {
                return model.func(stringArray[0]);
            }
            case 2: {
                return model.func(stringArray[0]).feature(stringArray[1]);
            }
            case 3: {
                return model.material(stringArray[0]).propertyGroup(stringArray[1]).func(stringArray[2]);
            }
            case 4: {
                return model.material(stringArray[0]).feature(stringArray[1]).propertyGroup(stringArray[2]).func(stringArray[3]);
            }
        }
        throw new FlException("Found_no_feature_to_copy");
    }

    public Set<String> getActiveGlobalFuncNames() {
        HashSet<String> hashSet = new HashSet<String>();
        for (PropFeature propFeature : this.getMe()) {
            if (!propFeature.isActive() || !propFeature.model().isEmpty()) continue;
            IFunctionOperation iFunctionOperation = (IFunctionOperation)propFeature.getOperation();
            String[] stringArray = iFunctionOperation.getFunctionNames(propFeature);
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string = stringArray[n3];
                hashSet.add(string);
                ++n3;
            }
        }
        return hashSet;
    }

    @Override
    protected String a(ModelEntity modelEntity, String string, CopyPasteInfo copyPasteInfo) {
        if (!(modelEntity instanceof FunctionFeature)) {
            return super.a(modelEntity, string, copyPasteInfo);
        }
        if (FlStringUtil.isNullOrEmpty((String)string) && Arrays.stream(copyPasteInfo.getIndexedReferences(true)).anyMatch(n2 -> copyPasteInfo.getCopiedObject(n2) == modelEntity)) {
            FunctionFeature functionFeature = (FunctionFeature)modelEntity;
            Object[] objectArray = functionFeature.getOperation().getFunctionNames(functionFeature);
            Set<String> set = this.getActiveGlobalFuncNames();
            if (set.containsAll(Arrays.asList(objectArray))) {
                if (functionFeature.getPasteInfo().isPastingFromAnotherModel()) {
                    if (objectArray.length > 1) {
                        functionFeature.getPasteInfo().addMessage("Pasted_objects_calls_functions_that_already_existed_in_application_X#" + Arrays.toString(objectArray), null);
                    } else {
                        functionFeature.getPasteInfo().addMessage("Pasted_objects_calls_a_function_that_already_existed_in_application_X#" + (String)objectArray[0], null);
                    }
                }
                return null;
            }
        }
        return super.a(modelEntity, string, copyPasteInfo);
    }
}

