/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.operations;

import com.comsol.model.applapi.SDimType;
import com.comsol.model.dbimodel.CommonFeature;
import com.comsol.model.dbimodel.MODEL_NODE_TYPES;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.ModelNode;
import com.comsol.model.operations.operationID.CommonFeatureOperationID;
import java.util.Collection;

public interface ICommonFeatureID {
    public String id();

    public String descr();

    public String shortName();

    public Collection<IAddCommonFeatureAction> getAddActions();

    public String getIcon();

    public SubListID getCurrentSubList(ModelEntity var1);

    public boolean mayAppearInSublist(SubListID var1);

    public boolean appliesToSDimType(SDimType var1);

    public boolean appliesToComponentType(MODEL_NODE_TYPES var1);

    public boolean hasSufficientLicenses();

    public boolean allowAsRootFeature();

    public boolean allowAsSubFeature(ICommonFeatureID var1);

    public static interface IAddCommonFeatureAction {
        public String getTag(SDimType var1);

        public boolean isApplicableToSubListContext(SubListID var1, CommonFeatureOperationID.AddContext var2);

        public String getDescription();

        public String getIcon();

        public String getTopicResourceKey();

        public String getRibbonHelpKey();

        public CommonFeature addCommonFeature(Model var1, ModelNode var2, Object var3);
    }

    public static interface ISubListID {
    }

    public static enum SubListID implements ISubListID
    {
        ROOT("Root", "root", null),
        COMMON_DEFINITIONS("Shared_properties", "common", "commondef"),
        MOVING_MESH("Moving_mesh", "ale", "ale"),
        DEFORMED_GEOMETRY("Deformed_geometry", "defgeom", "defgeom"),
        DOMAIN_PROPERTIES("Artificial_domains", "domprops", "domprops"),
        VARIABLE_UTILITIES("Variable_utilities", "varutil", "varutil"),
        MULTIPHYSICS_DEFINITIONS("Multiphysics_definitions", "mphdef", "mphdef"),
        CONTROLS("Reduced_model_inputs", "controls", "controls"),
        TOPOLOGY_OPTIMIZATION("Topology_optimization", "topopt", "topopt"),
        SHAPE_OPTIMIZATION("Shape_optimization", "shopt", "shopt"),
        GLOBAL_COMMON_DEFINITIONS("Shared_properties", "globalcommon", "commondef"),
        GLOBAL_CONTROLS("Reduced_order_modeling", "globalcontrols", "controls"),
        HIDDEN("Hidden_features", "hidden", null);

        private final String descr;
        private final String menuTag;
        private final String nodeGroupTypeValue;

        private SubListID(String string2, String string3, String string4) {
            this.descr = string2;
            this.menuTag = string3;
            this.nodeGroupTypeValue = string4;
        }

        public String descr() {
            return this.descr;
        }

        public String menuTag() {
            return this.menuTag;
        }

        public String nodeGroupTypePropValue() {
            return this.nodeGroupTypeValue;
        }

        public String icon() {
            return String.valueOf(this.name().toLowerCase()) + ".png";
        }

        public boolean topLevelItem() {
            switch (this) {
                case DOMAIN_PROPERTIES: {
                    return true;
                }
            }
            return false;
        }

        public boolean isAlwaysGrouped() {
            switch (this) {
                case COMMON_DEFINITIONS: 
                case MOVING_MESH: 
                case DEFORMED_GEOMETRY: 
                case DOMAIN_PROPERTIES: 
                case CONTROLS: 
                case TOPOLOGY_OPTIMIZATION: 
                case SHAPE_OPTIMIZATION: 
                case GLOBAL_CONTROLS: {
                    return true;
                }
            }
            return false;
        }

        public boolean canAppearInMixedNodeGroup() {
            switch (this) {
                case COMMON_DEFINITIONS: 
                case DOMAIN_PROPERTIES: 
                case GLOBAL_CONTROLS: {
                    return true;
                }
            }
            return !this.isAlwaysGrouped();
        }

        public boolean isGlobal() {
            switch (this) {
                case VARIABLE_UTILITIES: 
                case GLOBAL_COMMON_DEFINITIONS: 
                case GLOBAL_CONTROLS: {
                    return true;
                }
            }
            return false;
        }

        public boolean isComponentList() {
            switch (this) {
                case GLOBAL_COMMON_DEFINITIONS: 
                case GLOBAL_CONTROLS: {
                    return false;
                }
            }
            return true;
        }

        public static SubListID[] getAllVisibleSubLists() {
            return new SubListID[]{COMMON_DEFINITIONS, MOVING_MESH, DEFORMED_GEOMETRY, DOMAIN_PROPERTIES, MULTIPHYSICS_DEFINITIONS, VARIABLE_UTILITIES, CONTROLS, TOPOLOGY_OPTIMIZATION, SHAPE_OPTIMIZATION};
        }
    }
}

