/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.operations;

import com.comsol.model.analysis.IAnalysisOperation;
import com.comsol.model.applapi.IApplPostInfo;
import com.comsol.model.applapi.IGeometricNonlinearityProvider;
import com.comsol.model.applapi.IMultiphysicsItem;
import com.comsol.model.automodeling.IAutoMeshSuggestion;
import com.comsol.model.dbimodel.AbstractSelection;
import com.comsol.model.dbimodel.AssocUpdate;
import com.comsol.model.dbimodel.CommonFeature;
import com.comsol.model.dbimodel.GeomSequence;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.dbimodel.StudyFeature;
import com.comsol.model.element.IElementSyntaxContributor;
import com.comsol.model.operations.ICommonFeatureIdOperation;
import com.comsol.model.operations.IPropBlock;
import com.comsol.model.operations.IPropBlockOperation;
import com.comsol.model.selections.ISelectionFilter;
import com.comsol.model.util.EventManagerWrapper;
import com.comsol.model.util.EventWrapper;
import com.comsol.util.license.LicenseType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public interface ICommonFeatureOperation
extends IGeometricNonlinearityProvider,
IMultiphysicsItem,
ICommonFeatureIdOperation,
IPropBlockOperation<IPropBlock> {
    public void initialize(PropFeature var1);

    public ALEType getALEType();

    public boolean hasEquationView();

    public ISelectionFilter getSelectionFilter(AbstractSelection var1);

    public String shortScopeDot();

    public boolean hasOverrideFilter();

    public boolean isAnalysisCaseDeactivatable();

    public void postCreateInit();

    public List<IElementSyntaxContributor> toElementSyntax();

    public void addEventHandlers(EventManagerWrapper var1);

    public void handleEvent(EventWrapper var1);

    public String getIdentifier();

    public void setIdentifier(String var1);

    public String getIdentifierType();

    public boolean solveFor(IAnalysisOperation var1, ModelEntity var2);

    public IAutoMeshSuggestion getAutoMeshSuggestion(GeomSequence var1);

    public String getFieldGroupTag();

    public void updateModel();

    public int[] getAllowedEdims(CommonFeature var1, int var2);

    public void postAssocUpdateThis(AssocUpdate var1);

    public IApplPostInfo getPostInfo();

    public LicenseType[][] getLicenseRequirements(StudyFeature var1);

    default public boolean canHaveMeshContribution() {
        return false;
    }

    default public boolean allowDuplication() {
        return true;
    }

    public static enum ALEType {
        NONE("Unspecified[ALE_type]", EntityLevel.NONE),
        FIXED("Fixed[ALE_type]", EntityLevel.DOMAIN),
        PRESCRIBED("Prescribed[ALE_type]", EntityLevel.DOMAIN),
        ROTATING("Rotating[ALE_type]", EntityLevel.DOMAIN),
        FREE("Free", EntityLevel.DOMAIN),
        BOUNDARY_CONDITION("ALE_boundary_condition", EntityLevel.BOUNDARY),
        FIXED_BOUNDARY("Fixed_boundary", EntityLevel.BOUNDARY),
        FIXED_DEFORMED_GEOMETRY("Fixed_deformed_geometry", EntityLevel.DOMAIN),
        PRESCRIBED_DEFORMED_GEOMETRY("Prescribed_deformed_geometry", EntityLevel.DOMAIN),
        ROTATING_DEFORMED_GEOMETRY("Rotating_deformed_geometry", EntityLevel.DOMAIN),
        FREE_DEFORMED_GEOMETRY("Free_deformed_geometry", EntityLevel.DOMAIN),
        BOUNDARY_CONDITION_DEFORMED_GEOMETRY("Deformed_geometry_boundary_condition", EntityLevel.BOUNDARY),
        FIXED_BOUNDARY_DEFORMED_GEOMETRY("Deformed_geometry_fixed_boundary", EntityLevel.BOUNDARY);

        private String descr;
        private EntityLevel level;

        private ALEType(String string2, EntityLevel entityLevel) {
            this.descr = string2;
            this.level = entityLevel;
        }

        public static Collection<String> getAllValues() {
            ArrayList<String> arrayList = new ArrayList<String>(ALEType.values().length);
            ALEType[] aLETypeArray = ALEType.values();
            int n2 = aLETypeArray.length;
            int n3 = 0;
            while (n3 < n2) {
                ALEType aLEType = aLETypeArray[n3];
                arrayList.add(aLEType.name());
                ++n3;
            }
            return arrayList;
        }

        public static Collection<String> getAllDescrs() {
            ArrayList<String> arrayList = new ArrayList<String>(ALEType.values().length);
            ALEType[] aLETypeArray = ALEType.values();
            int n2 = aLETypeArray.length;
            int n3 = 0;
            while (n3 < n2) {
                ALEType aLEType = aLETypeArray[n3];
                arrayList.add(aLEType.descr);
                ++n3;
            }
            return arrayList;
        }

        public static String getDefaultValue() {
            return NONE.name();
        }

        public int edim(int n2) {
            return this.level.edimFun.apply(n2);
        }

        public boolean isMovingMesh() {
            switch (this) {
                case PRESCRIBED: 
                case ROTATING: 
                case FREE: 
                case BOUNDARY_CONDITION: {
                    return true;
                }
            }
            return false;
        }

        public boolean isDeformedGeometry() {
            switch (this) {
                case PRESCRIBED_DEFORMED_GEOMETRY: 
                case ROTATING_DEFORMED_GEOMETRY: 
                case FREE_DEFORMED_GEOMETRY: 
                case BOUNDARY_CONDITION_DEFORMED_GEOMETRY: {
                    return true;
                }
            }
            return false;
        }

        public boolean isBoundaryCondition() {
            switch (this) {
                case BOUNDARY_CONDITION: 
                case BOUNDARY_CONDITION_DEFORMED_GEOMETRY: {
                    return true;
                }
            }
            return false;
        }
    }

    public static enum EntityLevel {
        DOMAIN(n2 -> n2),
        BOUNDARY(n2 -> n2 - 1),
        EDGE(n2 -> 1),
        POINT(n2 -> 0),
        NONE(n2 -> -1);

        public final Function<Integer, Integer> edimFun;

        private EntityLevel(Function<Integer, Integer> function) {
            this.edimFun = function;
        }
    }
}

