/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.operations.operationID;

import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.dbimodel.ReducedModel;
import com.comsol.model.operations.operationID.IOperationID;
import com.comsol.systemutils.SystemUtil;
import com.comsol.util.license.LicenseType;
import com.comsol.util.license.d;

public enum ReducedModelOperationID implements IOperationID
{
    ModalFrequency("Frequency_domain_modal_reduced_order_model", "modal_frequency_reduced_model.png", "rom"),
    ModalTransient("Time_dependent_modal_reduced_order_model", "modal_transient_reduced_model.png", "rom"),
    AWE("Frequency_domain_AWE_reduced_order_model", "awe.png", "rom"),
    RandomVibration("Random_vibration", "random_vibration.png", "rvib"),
    Legacy("Reduced_model", "reduced_model.png", "rom");

    private String descr;
    private String icon;
    private String shortName;

    private ReducedModelOperationID(String string2, String string3, String string4) {
        this.descr = string2;
        this.icon = string3;
        this.shortName = string4;
    }

    @Override
    public String descr() {
        return this.descr;
    }

    @Override
    public String id() {
        return this.name();
    }

    @Override
    public String shortName() {
        return this.shortName;
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    public String addAction() {
        return "add_" + this.name();
    }

    @Override
    public boolean isOfType(PropFeature propFeature) {
        return propFeature instanceof ReducedModel && this.name().equals(propFeature.getOperationID());
    }

    @Override
    public boolean isOfType(String string) {
        return this.name().equals(string);
    }

    public static ReducedModelOperationID get(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        ReducedModelOperationID[] reducedModelOperationIDArray = ReducedModelOperationID.values();
        int n2 = reducedModelOperationIDArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ReducedModelOperationID reducedModelOperationID = reducedModelOperationIDArray[n3];
            if (reducedModelOperationID.id().equals(string)) {
                return reducedModelOperationID;
            }
            ++n3;
        }
        return null;
    }

    public boolean isDevelopPreview() {
        switch (this) {
            case RandomVibration: {
                return false;
            }
        }
        return true;
    }

    public boolean canAppearInMenu() {
        if (this == Legacy) {
            return false;
        }
        if (!this.hasSufficientLicenses()) {
            return false;
        }
        if (this.isDevelopPreview()) {
            return SystemUtil.isDevelop() && SystemUtil.isTechnologyPreview();
        }
        return true;
    }

    public boolean hasSufficientLicenses() {
        switch (this) {
            case RandomVibration: {
                return d.a((LicenseType[])new LicenseType[]{LicenseType.STRUCTURALMECHANICS, LicenseType.MEMS});
            }
        }
        return true;
    }
}

