/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.operations.operationID;

import java.util.Locale;

public enum ViewOperationID {
    MODELVIEW3D("ModelView3D", "view", "View", "view3d.png", 3),
    MODELVIEW2D("ModelView2D", "view", "View", "view2d.png", 2),
    MODELVIEW1D("ModelView1D", "view", "View", "view3d.png", 1),
    RESULTVIEW3D("ResultView3D", "view", "View_3D", "view3d.png", 3),
    RESULTVIEW2D("ResultView2D", "view", "View_2D", "view2d.png", 2),
    DIAGRAMVIEW("DiagramView", "view", "View", "view2d.png", 2),
    DIAGRAMAXIS("DiagramAxis", "axis", "Axis", "view_axis.png", 2),
    AXIS3D("Axis3D", "axis", "Axis", "view_axis.png", 3),
    AXIS2D("Axis2D", "axis", "Axis", "view_axis.png", 2),
    AXIS1D("Axis1D", "axis", "Axis", "view_axis.png", 1),
    CAMERA("Camera", "cam", "Camera", "camera.png", 3),
    DIRECTIONALLIGHT("DirectionalLight", "lgt", "Directional_light", "directional_light.png", 3),
    POINTLIGHT("PointLight", "lgt", "Point_light", "point_light.png", 3),
    SPOTLIGHT("SpotLight", "lgt", "Spotlight", "spotlight.png", 3),
    HEADLIGHT("HeadLight", "lgt", "Head_light", "headlight.png", 3);

    private String idString;
    private String shortName;
    private String description;
    private String icon;
    private int viewDim;
    public static final int MAX_LIGHTS = 8;
    public static final String[] NONE;
    public static final String[] MODELVIEWS;
    public static final String[] RESULTVIEWS;
    public static final String[] VIEWS3D;
    public static final String[] LIGHTS;

    static {
        NONE = new String[0];
        MODELVIEWS = new String[]{MODELVIEW3D.toString(), MODELVIEW2D.toString(), MODELVIEW1D.toString()};
        RESULTVIEWS = new String[]{RESULTVIEW3D.toString(), RESULTVIEW2D.toString()};
        VIEWS3D = new String[]{MODELVIEW3D.toString(), RESULTVIEW3D.toString()};
        LIGHTS = new String[]{DIRECTIONALLIGHT.toString(), POINTLIGHT.toString(), SPOTLIGHT.toString(), HEADLIGHT.toString()};
    }

    private ViewOperationID(String string2, String string3, String string4, String string5, int n3) {
        this.idString = string2;
        this.shortName = string3;
        this.description = string4;
        this.icon = string5;
        this.viewDim = n3;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIcon() {
        return this.icon;
    }

    public int getViewDim() {
        return this.viewDim;
    }

    public String toString() {
        return this.idString;
    }

    public static ViewOperationID getID(String string) {
        ViewOperationID viewOperationID = null;
        try {
            viewOperationID = ViewOperationID.valueOf(string.toUpperCase(Locale.ENGLISH));
        }
        catch (Throwable throwable) {}
        return viewOperationID;
    }
}

