/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.properties;

import com.comsol.model.data.events.IEventHandler;
import com.comsol.model.data.events.ListEvent;
import com.comsol.model.data.events.NAMED_EVENT;
import com.comsol.model.data.events.NODE_EVENT_TYPES;
import com.comsol.model.data.events.NodeEvent;
import com.comsol.model.data.primitive.ParamValuePrim;
import com.comsol.model.data.primitive.PropValuePrim;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.ModelEntityList;
import com.comsol.model.dbimodel.ParameterContainer;
import com.comsol.model.dbimodel.ParameterEntity;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.dbimodel.SelectionEntity;
import com.comsol.model.impl.events.PropFeatureEventHandlerFactory;
import com.comsol.model.operations.operationID.ReducedModelOperationID;
import com.comsol.model.properties.IPropCheckEventHandler;
import com.comsol.model.properties.IPropCheckEventHandlerInitializer;
import com.comsol.model.util.EventManagerWrapper;
import com.comsol.model.util.MetaModelUtil;
import com.comsol.model.util.ModelEntityUtil;
import com.comsol.util.classes.FlStringList;
import com.comsol.util.interfaces.u;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public class PropCheckEventUtil {
    private static final List<NODE_EVENT_TYPES> a;

    static {
        ArrayList<NODE_EVENT_TYPES> arrayList = new ArrayList<NODE_EVENT_TYPES>(NODE_EVENT_TYPES.LIST_EVENTS);
        arrayList.remove((Object)NODE_EVENT_TYPES.ADDCHILD);
        arrayList.remove((Object)NODE_EVENT_TYPES.ANYCHILD);
        a = Collections.unmodifiableList(arrayList);
    }

    public static String makeCompositeTag(String string, String string2) {
        return String.valueOf(PropFeatureEventHandlerFactory.Tag.propcheck_event_.name()) + string + "#" + string2;
    }

    public static String getPropNameFromCompositeTag(String string) {
        String string2 = string.substring(PropFeatureEventHandlerFactory.Tag.propcheck_event_.name().length());
        return string2.split("#")[0];
    }

    public static String getTagFromCompositeTag(String string) {
        int n2 = string.indexOf("#");
        return string.substring(n2 + 1);
    }

    public static String[] getOldStringArray(NodeEvent nodeEvent) {
        if (nodeEvent.isPropertyEvent()) {
            return ((PropValuePrim)nodeEvent.getOldValue()).getValueArray()[0];
        }
        if (nodeEvent.isParameterEvent()) {
            return (String[])Arrays.stream(((ParamValuePrim)((ListEvent)nodeEvent.getNewValue()).getOldObject()).getValue()).map(stringArray -> stringArray[0]).toArray(String[]::new);
        }
        throw new UnsupportedOperationException("Event is neither a property nor parameter event\n:Event: " + nodeEvent.toString());
    }

    public static String[] getNewStringArray(NodeEvent nodeEvent) {
        if (nodeEvent.isPropertyEvent()) {
            return ((PropValuePrim)nodeEvent.getNewValue()).getValueArray()[0];
        }
        if (nodeEvent.isParameterEvent()) {
            return (String[])Arrays.stream(((ParamValuePrim)((ListEvent)nodeEvent.getNewValue()).getNewObject()).getValue()).map(stringArray -> stringArray[0]).toArray(String[]::new);
        }
        throw new UnsupportedOperationException("Event is neither a property nor parameter event\n:Event: " + nodeEvent.toString());
    }

    public static String getOldString(NodeEvent nodeEvent) {
        if (nodeEvent.isPropertyEvent()) {
            return ((PropValuePrim)nodeEvent.getOldValue()).getValue();
        }
        if (nodeEvent.isParameterEvent()) {
            return ((ParamValuePrim)((ListEvent)nodeEvent.getNewValue()).getOldObject()).getString();
        }
        throw new UnsupportedOperationException("Event is neither a property nor parameter event\n:Event: " + nodeEvent.toString());
    }

    public static String getNewString(NodeEvent nodeEvent) {
        if (nodeEvent.isPropertyEvent()) {
            return ((PropValuePrim)nodeEvent.getNewValue()).getValue();
        }
        if (nodeEvent.isParameterEvent()) {
            return ((ParamValuePrim)((ListEvent)nodeEvent.getNewValue()).getNewObject()).getString();
        }
        throw new UnsupportedOperationException("Event is neither a property nor parameter event\n:Event: " + nodeEvent.toString());
    }

    public static void setValue(ModelEntity modelEntity, String string, String string2) {
        if (modelEntity instanceof PropFeature) {
            ((PropFeature)modelEntity).set(string, string2);
        } else if (modelEntity instanceof ParameterContainer) {
            ((ParameterContainer)((Object)modelEntity)).set(string, string2);
        } else {
            throw new IllegalArgumentException("Set value not supported by type: " + ModelEntityUtil.getInterfaceClassName(modelEntity));
        }
    }

    public static void setValue(ModelEntity modelEntity, String string, String[] stringArray) {
        if (modelEntity instanceof PropFeature) {
            ((PropFeature)modelEntity).set(string, stringArray);
        } else if (modelEntity instanceof ParameterContainer) {
            ((ParameterContainer)((Object)modelEntity)).set(string, stringArray);
        } else {
            throw new IllegalArgumentException("Set value not supported by type: " + ModelEntityUtil.getInterfaceClassName(modelEntity));
        }
    }

    public static abstract class AbstractModelEntityReferenceEventUpdater<T extends ModelEntity>
    implements IPropCheckEventHandler<T>,
    IPropCheckEventHandlerInitializer<T> {
        protected String g;

        public AbstractModelEntityReferenceEventUpdater(String string) {
            this.g = string;
        }

        @Override
        public void handleEvent(T t2, NodeEvent nodeEvent, String string) {
            if (ModelEntityReferenceEventTag.targetPropertyChanged.name().equals(string)) {
                EventManagerWrapper eventManagerWrapper = new EventManagerWrapper((PrimitiveModelEntity)t2);
                for (ModelEntity modelEntity : this.b(t2, nodeEvent)) {
                    eventManagerWrapper.removeNamedEventHandler(modelEntity, PropCheckEventUtil.makeCompositeTag(this.g, ModelEntityReferenceEventTag.refRetagged.name()), (IEventHandler)t2, NAMED_EVENT.RETAG, MetaModelUtil.META_EVENT_INFO.MODIFY_VOLATILE, new String[0]);
                    eventManagerWrapper.removeEntityEventHandler(modelEntity, PropCheckEventUtil.makeCompositeTag(this.g, ModelEntityReferenceEventTag.refRemoved.name()), (IEventHandler)t2, NODE_EVENT_TYPES.REMOVE, MetaModelUtil.META_EVENT_INFO.MODIFY_VOLATILE);
                    eventManagerWrapper.removeNamedEventHandler(modelEntity, PropCheckEventUtil.makeCompositeTag(this.g, ModelEntityReferenceEventTag.refActiveChanged.name()), (IEventHandler)t2, NAMED_EVENT.ACTIVE, MetaModelUtil.META_EVENT_INFO.MODIFY_VOLATILE, new String[0]);
                }
                for (ModelEntity modelEntity : this.a(t2, nodeEvent)) {
                    eventManagerWrapper.addNamedEventHandler(modelEntity, PropCheckEventUtil.makeCompositeTag(this.g, ModelEntityReferenceEventTag.refRetagged.name()), (IEventHandler)t2, NAMED_EVENT.RETAG, MetaModelUtil.META_EVENT_INFO.MODIFY_VOLATILE, new String[0]);
                    eventManagerWrapper.addEntityEventHandler(modelEntity, PropCheckEventUtil.makeCompositeTag(this.g, ModelEntityReferenceEventTag.refRemoved.name()), (IEventHandler)t2, NODE_EVENT_TYPES.REMOVE, MetaModelUtil.META_EVENT_INFO.MODIFY_VOLATILE);
                    eventManagerWrapper.addNamedEventHandler(modelEntity, PropCheckEventUtil.makeCompositeTag(this.g, ModelEntityReferenceEventTag.refActiveChanged.name()), (IEventHandler)t2, NAMED_EVENT.ACTIVE, MetaModelUtil.META_EVENT_INFO.MODIFY_VOLATILE, new String[0]);
                }
            } else if (ModelEntityReferenceEventTag.refRetagged.name().equals(string)) {
                this.a(t2, nodeEvent.getOldString(), nodeEvent.getNewString(), nodeEvent);
            } else if (ModelEntityReferenceEventTag.refRemoved.name().equals(string)) {
                this.a(t2, nodeEvent.getEntity().getTag(), nodeEvent);
            } else if (ModelEntityReferenceEventTag.refActiveChanged.name().equals(string)) {
                this.a(t2, nodeEvent.getEntity().getTag(), ((ModelEntity)nodeEvent.getEntity()).isActive(), nodeEvent);
            }
        }

        @Override
        public void initialize(T t2, String string, EventManagerWrapper eventManagerWrapper) {
            if (t2 instanceof PropFeature) {
                eventManagerWrapper.addPropertyEventHandler((PropFeature)t2, PropCheckEventUtil.makeCompositeTag(string, ModelEntityReferenceEventTag.targetPropertyChanged.name()), (IEventHandler)t2, MetaModelUtil.META_EVENT_INFO.MODIFY_PERMANENT, string);
            } else if (t2 instanceof ParameterEntity) {
                eventManagerWrapper.addParameterEventHandler((ParameterEntity)t2, PropCheckEventUtil.makeCompositeTag(string, ModelEntityReferenceEventTag.targetPropertyChanged.name()), (IEventHandler)t2, MetaModelUtil.META_EVENT_INFO.MODIFY_PERMANENT, string);
            }
        }

        @Override
        public void reInitialize(T t2, String string, EventManagerWrapper eventManagerWrapper) {
            this.initialize(t2, string, eventManagerWrapper);
            for (ModelEntity modelEntity : this.a(t2)) {
                eventManagerWrapper.addNamedEventHandler(modelEntity, PropCheckEventUtil.makeCompositeTag(string, ModelEntityReferenceEventTag.refRetagged.name()), (IEventHandler)t2, NAMED_EVENT.RETAG, MetaModelUtil.META_EVENT_INFO.MODIFY_VOLATILE, new String[0]);
                eventManagerWrapper.addEntityEventHandler(modelEntity, PropCheckEventUtil.makeCompositeTag(string, ModelEntityReferenceEventTag.refRemoved.name()), (IEventHandler)t2, NODE_EVENT_TYPES.REMOVE, MetaModelUtil.META_EVENT_INFO.MODIFY_VOLATILE);
                eventManagerWrapper.addNamedEventHandler(modelEntity, PropCheckEventUtil.makeCompositeTag(string, ModelEntityReferenceEventTag.refActiveChanged.name()), (IEventHandler)t2, NAMED_EVENT.ACTIVE, MetaModelUtil.META_EVENT_INFO.MODIFY_VOLATILE, new String[0]);
            }
        }

        protected abstract Collection<ModelEntity> b(T var1, NodeEvent var2);

        protected abstract Collection<ModelEntity> a(T var1, NodeEvent var2);

        protected abstract Collection<ModelEntity> a(T var1);

        protected void a(T t2, String string, String string2, NodeEvent nodeEvent) {
        }

        protected void a(T t2, String string, NodeEvent nodeEvent) {
        }

        protected void a(T t2, String string, boolean bl2, NodeEvent nodeEvent) {
        }

        protected static Collection<ModelEntity> a(ModelEntityList modelEntityList, String[] stringArray, String[] stringArray2, String string) {
            Object object;
            if (modelEntityList == null) {
                return Collections.emptyList();
            }
            HashSet hashSet = new HashSet();
            Collections.addAll(hashSet, stringArray);
            Object object2 = stringArray2;
            int n2 = stringArray2.length;
            int n3 = 0;
            while (n3 < n2) {
                object = object2[n3];
                hashSet.remove(object);
                ++n3;
            }
            object = new ArrayList();
            for (String string2 : hashSet) {
                Object object3 = object2 = string2.startsWith(string) ? string2.substring(string.length()) : string2;
                if (!modelEntityList.hasTag((String)object2)) continue;
                object.add(modelEntityList.get((String)object2));
            }
            return object;
        }
    }

    public static class AnyChildEventInitializer
    implements IPropCheckEventHandlerInitializer<PropFeature>,
    IPropCheckEventHandlerRemover {
        public static final String eventTag = "anyChild";
        private ModelEntityList a;
        private MetaModelUtil.META_EVENT_INFO b = MetaModelUtil.META_EVENT_INFO.MODIFY_PERMANENT;
        private boolean c = false;

        public AnyChildEventInitializer(ModelEntityList modelEntityList) {
            this.a = modelEntityList;
        }

        public AnyChildEventInitializer makeVolatile() {
            this.b = MetaModelUtil.META_EVENT_INFO.MODIFY_VOLATILE;
            return this;
        }

        public AnyChildEventInitializer useNamedEventForAdd() {
            this.c = true;
            return this;
        }

        @Override
        public void initialize(PropFeature propFeature, String string, EventManagerWrapper eventManagerWrapper) {
            if (this.a != null) {
                if (this.c) {
                    eventManagerWrapper.addNamedEventHandler(this.a, PropCheckEventUtil.makeCompositeTag(string, eventTag), propFeature, NAMED_EVENT.ADDCHILD_INITIALIZED, this.b, new String[0]);
                    for (NODE_EVENT_TYPES nODE_EVENT_TYPES : a) {
                        eventManagerWrapper.addListEventHandler(this.a, PropCheckEventUtil.makeCompositeTag(string, eventTag), propFeature, nODE_EVENT_TYPES, this.b);
                    }
                } else {
                    eventManagerWrapper.addListEventHandler(this.a, PropCheckEventUtil.makeCompositeTag(string, eventTag), propFeature, NODE_EVENT_TYPES.ANYCHILD, this.b);
                }
            }
        }

        @Override
        public void remove(ModelEntity modelEntity, String string, EventManagerWrapper eventManagerWrapper) {
            if (this.c) {
                eventManagerWrapper.removeNamedEventHandler(this.a, PropCheckEventUtil.makeCompositeTag(string, eventTag), modelEntity, NAMED_EVENT.ADDCHILD_INITIALIZED, this.b, new String[0]);
                for (NODE_EVENT_TYPES nODE_EVENT_TYPES : a) {
                    eventManagerWrapper.removeListEventHandler(this.a, PropCheckEventUtil.makeCompositeTag(string, eventTag), modelEntity, nODE_EVENT_TYPES, this.b);
                }
            } else {
                eventManagerWrapper.removeListEventHandler(this.a, PropCheckEventUtil.makeCompositeTag(string, eventTag), modelEntity, NODE_EVENT_TYPES.ANYCHILD, this.b);
            }
        }
    }

    public static class ChildActiveEventInitializer
    implements IPropCheckEventHandlerInitializer<PropFeature>,
    IPropCheckEventHandlerRemover {
        public static final String eventTag = "activeChanged";
        private ModelEntityList a;
        private MetaModelUtil.META_EVENT_INFO b = MetaModelUtil.META_EVENT_INFO.MODIFY_PERMANENT;

        public ChildActiveEventInitializer(ModelEntityList modelEntityList) {
            this.a = modelEntityList;
        }

        public ChildActiveEventInitializer makeVolatile() {
            this.b = MetaModelUtil.META_EVENT_INFO.MODIFY_VOLATILE;
            return this;
        }

        @Override
        public void initialize(PropFeature propFeature, String string, EventManagerWrapper eventManagerWrapper) {
            eventManagerWrapper.addAllChildrenNamedEventHandler(this.a, PropCheckEventUtil.makeCompositeTag(string, eventTag), propFeature, NAMED_EVENT.ACTIVE, this.b);
        }

        @Override
        public void remove(ModelEntity modelEntity, String string, EventManagerWrapper eventManagerWrapper) {
            eventManagerWrapper.removeAllChildrenNamedEventHandler(this.a, PropCheckEventUtil.makeCompositeTag(string, eventTag), modelEntity, NAMED_EVENT.ACTIVE, this.b);
        }
    }

    public static class ChildRetaggedEventInitializer
    implements IPropCheckEventHandlerInitializer<PropFeature>,
    IPropCheckEventHandlerRemover {
        public static final String eventTag = "childRetagged";
        private ModelEntityList a;
        private MetaModelUtil.META_EVENT_INFO b = MetaModelUtil.META_EVENT_INFO.MODIFY_PERMANENT;

        public ChildRetaggedEventInitializer(ModelEntityList modelEntityList) {
            this.a = modelEntityList;
        }

        public ChildRetaggedEventInitializer makeVolatile() {
            this.b = MetaModelUtil.META_EVENT_INFO.MODIFY_VOLATILE;
            return this;
        }

        @Override
        public void initialize(PropFeature propFeature, String string, EventManagerWrapper eventManagerWrapper) {
            eventManagerWrapper.addAllChildrenNamedEventHandler(this.a, PropCheckEventUtil.makeCompositeTag(string, eventTag), propFeature, NAMED_EVENT.RETAG, this.b);
        }

        @Override
        public void remove(ModelEntity modelEntity, String string, EventManagerWrapper eventManagerWrapper) {
            eventManagerWrapper.removeAllChildrenNamedEventHandler(this.a, PropCheckEventUtil.makeCompositeTag(string, eventTag), modelEntity, NAMED_EVENT.RETAG, this.b);
        }
    }

    public static class ChildTouchedEventInitializer
    implements IPropCheckEventHandlerInitializer<PropFeature>,
    IPropCheckEventHandlerRemover {
        public static final String eventTag = "childTouched";
        private ModelEntityList a;
        private MetaModelUtil.META_EVENT_INFO b = MetaModelUtil.META_EVENT_INFO.MODIFY_PERMANENT;

        public ChildTouchedEventInitializer(ModelEntityList modelEntityList) {
            this.a = modelEntityList;
        }

        public ChildTouchedEventInitializer makeVolatile() {
            this.b = MetaModelUtil.META_EVENT_INFO.MODIFY_VOLATILE;
            return this;
        }

        @Override
        public void initialize(PropFeature propFeature, String string, EventManagerWrapper eventManagerWrapper) {
            eventManagerWrapper.addAllChildrenNamedEventHandler(this.a, PropCheckEventUtil.makeCompositeTag(string, eventTag), propFeature, NAMED_EVENT.TOUCHED, this.b);
        }

        @Override
        public void remove(ModelEntity modelEntity, String string, EventManagerWrapper eventManagerWrapper) {
            eventManagerWrapper.removeAllChildrenNamedEventHandler(this.a, PropCheckEventUtil.makeCompositeTag(string, eventTag), modelEntity, NAMED_EVENT.TOUCHED, this.b);
        }
    }

    public static class FeatureTouchedEventInitializer
    implements IPropCheckEventHandlerInitializer<PropFeature> {
        public static final String eventTag = "touched";

        @Override
        public void initialize(PropFeature propFeature, String string, EventManagerWrapper eventManagerWrapper) {
            eventManagerWrapper.addNamedEventHandler(propFeature, PropCheckEventUtil.makeCompositeTag(string, eventTag), propFeature, NAMED_EVENT.TOUCHED, MetaModelUtil.META_EVENT_INFO.MODIFY_PERMANENT, new String[0]);
        }
    }

    public static class FirstValidStringDefault
    implements IDynamicDefaultApplier {
        @Override
        public void applyDynamicDefault(SelectionEntity selectionEntity, String string) {
            String[] stringArray = ((PropFeature)selectionEntity).getAllowedPropertyValues(string);
            if (stringArray == null || stringArray.length <= 0) {
                throw new RuntimeException("Internal error: property has no valid values.");
            }
            ((PropFeature)selectionEntity).set(string, stringArray[0]);
        }
    }

    public static class FrameChangeEventInitializer
    implements IPropCheckEventHandlerInitializer<PropFeature> {
        public static final String eventTagSuffix = "FrameAttributeChanged";

        @Override
        public void initialize(PropFeature propFeature, String string, EventManagerWrapper eventManagerWrapper) {
            eventManagerWrapper.addAllChildrenAttributeEventHandler(propFeature.getModel().geom(), PropCheckEventUtil.makeCompositeTag(string, "spatialFrameAttributeChanged"), propFeature, "spatialFrame", MetaModelUtil.META_EVENT_INFO.MODIFY_PERMANENT);
            eventManagerWrapper.addAllChildrenAttributeEventHandler(propFeature.getModel().geom(), PropCheckEventUtil.makeCompositeTag(string, "materialFrameAttributeChanged"), propFeature, "materialFrame", MetaModelUtil.META_EVENT_INFO.MODIFY_PERMANENT);
            eventManagerWrapper.addAllChildrenAttributeEventHandler(propFeature.getModel().geom(), PropCheckEventUtil.makeCompositeTag(string, "geometryFrameAttributeChanged"), propFeature, "geometryFrame", MetaModelUtil.META_EVENT_INFO.MODIFY_PERMANENT);
            eventManagerWrapper.addAllChildrenAttributeEventHandler(propFeature.getModel().geom(), PropCheckEventUtil.makeCompositeTag(string, "meshFrameAttributeChanged"), propFeature, "meshFrame", MetaModelUtil.META_EVENT_INFO.MODIFY_PERMANENT);
            eventManagerWrapper.addAllChildrenAttributeEventHandler(propFeature.getModel().geom(), PropCheckEventUtil.makeCompositeTag(string, "storedParentFrameAttributeChanged"), propFeature, "storedParent", MetaModelUtil.META_EVENT_INFO.MODIFY_PERMANENT);
        }
    }

    public static interface IAllowedValueProvider<T extends ModelEntity> {
        public boolean accept(u var1, String var2, String var3);

        public Collection<IPropCheckEventHandlerInitializer> getEventHandlerInitializers(T var1, String var2);

        public Collection<IPropCheckEventHandler> getEventHandlers(T var1, String var2);

        public String describeValid(PropFeature var1, String var2);

        default public Map<String, String> getValidValuesDescrsMapOrNull(u u2, String string) {
            return null;
        }

        default public ModelEntity getEntityOrNull(u u2, String string, String string2) {
            return null;
        }

        default public String getValueOrNull(u u2, String string, ModelEntity modelEntity) {
            return null;
        }
    }

    public static interface IDynamicDefaultApplier {
        public void applyDynamicDefault(SelectionEntity var1, String var2);

        default public PropFeature getParentForAutoUpdateKey() {
            return null;
        }
    }

    public static interface IPropCheckEventHandlerRemover {
        public void remove(ModelEntity var1, String var2, EventManagerWrapper var3);
    }

    public static enum ModelEntityReferenceEventTag {
        targetPropertyChanged,
        refRetagged,
        refRemoved,
        refActiveChanged,
        validValuesAdded,
        filterConditionsChanged,
        listChanged;

    }

    public static class ModelListReferenceEventUpdater<T extends ModelEntity>
    extends AbstractModelEntityReferenceEventUpdater<T> {
        protected Supplier<ModelEntityList> a;
        protected IDynamicDefaultApplier b;
        protected String c;
        protected boolean d = false;

        public ModelListReferenceEventUpdater(ModelEntityList modelEntityList, String string, IDynamicDefaultApplier iDynamicDefaultApplier, String string2) {
            this(() -> modelEntityList, string, iDynamicDefaultApplier, string2);
        }

        public ModelListReferenceEventUpdater(Supplier<ModelEntityList> supplier, String string, IDynamicDefaultApplier iDynamicDefaultApplier, String string2) {
            super(string);
            this.a = supplier;
            this.b = iDynamicDefaultApplier;
            this.c = string2;
        }

        public ModelListReferenceEventUpdater<T> handleDisableAsRemove(boolean bl2) {
            this.d = bl2;
            return this;
        }

        @Override
        protected Collection<ModelEntity> b(T t2, NodeEvent nodeEvent) {
            String string = PropCheckEventUtil.getOldString(nodeEvent);
            return this.a(string);
        }

        @Override
        protected Collection<ModelEntity> a(T t2, NodeEvent nodeEvent) {
            String string = PropCheckEventUtil.getNewString(nodeEvent);
            return this.a(string);
        }

        @Override
        protected Collection<ModelEntity> a(T t2) {
            String string = ((u)t2).getString(this.g);
            return this.a(string);
        }

        @Override
        protected Collection<ModelEntity> a(String string) {
            String string2 = string.startsWith(this.c) ? string.substring(this.c.length()) : string;
            ModelEntityList modelEntityList = this.a.get();
            if (modelEntityList != null && modelEntityList.hasTag(string2)) {
                return Collections.singletonList(modelEntityList.get(string2));
            }
            return Collections.emptyList();
        }

        @Override
        protected void a(T t2, String string, String string2, NodeEvent nodeEvent) {
            if (t2 instanceof PropFeature && ((PropFeature)t2).getString(this.g).equals(String.valueOf(this.c) + string)) {
                boolean bl2 = false;
                PropFeature propFeature = this.b.getParentForAutoUpdateKey();
                if (propFeature != null) {
                    bl2 = !propFeature.isStateKeyChanged();
                }
                ((PropFeature)t2).set(this.g, String.valueOf(this.c) + string2);
                if (bl2) {
                    propFeature.saveStateKey();
                }
            }
        }

        @Override
        protected void a(T t2, String string, NodeEvent nodeEvent) {
            if (t2 instanceof PropFeature && ((PropFeature)t2).getString(this.g).equals(String.valueOf(this.c) + string)) {
                boolean bl2 = false;
                PropFeature propFeature = this.b.getParentForAutoUpdateKey();
                if (propFeature != null) {
                    bl2 = !propFeature.isStateKeyChanged();
                }
                this.b.applyDynamicDefault((PropFeature)t2, this.g);
                if (bl2) {
                    propFeature.saveStateKey();
                }
            }
        }

        @Override
        protected void a(T t2, String string, boolean bl2, NodeEvent nodeEvent) {
            if (this.d && !bl2) {
                this.a(t2, string, null);
            }
        }
    }

    public static class ModelListReferenceListEventUpdater<T extends u & ModelEntity>
    extends ModelListReferenceEventUpdater<T> {
        public ModelListReferenceListEventUpdater(Supplier<ModelEntityList> supplier, String string, IDynamicDefaultApplier iDynamicDefaultApplier, String string2) {
            super(supplier, string, iDynamicDefaultApplier, string2);
        }

        @Override
        protected Collection<ModelEntity> a(T t2, NodeEvent nodeEvent) {
            return ModelListReferenceListEventUpdater.a((ModelEntityList)this.a.get(), PropCheckEventUtil.getOldStringArray(nodeEvent), PropCheckEventUtil.getNewStringArray(nodeEvent), this.c);
        }

        @Override
        protected Collection<ModelEntity> b(T t2, NodeEvent nodeEvent) {
            return ModelListReferenceListEventUpdater.a((ModelEntityList)this.a.get(), PropCheckEventUtil.getNewStringArray(nodeEvent), PropCheckEventUtil.getOldStringArray(nodeEvent), this.c);
        }

        @Override
        protected Collection<ModelEntity> a(T t2) {
            ArrayList<ModelEntity> arrayList = new ArrayList<ModelEntity>();
            String[] stringArray = t2.getStringArray(this.g);
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string = stringArray[n3];
                String string2 = string.startsWith(this.c) ? string.substring(this.c.length()) : string;
                ModelEntityList modelEntityList = (ModelEntityList)this.a.get();
                if (modelEntityList != null && modelEntityList.hasTag(string2)) {
                    arrayList.add((ModelEntity)modelEntityList.get(string2));
                }
                ++n3;
            }
            return arrayList;
        }

        @Override
        protected void a(T t2, String string, String string2, NodeEvent nodeEvent) {
            String[] stringArray = t2.getStringArray(this.g);
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2].equals(String.valueOf(this.c) + string)) {
                    stringArray[n2] = String.valueOf(this.c) + string2;
                    break;
                }
                ++n2;
            }
            PropCheckEventUtil.setValue((ModelEntity)t2, this.g, stringArray);
        }

        @Override
        protected void a(T t2, String string, NodeEvent nodeEvent) {
            String[] stringArray = t2.getStringArray(this.g);
            String[] stringArray2 = (String[])Stream.of(stringArray).filter(string2 -> !string2.equals(String.valueOf(this.c) + string)).toArray(String[]::new);
            if (stringArray2.length < stringArray.length) {
                PropCheckEventUtil.setValue((ModelEntity)t2, this.g, stringArray2);
            }
        }

        @Override
        protected /* synthetic */ Collection a(ModelEntity modelEntity, NodeEvent nodeEvent) {
            return this.b((u)modelEntity, nodeEvent);
        }

        @Override
        protected /* synthetic */ Collection b(ModelEntity modelEntity, NodeEvent nodeEvent) {
            return this.a((u)modelEntity, nodeEvent);
        }
    }

    public static class ModelListReferenceListProvider
    extends ModelListReferenceProvider<ModelEntity> {
        public ModelListReferenceListProvider(ModelEntityList modelEntityList) {
            super(modelEntityList, "");
        }

        public ModelListReferenceListProvider(Supplier<ModelEntityList> supplier, IDynamicDefaultApplier iDynamicDefaultApplier) {
            super(supplier, iDynamicDefaultApplier);
        }

        @Override
        public Collection<IPropCheckEventHandler> getEventHandlers(ModelEntity modelEntity, String string) {
            ArrayList<IPropCheckEventHandler> arrayList = new ArrayList<IPropCheckEventHandler>();
            arrayList.add(new ModelListReferenceListEventUpdater(this.b, string, null, this.d).handleDisableAsRemove(this.h));
            return arrayList;
        }

        @Override
        public Collection<IPropCheckEventHandlerInitializer> getEventHandlerInitializers(ModelEntity modelEntity, String string) {
            ArrayList<IPropCheckEventHandlerInitializer> arrayList = new ArrayList<IPropCheckEventHandlerInitializer>();
            arrayList.add(new ModelListReferenceListEventUpdater(this.b, string, null, this.d).handleDisableAsRemove(this.h));
            arrayList.addAll(this.a(ModelListReferenceListProvider.getFilterConditionsChangedEventTag(string, new String[0])));
            arrayList.addAll(this.b(ModelListReferenceListProvider.getListChangedEventTag(string, new String[0])));
            return arrayList;
        }

        @Override
        protected void a(PropFeature propFeature, String string, NodeEvent nodeEvent, String string2) {
            this.a(propFeature, string);
        }

        @Override
        protected void a(PropFeature propFeature, String string, ModelEntityList modelEntityList, NodeEvent nodeEvent, String string2) {
            String[] stringArray = propFeature.getStringArray(string);
            FlStringList flStringList = new FlStringList();
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string3;
                String string4 = stringArray2[n3];
                String string5 = string3 = string4.startsWith(this.d) ? string4.substring(this.d.length()) : string4;
                if (!modelEntityList.hasTag(string3)) {
                    flStringList.add(string4);
                }
                ++n3;
            }
            if (flStringList.size() < stringArray.length) {
                propFeature.set(string, flStringList.toArray());
            }
        }

        private void a(PropFeature propFeature, String string) {
            String[] stringArray = propFeature.getStringArray(string);
            FlStringList flStringList = new FlStringList();
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string2 = stringArray2[n3];
                if (propFeature.getPropValueInternal(string).getProperty().getCheck().isValid(string2)) {
                    flStringList.add(string2);
                }
                ++n3;
            }
            if (flStringList.size() < stringArray.length) {
                propFeature.set(string, flStringList.toArray());
            }
        }
    }

    public static class ModelListReferenceProvider<T extends ModelEntity>
    implements IAllowedValueProvider<T> {
        protected Supplier<ModelEntityList> b;
        private ModelEntityList a;
        protected IDynamicDefaultApplier c;
        protected String d;
        protected boolean e = false;
        protected Predicate<ModelEntity> f;
        protected boolean g = false;
        protected boolean h = false;

        public ModelListReferenceProvider(ModelEntityList modelEntityList, String string) {
            this(() -> modelEntityList, (IDynamicDefaultApplier)new StaticStringDefault(string));
        }

        public ModelListReferenceProvider(ModelEntityList modelEntityList, IDynamicDefaultApplier iDynamicDefaultApplier) {
            this(() -> modelEntityList, iDynamicDefaultApplier);
        }

        public ModelListReferenceProvider(Supplier<ModelEntityList> supplier, IDynamicDefaultApplier iDynamicDefaultApplier) {
            this.b = supplier;
            this.c = iDynamicDefaultApplier;
            this.d = "";
            this.e = false;
            this.f = modelEntity -> true;
        }

        public ModelListReferenceProvider setTagPrefix(String string) {
            this.d = string;
            return this;
        }

        public ModelListReferenceProvider setEntityFilter(Predicate<ModelEntity> predicate) {
            this.f = predicate;
            this.e = true;
            return this;
        }

        protected Predicate<ModelEntity> a(u u2) {
            return this.f;
        }

        protected Supplier<ModelEntityList> b(u u2) {
            return this.b;
        }

        public ModelListReferenceProvider replaceEmptyWhenPossible() {
            this.g = true;
            return this;
        }

        public ModelListReferenceProvider handleDisableAsRemove() {
            this.h = true;
            return this;
        }

        public ModelListReferenceProvider autoUpdateParentKey(final Supplier<PropFeature> supplier) {
            final IDynamicDefaultApplier iDynamicDefaultApplier = this.c;
            this.c = new IDynamicDefaultApplier(){

                @Override
                public void applyDynamicDefault(SelectionEntity selectionEntity, String string) {
                    iDynamicDefaultApplier.applyDynamicDefault(selectionEntity, string);
                }

                @Override
                public PropFeature getParentForAutoUpdateKey() {
                    return (PropFeature)supplier.get();
                }
            };
            return this;
        }

        @Override
        public boolean accept(u u2, String string, String string2) {
            ModelEntityList modelEntityList = this.b(u2).get();
            if (string2 == null || modelEntityList == null) {
                return false;
            }
            String string3 = string2.startsWith(this.d) ? string2.substring(this.d.length()) : string2;
            return this.e ? modelEntityList.stream().filter(this.a(u2)).anyMatch(modelEntity -> modelEntity.tag().equals(string3)) : modelEntityList.hasTag(string3);
        }

        @Override
        public Map<String, String> getValidValuesDescrsMapOrNull(u u2, String string) {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            ModelEntityList modelEntityList = this.b(u2).get();
            if (modelEntityList != null) {
                modelEntityList.stream().filter(this.a(u2)).forEach(modelEntity -> {
                    String string = linkedHashMap.put(String.valueOf(this.d) + modelEntity.tag(), this.a((ModelEntity)modelEntity));
                });
            }
            return linkedHashMap;
        }

        protected String a(ModelEntity modelEntity) {
            return "#" + modelEntity.getDisplayString();
        }

        @Override
        public Collection<IPropCheckEventHandlerInitializer> getEventHandlerInitializers(T t2, String string) {
            ArrayList<IPropCheckEventHandlerInitializer> arrayList = new ArrayList<IPropCheckEventHandlerInitializer>();
            arrayList.add(this.a(t2, string));
            if (this.g) {
                arrayList.add(new IPropCheckEventHandlerInitializer<PropFeature>(){

                    public void a(PropFeature propFeature, String string, EventManagerWrapper eventManagerWrapper) {
                        a = this.b(propFeature).get();
                        if (a != null) {
                            eventManagerWrapper.addListEventHandler(a, PropCheckEventUtil.makeCompositeTag(string, ModelEntityReferenceEventTag.validValuesAdded.name()), propFeature, NODE_EVENT_TYPES.ADDCHILD, MetaModelUtil.META_EVENT_INFO.MODIFY_VOLATILE);
                        }
                    }

                    public void b(PropFeature propFeature, String string, EventManagerWrapper eventManagerWrapper) {
                        this.a(propFeature, string, eventManagerWrapper);
                        String string2 = propFeature.getString(string);
                        if (string2.isEmpty() && !this.getValidValuesDescrsMapOrNull(propFeature, string).isEmpty()) {
                            c.applyDynamicDefault(propFeature, string);
                        }
                    }

                    @Override
                    public /* synthetic */ void initialize(Object object, String string, EventManagerWrapper eventManagerWrapper) {
                        this.a((PropFeature)object, string, eventManagerWrapper);
                    }

                    @Override
                    public /* synthetic */ void reInitialize(Object object, String string, EventManagerWrapper eventManagerWrapper) {
                        this.b((PropFeature)object, string, eventManagerWrapper);
                    }
                });
            } else {
                arrayList.add(new IPropCheckEventHandlerInitializer<T>(){

                    public void a(T t2, String string, EventManagerWrapper eventManagerWrapper) {
                        a = this.b((u)t2).get();
                    }

                    @Override
                    public /* synthetic */ void initialize(Object object, String string, EventManagerWrapper eventManagerWrapper) {
                        this.a((ModelEntity)object, string, eventManagerWrapper);
                    }
                });
            }
            arrayList.addAll(this.a(ModelListReferenceProvider.getFilterConditionsChangedEventTag(string, new String[0])));
            arrayList.addAll(this.b(ModelListReferenceProvider.getListChangedEventTag(string, new String[0])));
            return arrayList;
        }

        protected AbstractModelEntityReferenceEventUpdater<T> a(T t2, String string) {
            return new ModelListReferenceEventUpdater(this.b((u)t2), string, this.c, this.d).handleDisableAsRemove(this.h);
        }

        protected Collection<IPropCheckEventHandlerInitializer> a(String string) {
            return Collections.emptyList();
        }

        protected Collection<IPropCheckEventHandlerInitializer> b(String string) {
            return Collections.emptyList();
        }

        @Override
        public Collection<IPropCheckEventHandler> getEventHandlers(T t2, final String string) {
            ArrayList<IPropCheckEventHandler> arrayList = new ArrayList<IPropCheckEventHandler>();
            arrayList.add(this.a(t2, string));
            if (this.g) {
                arrayList.add(new IPropCheckEventHandler<PropFeature>(){

                    public void a(PropFeature propFeature, NodeEvent nodeEvent, String string2) {
                        if (ModelEntityReferenceEventTag.validValuesAdded.name().equals(string2) && propFeature.getString(string).isEmpty()) {
                            c.applyDynamicDefault(propFeature, string);
                        }
                    }

                    @Override
                    public /* synthetic */ void handleEvent(ModelEntity modelEntity, NodeEvent nodeEvent, String string2) {
                        this.a((PropFeature)modelEntity, nodeEvent, string2);
                    }
                });
            }
            arrayList.add(new IPropCheckEventHandler<T>(){

                @Override
                public void handleEvent(T t2, NodeEvent nodeEvent, String string2) {
                    ModelEntityList modelEntityList;
                    if (string2.startsWith(ModelEntityReferenceEventTag.filterConditionsChanged.name()) && t2 instanceof PropFeature) {
                        this.a((PropFeature)t2, string, nodeEvent, string2);
                    }
                    if (string2.startsWith(ModelEntityReferenceEventTag.listChanged.name()) && t2 instanceof PropFeature && (nodeEvent.type != NODE_EVENT_TYPES.REMOVE && nodeEvent.type != NODE_EVENT_TYPES.REMOVECHILD || nodeEvent.getEntity() != t2) && (modelEntityList = this.b((u)t2).get()) != a) {
                        if (g) {
                            EventManagerWrapper eventManagerWrapper = new EventManagerWrapper((PrimitiveModelEntity)t2);
                            if (a != null) {
                                eventManagerWrapper.removeListEventHandler(a, PropCheckEventUtil.makeCompositeTag(string, ModelEntityReferenceEventTag.validValuesAdded.name()), (IEventHandler)t2, NODE_EVENT_TYPES.ADDCHILD, MetaModelUtil.META_EVENT_INFO.MODIFY_VOLATILE);
                            }
                            if (modelEntityList != null) {
                                eventManagerWrapper.addListEventHandler(modelEntityList, PropCheckEventUtil.makeCompositeTag(string, ModelEntityReferenceEventTag.validValuesAdded.name()), (IEventHandler)t2, NODE_EVENT_TYPES.ADDCHILD, MetaModelUtil.META_EVENT_INFO.MODIFY_VOLATILE);
                            }
                        }
                        this.a((PropFeature)t2, string, a, nodeEvent, string2);
                        a = modelEntityList;
                    }
                }
            });
            return arrayList;
        }

        protected void a(PropFeature propFeature, String string, NodeEvent nodeEvent, String string2) {
            if (!propFeature.getPropValueInternal(string).getProperty().getCheck().isValid(propFeature.getString(string))) {
                this.c.applyDynamicDefault(propFeature, string);
            }
        }

        protected void a(PropFeature propFeature, String string, ModelEntityList modelEntityList, NodeEvent nodeEvent, String string2) {
            this.c.applyDynamicDefault(propFeature, string);
        }

        @Override
        public String describeValid(PropFeature propFeature, String string) {
            ModelEntityList modelEntityList = this.b(propFeature).get();
            if (modelEntityList == null) {
                return "No_valid_value_exists";
            }
            if (modelEntityList.stream().noneMatch(this.a(propFeature))) {
                return "No_valid_X_tag_exists#" + modelEntityList.getFeatureTypeDescription();
            }
            String string2 = "A_valid_tag_one_of_X";
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("#");
            int n2 = 0;
            String[] stringArray = (String[])modelEntityList.stream().filter(this.a(propFeature)).map(modelEntity -> String.valueOf(this.d) + modelEntity.tag()).toArray(String[]::new);
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String string3 = stringArray[n4];
                stringBuilder.append(string3);
                if (++n2 > 8) {
                    stringBuilder.append(",...");
                    break;
                }
                if (n2 < modelEntityList.size()) {
                    stringBuilder.append(", ");
                }
                ++n4;
            }
            return String.valueOf(string2) + stringBuilder.toString();
        }

        @Override
        public ModelEntity getEntityOrNull(u u2, String string, String string2) {
            if (string2 == null) {
                return null;
            }
            String string3 = string2.startsWith(this.d) ? string2.substring(this.d.length()) : string2;
            ModelEntityList modelEntityList = this.b(u2).get();
            return this.e ? (modelEntityList.stream().filter(this.a(u2)).anyMatch(modelEntity -> modelEntity.tag().equals(string3)) ? modelEntityList.get(string3) : null) : modelEntityList.get(string3);
        }

        @Override
        public String getValueOrNull(u u2, String string, ModelEntity modelEntity) {
            return modelEntity != null ? String.valueOf(this.d) + modelEntity.tag() : null;
        }

        public static String getFilterConditionsChangedEventTag(String string, String ... stringArray) {
            String string2 = PropCheckEventUtil.makeCompositeTag(string, ModelEntityReferenceEventTag.filterConditionsChanged.name());
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string3 = stringArray2[n3];
                string2 = String.valueOf(string2) + "_" + string3;
                ++n3;
            }
            return string2;
        }

        public static String getListChangedEventTag(String string, String ... stringArray) {
            String string2 = PropCheckEventUtil.makeCompositeTag(string, ModelEntityReferenceEventTag.listChanged.name());
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string3 = stringArray2[n3];
                string2 = String.valueOf(string2) + "_" + string3;
                ++n3;
            }
            return string2;
        }
    }

    public static class NoneProvider
    extends StaticStringProvider {
        public NoneProvider() {
            super(new String[]{"none"}, new String[]{"None"});
        }

        @Override
        public String describeValid(PropFeature propFeature, String string) {
            return "The_string_none";
        }
    }

    public static class NullOrEmptyProvider
    implements IAllowedValueProvider<ModelEntity> {
        @Override
        public boolean accept(u u2, String string, String string2) {
            return string2 == null || "".equals(string2);
        }

        @Override
        public Collection<IPropCheckEventHandlerInitializer> getEventHandlerInitializers(ModelEntity modelEntity, String string) {
            return Collections.emptyList();
        }

        @Override
        public Collection<IPropCheckEventHandler> getEventHandlers(ModelEntity modelEntity, String string) {
            return Collections.emptyList();
        }

        @Override
        public Map<String, String> getValidValuesDescrsMapOrNull(u u2, String string) {
            return Collections.singletonMap("", "");
        }

        @Override
        public String describeValid(PropFeature propFeature, String string) {
            return "An_empty_string_or_null";
        }
    }

    public static class PropertyChangedEventInitializer
    implements IPropCheckEventHandlerInitializer<PropFeature> {
        public String eventTag;
        private String[] a;

        public PropertyChangedEventInitializer(String string, String ... stringArray) {
            this.eventTag = string;
            this.a = stringArray;
        }

        @Override
        public void initialize(PropFeature propFeature, String string2, EventManagerWrapper eventManagerWrapper) {
            String[] stringArray = (String[])Stream.of(this.a).filter(string -> propFeature.hasProperty((String)string)).toArray(String[]::new);
            if (stringArray.length > 0) {
                eventManagerWrapper.addPropertyEventHandler(propFeature, PropCheckEventUtil.makeCompositeTag(string2, this.eventTag), propFeature, MetaModelUtil.META_EVENT_INFO.MODIFY_PERMANENT, stringArray);
            }
        }
    }

    public static abstract class PropertySynchronizer
    implements IPropCheckEventHandler<PropFeature>,
    IPropCheckEventHandlerInitializer<PropFeature> {
        String b;

        public PropertySynchronizer(String string) {
            this.b = string;
        }

        @Override
        public void initialize(PropFeature propFeature, String string, EventManagerWrapper eventManagerWrapper) {
            eventManagerWrapper.addPropertyEventHandler(propFeature, PropCheckEventUtil.makeCompositeTag(string, "masterPropChanged"), propFeature, MetaModelUtil.META_EVENT_INFO.MODIFY_PERMANENT, string);
            eventManagerWrapper.addPropertyEventHandler(propFeature, PropCheckEventUtil.makeCompositeTag(string, "slavePropChanged"), propFeature, MetaModelUtil.META_EVENT_INFO.MODIFY_PERMANENT, this.b);
            this.a(propFeature);
        }

        @Override
        public void reInitialize(PropFeature propFeature, String string, EventManagerWrapper eventManagerWrapper) {
            IPropCheckEventHandlerInitializer.super.reInitialize(propFeature, string, eventManagerWrapper);
            this.a(propFeature);
        }

        @Override
        public void handleEvent(PropFeature propFeature, NodeEvent nodeEvent, String string) {
            if ("masterPropChanged".equals(string)) {
                this.a(propFeature);
            }
            if ("slavePropChanged".equals(string)) {
                this.b(propFeature);
            }
        }

        protected abstract void a(PropFeature var1);

        protected abstract void b(PropFeature var1);
    }

    public static class ReconstructionCapabilityChangedInitializer
    implements IPropCheckEventHandlerInitializer<PropFeature> {
        public String eventTag;

        public ReconstructionCapabilityChangedInitializer(String string) {
            this.eventTag = string;
        }

        @Override
        public void initialize(PropFeature propFeature, String string, EventManagerWrapper eventManagerWrapper) {
            eventManagerWrapper.addAllChildrenNamedEventHandler((ModelEntityList<? extends ModelEntity>)propFeature.getModel().reduced(), PropCheckEventUtil.makeCompositeTag(string, this.eventTag), propFeature, NAMED_EVENT.RECONSTRTUCTION_CAPABILITY_CHANGED, MetaModelUtil.META_EVENT_INFO.MODIFY_PERMANENT, new MetaModelUtil.TypeFilter(new String[]{ReducedModelOperationID.ModalFrequency.id(), ReducedModelOperationID.ModalTransient.id()}));
        }
    }

    public static class StaticStringDefault
    implements IDynamicDefaultApplier {
        private String a;

        public StaticStringDefault(String string) {
            this.a = string;
        }

        @Override
        public void applyDynamicDefault(SelectionEntity selectionEntity, String string) {
            ((PropFeature)selectionEntity).set(string, this.a);
        }
    }

    public static class StaticStringProvider
    implements IAllowedValueProvider<ModelEntity> {
        private final Map<String, String> a = new HashMap<String, String>();

        public StaticStringProvider(String[] stringArray, String[] stringArray2) {
            int n2 = 0;
            while (n2 < stringArray.length) {
                this.a.put(stringArray[n2], stringArray2[n2]);
                ++n2;
            }
        }

        @Override
        public boolean accept(u u2, String string, String string2) {
            return this.a.containsKey(string2);
        }

        @Override
        public Collection<IPropCheckEventHandlerInitializer> getEventHandlerInitializers(ModelEntity modelEntity, String string) {
            return Collections.emptyList();
        }

        @Override
        public Collection<IPropCheckEventHandler> getEventHandlers(ModelEntity modelEntity, String string) {
            return Collections.emptyList();
        }

        @Override
        public Map<String, String> getValidValuesDescrsMapOrNull(u u2, String string) {
            return this.a;
        }

        @Override
        public String describeValid(PropFeature propFeature, String string) {
            String string2 = "One_of_the_strings_X#";
            boolean bl2 = true;
            for (String string3 : this.a.keySet()) {
                if (bl2) {
                    bl2 = false;
                } else {
                    string3 = String.valueOf(string3) + ", ";
                }
                string2 = String.valueOf(string2) + string3;
            }
            return string2;
        }
    }
}

