/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.selections;

import com.comsol.model.data.SelectionOutOfBoundsException;
import com.comsol.model.dbimodel.AbstractSelection;
import com.comsol.model.dbimodel.AssocUpdate;
import com.comsol.model.dbimodel.GeomSequence;
import com.comsol.model.dbimodel.HideMesh;
import com.comsol.model.dbimodel.MESH_TYPES;
import com.comsol.model.dbimodel.MeshFeature;
import com.comsol.model.dbimodel.MeshFeatureList;
import com.comsol.model.dbimodel.MeshSelection;
import com.comsol.model.dbimodel.MeshSelectionContainer;
import com.comsol.model.dbimodel.MeshSequence;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.PropValue;
import com.comsol.model.dbimodel.SEL_TYPES;
import com.comsol.model.dbimodel.Selection;
import com.comsol.model.method.MeshSequenceMethod;
import com.comsol.model.method.PrimitiveModelEntityMethod;
import com.comsol.model.method.SelectionSynchMethod;
import com.comsol.model.method.internal.IMeshSelectionInternal;
import com.comsol.model.savepoint.interfaces.IGeomSequence;
import com.comsol.model.selections.ISelectionFilter;
import com.comsol.model.selections.LocalSelectionMethod;
import com.comsol.model.selections.SelectionMethod;
import com.comsol.util.classes.CsBitSet;
import com.comsol.util.classes.an;
import com.comsol.util.exceptions.FlException;
import java.util.HashSet;

public class MeshSelectionMethod
extends LocalSelectionMethod {
    public MeshSelectionMethod(IMeshSelectionInternal iMeshSelectionInternal, SelectionSynchMethod selectionSynchMethod, PrimitiveModelEntity primitiveModelEntity) {
        super(iMeshSelectionInternal, selectionSynchMethod, primitiveModelEntity);
    }

    @Override
    public IMeshSelectionInternal getSel() {
        return (IMeshSelectionInternal)super.getSel();
    }

    @Override
    public void createDuplicate(Selection selection) {
        if (this.getSel().isRemaining() && !this.getSel().isLocked()) {
            ((MeshSelection)selection).remaining();
        }
        super.createDuplicate(selection);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void createReset(AbstractSelection abstractSelection, boolean bl2) {
        IMeshSelectionInternal iMeshSelectionInternal = this.getSel();
        if (iMeshSelectionInternal.isLocked()) {
            return;
        }
        if (bl2 && iMeshSelectionInternal.isRemaining()) {
            boolean bl3 = abstractSelection.isLocked();
            abstractSelection.setLocked(false);
            try {
                if (abstractSelection.getSelType() == SEL_TYPES.MESHREMAINING) return;
                ((MeshSelection)abstractSelection).remaining();
                return;
            }
            finally {
                abstractSelection.setLocked(bl3);
            }
        } else {
            super.createReset(abstractSelection, bl2);
        }
    }

    @Override
    protected String a(String[] stringArray, SelectionMethod selectionMethod) {
        if (this.getParent() instanceof MeshFeature) {
            String string;
            IGeomSequence iGeomSequence = this.getSel().getGeomSequence();
            if (iGeomSequence.isDeformed()) {
                iGeomSequence = iGeomSequence.getUndefGeom();
            }
            Model model = selectionMethod.b();
            if (this.getParent().isClipboardCopy() && (string = this.getParent().getPasteInfo().getPastedPath("/GeomList/" + iGeomSequence.tag())) != null) {
                iGeomSequence = model.geom(string.substring(string.lastIndexOf(47) + 1));
            }
            String[] stringArray2 = stringArray;
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                string = stringArray2[n3];
                GeomSequence geomSequence = model.geom(string);
                if (geomSequence.isDeformed() && geomSequence.getUndefGeom() == iGeomSequence || geomSequence.isMeshPart()) {
                    return string;
                }
                ++n3;
            }
        }
        return super.a(stringArray, selectionMethod);
    }

    @Override
    protected void a(Selection selection, int[] nArray) {
        if (selection.getGeomSequence() != null && selection.getGeomSequence().isDefinedByMesh()) {
            selection.set(nArray);
        } else {
            super.a(selection, nArray);
        }
    }

    @Override
    public int getNEntities(int n2) {
        MeshSequence meshSequence = this.getMeshingSequence();
        if (meshSequence == null) {
            return super.getNEntities(n2);
        }
        IGeomSequence iGeomSequence = this.getSel().getGeomSequence();
        if (!iGeomSequence.isDefinedByMesh() || iGeomSequence.getSDim() == 0) {
            return iGeomSequence.getNEntitiesMesh()[n2];
        }
        return meshSequence.infoCurrent().getNEntities()[n2];
    }

    public MeshSequence getMeshingSequence() {
        MeshSequence meshSequence = this.getSel().getSourceMesh();
        if (meshSequence != null) {
            return meshSequence;
        }
        PrimitiveModelEntityMethod primitiveModelEntityMethod = this.getParent().method();
        while (primitiveModelEntityMethod != null && !(primitiveModelEntityMethod instanceof MeshSequenceMethod)) {
            primitiveModelEntityMethod = primitiveModelEntityMethod.getContainer();
        }
        if (primitiveModelEntityMethod == null) {
            return null;
        }
        return (MeshSequence)primitiveModelEntityMethod.getMe();
    }

    @Override
    public int[] entities(int n2, boolean bl2) {
        if (this.b.getSelType() != SEL_TYPES.MESHREMAINING) {
            return super.entities(n2, bl2);
        }
        MeshFeature meshFeature = (MeshFeature)this.getParent();
        int n3 = meshFeature.getSequence().getSDim();
        if (n2 < 0 || n2 > n3) {
            throw new IllegalArgumentException("Illegal_input_argument");
        }
        int[][] nArray = this.q();
        return (int[])nArray[n2].clone();
    }

    @Override
    public int[] dimension() {
        if (this.b.getSelType() != SEL_TYPES.MESHREMAINING) {
            return super.dimension();
        }
        int[][] nArray = this.q();
        int n2 = 0;
        int n3 = 0;
        while (n3 < nArray.length) {
            if (nArray[n3].length > 0) {
                ++n2;
            }
            ++n3;
        }
        int[] nArray2 = new int[n2];
        n2 = 0;
        int n4 = 0;
        while (n4 < nArray.length) {
            if (nArray[n4].length > 0) {
                nArray2[n2++] = n4;
            }
            ++n4;
        }
        return nArray2;
    }

    @Override
    public String geom() {
        if (this.b.getSelType() != SEL_TYPES.MESHREMAINING) {
            return super.geom();
        }
        return ((MeshFeature)this.getParent()).getSequence().getGeom().tag();
    }

    @Override
    public IGeomSequence getGeomSequence() {
        if (this.b.getSelType() != SEL_TYPES.MESHREMAINING) {
            return super.getGeomSequence();
        }
        return ((MeshFeature)this.getParent()).getSequence().getGeom();
    }

    @Override
    public boolean set(int[] nArray) {
        boolean bl2 = super.set(nArray);
        if (bl2) {
            this.n();
            this.o();
        }
        return bl2;
    }

    @Override
    public boolean add(int[] nArray) {
        boolean bl2 = super.add(nArray);
        if (bl2) {
            this.n();
            this.o();
        }
        return bl2;
    }

    @Override
    public boolean remove(int[] nArray) {
        boolean bl2 = super.remove(nArray);
        if (bl2) {
            this.n();
            this.o();
        }
        return bl2;
    }

    @Override
    protected boolean g() {
        return true;
    }

    @Override
    public boolean geom(String string, int n2) {
        boolean bl2 = super.geom(string, n2);
        if (bl2) {
            this.n();
            this.o();
        }
        return bl2;
    }

    @Override
    public boolean all() {
        boolean bl2 = super.all();
        if (bl2) {
            this.n();
            this.o();
        }
        return bl2;
    }

    @Override
    public boolean geom(String string) {
        boolean bl2 = super.geom(string);
        if (bl2) {
            this.n();
            this.o();
        }
        return bl2;
    }

    @Override
    public void named(String string) {
        this.checkNamedAllowed();
        super.named(string);
    }

    public void remaining() {
        IMeshSelectionInternal iMeshSelectionInternal = this.getSel();
        this.checkIsLocked();
        this.checkType(ISelectionFilter.SelectionType.MESHREMAINING);
        String string = this.getSelectionStringKey();
        this.e();
        this.c();
        iMeshSelectionInternal.setRemainingEntities(null);
        iMeshSelectionInternal.setSelType(SEL_TYPES.MESHREMAINING);
        this.checkTouched(string);
    }

    private void n() {
        MeshSelectionContainer meshSelectionContainer;
        PrimitiveModelEntity primitiveModelEntity = this.getParent();
        if (primitiveModelEntity instanceof MeshSelectionContainer && (!((meshSelectionContainer = (MeshSelectionContainer)((Object)primitiveModelEntity)) instanceof MeshFeature) || meshSelectionContainer.getSequence().getType() == MESH_TYPES.IMPORTED)) {
            ((MeshSelectionContainer)((Object)primitiveModelEntity)).setIgnoreAssocData(this.p(), true);
        }
    }

    private void o() {
        PrimitiveModelEntity primitiveModelEntity = this.getParent();
        if (primitiveModelEntity instanceof MeshFeature) {
            String string = this.p();
            MeshFeature meshFeature = (MeshFeature)primitiveModelEntity;
            if (meshFeature.getSequence().getType() == MESH_TYPES.IMPORTED) {
                int[] nArray = this.dimension();
                if (nArray.length > 1) {
                    meshFeature.setSelInCorrectState(string, true);
                }
                assert (nArray[0] >= 0);
                if (this.entities(nArray[0]).length == 0) {
                    meshFeature.setSelInCorrectState(string, true);
                } else if (meshFeature.isSelInCorrectState(string)) {
                    meshFeature.setSelInCorrectState(string, this.a(meshFeature));
                }
            }
        }
    }

    private String p() {
        Object object = this.b.getContainer();
        if (object instanceof PropValue) {
            PropValue propValue = (PropValue)object;
            return propValue.getPropertyName();
        }
        return null;
    }

    private boolean a(MeshFeature meshFeature) {
        MeshSequence meshSequence = meshFeature.getSequence();
        MeshFeatureList<? extends MeshFeature> meshFeatureList = meshSequence.feature();
        int n2 = meshFeatureList.index(meshFeature.tag());
        if (n2 == -1) {
            return true;
        }
        if (n2 == 0) {
            return false;
        }
        MeshFeature meshFeature2 = null;
        while (n2 >= 1) {
            meshFeature2 = (MeshFeature)meshFeatureList.get(n2 - 1);
            if (meshFeature2.isActive()) break;
            --n2;
        }
        return meshFeature2 != null && meshFeature2 == meshSequence.getLastBuiltFeature() && meshFeature2.isBuilt();
    }

    @Override
    public void assocUpdate(AssocUpdate assocUpdate) {
        if (assocUpdate.sequence != this.getGeomSequence()) {
            return;
        }
        if (assocUpdate.sequence.isDefinedByMesh() && this.selectOnMeshGeom()) {
            PrimitiveModelEntityMethod primitiveModelEntityMethod = this.getParent().method();
            while (primitiveModelEntityMethod != null && !(primitiveModelEntityMethod instanceof MeshSequenceMethod)) {
                primitiveModelEntityMethod = primitiveModelEntityMethod.getContainer();
            }
            if (primitiveModelEntityMethod == null || ((MeshSequence)primitiveModelEntityMethod.getMe()).getGeom() == assocUpdate.sequence) {
                return;
            }
        }
        super.assocUpdate(assocUpdate);
        this.getSel().setRemainingEntities(null);
    }

    @Override
    protected int a(IGeomSequence iGeomSequence, int n2) {
        if (this.getMeshingSequence() != null) {
            return iGeomSequence.getNEntitiesMesh()[n2];
        }
        return super.a(iGeomSequence, n2);
    }

    @Override
    protected CsBitSet a(int n2, CsBitSet csBitSet) {
        if (this.getSel().getNamedSelection() == null) {
            return csBitSet;
        }
        return ((GeomSequence)this.getGeomSequence()).mapGeomToMeshGeom(n2, csBitSet);
    }

    @Override
    protected int a(int[] nArray, int n2, int n3) {
        MeshSequence meshSequence = this.getMeshingSequence();
        if (meshSequence == null || meshSequence.getType() != MESH_TYPES.IMPORTED) {
            return super.a(nArray, n2, 0);
        }
        int n4 = 0;
        while (n4 < nArray.length) {
            if (nArray[n4] <= 0) {
                throw new SelectionOutOfBoundsException("Illegal_input_vector_illegal_entity_number");
            }
            n2 = Math.max(n2, nArray[n4]);
            ++n4;
        }
        return n2;
    }

    public void checkNamedAllowed() {
        if (this.getGeomSequence() != null && this.getGeomSequence().isDefinedByMesh()) {
            PrimitiveModelEntity primitiveModelEntity = this.getParent();
            MeshSequence meshSequence = null;
            if (primitiveModelEntity instanceof MeshFeature) {
                meshSequence = ((MeshFeature)primitiveModelEntity).getSequence();
            } else if (primitiveModelEntity instanceof HideMesh) {
                meshSequence = ((HideMesh)primitiveModelEntity).getSequence();
            }
            if (meshSequence != null && meshSequence.getGeom() == this.getGeomSequence()) {
                throw new FlException("Mesh_import_operation_selections_cannot_be_assigned_to_a_named_selection");
            }
        }
    }

    private int[][] q() {
        int[][] nArray = this.getSel().getRemainingEntities();
        if (nArray == null) {
            MeshFeature meshFeature = (MeshFeature)this.getParent();
            nArray = meshFeature.method().remainingEntities();
        }
        return nArray;
    }

    @Override
    protected boolean f() {
        if (this.getGeomSequence() != null && this.getGeomSequence().isDefinedByMesh()) {
            MeshSequence meshSequence;
            PrimitiveModelEntity primitiveModelEntity = this.getParent();
            while (primitiveModelEntity != null && !(primitiveModelEntity instanceof MeshSequence)) {
                primitiveModelEntity = primitiveModelEntity.getContainer();
            }
            if (primitiveModelEntity != null && (meshSequence = (MeshSequence)primitiveModelEntity).getGeom() != this.getGeomSequence()) {
                return super.f();
            }
            return false;
        }
        return super.f();
    }

    public void mesh(String string) {
        MeshSequence meshSequence = "".equals(string) ? null : this.b().mesh(string);
        ISelectionFilter iSelectionFilter = this.a();
        if (iSelectionFilter == null || !iSelectionFilter.allowMesh(meshSequence)) {
            throw new FlException("Unsupported_mesh_X#" + string);
        }
        if (!string.equals(this.getSel().mesh())) {
            if (this.getSel().getSelType() == SEL_TYPES.GEOMDIM) {
                this.set(new int[0]);
            }
            this.getSel().setSourceMesh(meshSequence);
        }
    }

    @Override
    public boolean selectOnMeshGeom() {
        return this.getMeshingSequence() != null;
    }

    public int[] entitiesExisting(int n2) {
        MeshSequence meshSequence = this.getMeshingSequence();
        if (meshSequence == null) {
            return this.getSel().entities(n2);
        }
        return this.entitiesExisting(n2, meshSequence.getConstructionEntitiesToKeep()[n2]);
    }

    public int[] entitiesExisting(int n2, int[] nArray) {
        int[] nArray2 = this.getSel().entities(n2);
        MeshSequence meshSequence = this.getMeshingSequence();
        if (meshSequence == null || meshSequence.getType() == MESH_TYPES.IMPORTED) {
            return nArray2;
        }
        int n3 = this.getGeomSequence().getNEntities()[n2];
        an an2 = null;
        HashSet<Integer> hashSet = null;
        int n4 = 0;
        while (n4 < nArray2.length) {
            if (nArray2[n4] > n3) {
                if (an2 == null) {
                    an2 = new an(nArray2.length);
                    int n5 = 0;
                    while (n5 < n4) {
                        an2.add(nArray2[n5]);
                        ++n5;
                    }
                    hashSet = new HashSet<Integer>();
                    int[] nArray3 = nArray;
                    int n6 = nArray.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        n5 = nArray3[n7];
                        hashSet.add(n5 + 1);
                        ++n7;
                    }
                }
                if (hashSet.contains(nArray2[n4])) {
                    an2.add(nArray2[n4]);
                }
            }
            ++n4;
        }
        if (an2 == null) {
            return nArray2;
        }
        return an2.toArray();
    }
}

