/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.util;

import com.comsol.model.ModelEntity;
import com.comsol.model.PrimitiveModelEntity;
import com.comsol.model.PropFeature;
import com.comsol.model.util.ExternalUtil;
import com.comsol.nativeutil.properties.InvalidPropertyValueException;
import com.comsol.nativeutil.properties.PropAnnotationInfo;
import com.comsol.nativeutil.properties.Property;
import com.comsol.nativeutil.properties.de;
import com.comsol.util.application.ApplicationApiClassType;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.exceptions.UnknownEntityException;
import com.comsol.util.methods.CsColor;
import java.util.Locale;

public class ApplicationApiHelper {
    public static void assertPropExists(com.comsol.model.dbimodel.PropFeature propFeature, String string, ApplicationApiClassType applicationApiClassType) {
        de de2 = propFeature.getOperation().getPropSet();
        ApplicationApiHelper.assertPropExists(de2, string, applicationApiClassType);
    }

    public static void assertPropExists(de de2, String string, ApplicationApiClassType applicationApiClassType) {
        if (!ApplicationApiHelper.hasModifiableProperty(de2, string, applicationApiClassType)) {
            UnknownEntityException unknownEntityException = new UnknownEntityException("Unknown_property");
            unknownEntityException.addParameterPair("Property", string);
            throw unknownEntityException;
        }
    }

    public static boolean isColorProp(com.comsol.model.dbimodel.PropFeature propFeature, String string, ApplicationApiClassType applicationApiClassType) {
        PropAnnotationInfo.l l2;
        de de2 = propFeature.getOperation().getPropSet();
        Property property = de2.getFromAllProperty(string);
        return property != null && (l2 = property.getAnnotations().bv()) != null && l2.a(applicationApiClassType) && l2.c();
    }

    public static void assertColorPropExists(com.comsol.model.dbimodel.PropFeature propFeature, String string, ApplicationApiClassType applicationApiClassType) {
        ApplicationApiHelper.assertPropExists(propFeature, string, applicationApiClassType);
        if (!ApplicationApiHelper.isColorProp(propFeature, string, applicationApiClassType)) {
            FlException flException = new FlException("Not_a_color_property");
            flException.addParameterPair("Property", string);
            throw flException;
        }
    }

    public static boolean hasModifiableProperty(com.comsol.model.dbimodel.PropFeature propFeature, String string, ApplicationApiClassType applicationApiClassType) {
        return ApplicationApiHelper.hasModifiableProperty(propFeature.getOperation().getPropSet(), string, applicationApiClassType);
    }

    public static boolean hasModifiableProperty(de de2, String string, ApplicationApiClassType applicationApiClassType) {
        Property property = de2.getFromAllProperty(string);
        return property != null && property.getAnnotations().bv() != null && property.getAnnotations().bv().a(applicationApiClassType);
    }

    private static void a(com.comsol.model.dbimodel.PropFeature propFeature, String string) {
        de de2 = propFeature.getOperation().getPropSet();
        Property property = de2.getFromAllProperty(string);
        if (property == null || property.getAnnotations().bv() == null || !property.getAnnotations().bv().a()) {
            FlException flException = new FlException("Not_a_reference_property");
            flException.addParameterPair("Property", string);
            throw flException;
        }
    }

    public static void setReferenceProperty(com.comsol.model.dbimodel.PropFeature propFeature, String string, ModelEntity modelEntity) {
        ApplicationApiHelper.a(propFeature, string);
        if (modelEntity != null && !propFeature.getModel().tag().equals(ExternalUtil.getInternal((PrimitiveModelEntity)modelEntity).getModel().tag())) {
            FlException flException = new FlException("Cannot_set_reference_to_another_model");
            flException.addParameterPair("Property", string);
            throw flException;
        }
        de de2 = propFeature.getOperation().getPropSet();
        Property property = de2.getFromAllProperty(string);
        property.getAnnotations().bv().a((Object)modelEntity);
    }

    public static void setReferenceProperty(com.comsol.model.dbimodel.PropFeature propFeature, String string, com.comsol.model.dbimodel.ModelEntity modelEntity) {
        ApplicationApiHelper.a(propFeature, string);
        if (!propFeature.getModel().tag().equals(modelEntity.getModel().tag())) {
            FlException flException = new FlException("Cannot_set_reference_to_another_model");
            flException.addParameterPair("Property", string);
            throw flException;
        }
        de de2 = propFeature.getOperation().getPropSet();
        Property property = de2.getFromAllProperty(string);
        property.getAnnotations().bv().a((Object)modelEntity);
    }

    public static double getDouble(PropFeature propFeature, String string, int n2) {
        if (n2 < 0) {
            FlException flException = new FlException("Index_must_not_be_negative");
            flException.addParameterPair("Property", string);
            throw flException;
        }
        double[] dArray = propFeature.getDoubleArray(string);
        if (n2 >= dArray.length) {
            FlException flException = new FlException("Index_X_exceeds_length_Y#" + n2 + "#" + dArray.length);
            flException.addParameterPair("Property", string);
            throw flException;
        }
        return dArray[n2];
    }

    private static void a(String string) {
        InvalidPropertyValueException invalidPropertyValueException = new InvalidPropertyValueException("Invalid_property_value");
        invalidPropertyValueException.addParameterPair("Property", string);
        throw invalidPropertyValueException;
    }

    public static void setColor(PropFeature propFeature, String string, ApplicationApiClassType applicationApiClassType, int n2, int n3, int n4) {
        if (n2 < 0 || n2 > 255 || n3 < 0 || n3 > 255 || n4 < 0 || n4 > 255) {
            ApplicationApiHelper.a(string);
        }
        double[] dArray = new double[]{(double)n2 / 255.0, (double)n3 / 255.0, (double)n4 / 255.0};
        propFeature.set("custom" + string, dArray);
        propFeature.set(string, "custom");
    }

    public static int[] getColor(PropFeature propFeature, String string, ApplicationApiClassType applicationApiClassType) {
        String string2 = propFeature.getString(string);
        if (string2.equals("custom")) {
            double[] dArray = propFeature.getDoubleArray("custom" + string);
            return new int[]{(int)Math.round(dArray[0] * 255.0), (int)Math.round(dArray[1] * 255.0), (int)Math.round(dArray[2] * 255.0)};
        }
        if (string2.equals("default")) {
            return new int[3];
        }
        float[] fArray = CsColor.getColor((String)string2).getRGBComponents();
        return new int[]{(int)Math.round((double)fArray[0] * 255.0), (int)Math.round((double)fArray[1] * 255.0), (int)Math.round((double)fArray[2] * 255.0)};
    }

    public static int[] parseRGBString(String string) {
        if (!string.replaceAll(" ", "").toLowerCase(Locale.ENGLISH).startsWith("rgb(")) {
            return null;
        }
        if (!(string = string.replaceAll(" ", "").substring(4)).endsWith(")")) {
            return null;
        }
        String[] stringArray = (string = string.substring(0, string.length() - 1)).split(" *, *");
        if (stringArray.length != 3) {
            return null;
        }
        try {
            int n2 = Integer.parseInt(stringArray[0]);
            int n3 = Integer.parseInt(stringArray[1]);
            int n4 = Integer.parseInt(stringArray[2]);
            return new int[]{n2, n3, n4};
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static void setColorProp(PropFeature propFeature, String string, ApplicationApiClassType applicationApiClassType, String string2) {
        if (string2.equals("custom")) {
            ApplicationApiHelper.a(string);
        }
        if (string2.replaceAll(" ", "").toLowerCase(Locale.ENGLISH).startsWith("rgb(")) {
            int[] nArray = ApplicationApiHelper.parseRGBString(string2);
            if (nArray == null) {
                ApplicationApiHelper.a(string);
            }
            ApplicationApiHelper.setColor(propFeature, string, applicationApiClassType, nArray[0], nArray[1], nArray[2]);
        } else {
            propFeature.set(string, string2);
        }
    }

    public static String getColorPropString(com.comsol.model.dbimodel.PropFeature propFeature, String string, ApplicationApiClassType applicationApiClassType) {
        PropFeature propFeature2 = (PropFeature)ExternalUtil.returnObject(propFeature, false);
        return ApplicationApiHelper.getColorPropString(propFeature2, string, applicationApiClassType);
    }

    public static String getColorPropString(PropFeature propFeature, String string, ApplicationApiClassType applicationApiClassType) {
        String string2 = propFeature.getString(string);
        if (string2.equals("custom")) {
            int[] nArray = ApplicationApiHelper.getColor(propFeature, string, applicationApiClassType);
            return "rgb(" + nArray[0] + ", " + nArray[1] + ", " + nArray[2] + ")";
        }
        return string2;
    }
}

