/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.util;

import com.comsol.dbmigration.framework.a;
import com.comsol.model.applapi.ApplModeCreatorManager;
import com.comsol.model.applapi.IApplMode;
import com.comsol.model.applapi.PhysicalQuantityManager;
import com.comsol.model.data.AttributeUtil;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.dbimodel.design.Design;
import com.comsol.model.dbimodel.design.DesignMultiphysicsCouplingList;
import com.comsol.model.savepoint.interfaces.IModel;
import com.comsol.model.savepoint.interfaces.IPhysics;
import com.comsol.model.simple.SimpleDesign;
import com.comsol.model.simple.SimpleUtil;
import com.comsol.model.util.BuilderUtil;
import com.comsol.model.util.ModelInternalUtil;
import com.comsol.model.util.ModelType;
import com.comsol.model.util.QuickReadUtil;
import com.comsol.model.util.TrustedLoader;
import com.comsol.model.util.saveload.AbstractModelSaver;
import com.comsol.model.util.saveload.IModelMiscLoader;
import com.comsol.model.util.saveload.IModelMiscSaver;
import com.comsol.model.util.saveload.PhysicsBuilderSaver;
import com.comsol.nativeutil.data.IModelAttributeUtil;
import com.comsol.nativeutil.preferences.Preferences;
import com.comsol.nativeutil.runnable.k;
import com.comsol.systemutils.SystemUtil;
import com.comsol.util.classes.CsXMLWriter;
import com.comsol.util.classes.FileManagerUtil;
import com.comsol.util.classes.FlFileTypes;
import com.comsol.util.classes.af;
import com.comsol.util.classes.t;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.interfaces.m;
import com.comsol.util.logger.FlLogger;
import com.comsol.util.methods.q;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import java.util.function.Predicate;

@TrustedLoader(value="APPLICATION")
public class BuilderAreaManager
implements IModelMiscLoader,
IModelMiscSaver,
com.comsol.nativeutil.preferences.e {
    public static final String prefUseBuilder = "physicsbuilder.settings.usebuilder";
    public static final String prefDevelopmentFiles = "physicsbuilder.settings.developmentfiles";
    public static final String prefBuilderArchives = "physicsbuilder.settings.builderarchives";
    public static String[] prefsToUpdate = new String[]{"physicsbuilder.settings.developmentfiles", "physicsbuilder.settings.builderarchives"};
    private static BuilderAreaManager b;
    private final Map<String, Design> c = new TreeMap<String, Design>();
    private final Map<String, List<String>> d = new HashMap<String, List<String>>();
    private final Map<String, b> e = new HashMap<String, b>();
    private final Stack<String> f = new Stack();
    private e g = null;
    private int h = Preferences.getInstance().getIntegerPreference("physicsbuilder.search.filesmax");
    private int i = Math.max(2, this.h / 3);
    private SimpleDesign j = null;
    private final Map<String, SimpleDesign> k = new HashMap<String, SimpleDesign>();
    private final Collection<CachedFileRemovalListener> l = new ArrayList<CachedFileRemovalListener>();
    private final Map<String, List<String>> m = new HashMap<String, List<String>>();
    private final Map<String, List<String>> n = new HashMap<String, List<String>>();
    private int o = 0;
    private String[] p = new String[0];
    private String[] q = new String[0];
    private final Map<String, File> r = new TreeMap<String, File>();
    private volatile boolean s;
    private Thread t;
    private volatile boolean u;
    private Thread v;
    private boolean w;
    private boolean x = false;
    private Boolean y = null;
    private static boolean z;
    private static boolean A;
    boolean a = false;
    private boolean B = false;

    static {
        z = false;
        A = false;
    }

    public static final BuilderAreaManager getInstance() {
        if (b == null) {
            b = new BuilderAreaManager();
        }
        return b;
    }

    public static boolean preventLoadingOfBuilderFiles(boolean bl2) {
        boolean bl3 = z;
        z = bl2;
        if (!bl2 && A) {
            BuilderAreaManager.c();
        }
        return bl3;
    }

    public static boolean isPreventLoadingOfDevelopmentFiles() {
        return z || com.comsol.dbmigration.framework.a.a();
    }

    private BuilderAreaManager() {
        this.a();
        this.b();
        Preferences.getInstance().getPreferenceChangeManager().a(prefUseBuilder, (com.comsol.nativeutil.preferences.e)this);
        Preferences.getInstance().getPreferenceChangeManager().a(prefDevelopmentFiles, (com.comsol.nativeutil.preferences.e)this);
        Preferences.getInstance().getPreferenceChangeManager().a(prefBuilderArchives, (com.comsol.nativeutil.preferences.e)this);
        Preferences.getInstance().getPreferenceChangeManager().a("physicsbuilder.search.filesmax", (com.comsol.nativeutil.preferences.e)this);
    }

    public BuilderAreaManager addCacheListener(CachedFileRemovalListener cachedFileRemovalListener) {
        if (!this.l.contains(cachedFileRemovalListener)) {
            this.l.add(cachedFileRemovalListener);
        }
        return this;
    }

    public BuilderAreaManager removeCacheListener(CachedFileRemovalListener cachedFileRemovalListener) {
        this.l.remove(cachedFileRemovalListener);
        return this;
    }

    public boolean hasSetPerpectiveForCurrentApplication() {
        return this.w;
    }

    public void setHasSetPerpectiveForCurrentApplication(boolean bl2) {
        this.w = bl2;
    }

    public boolean hasMigrationVersionInDevelopmentFiles() {
        if (this.y == null) {
            this.y = BuilderUtil.hasMigratorVersion(this.getDevelopmentFiles());
        }
        return this.y;
    }

    public Collection<String> getPathsToSourceFilesInArchives(int n2) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (af.a a2 : this.a(false)) {
            if (--n2 < 0) break;
            linkedHashSet.add(a2.b);
        }
        return linkedHashSet;
    }

    private List<af.a> a(boolean bl2) {
        String[] stringArray = this.getBuilderArchives();
        TreeMap<String, af.a> treeMap = new TreeMap<String, af.a>();
        ArrayList<af.a> arrayList = new ArrayList<af.a>();
        HashSet<String> hashSet = new HashSet<String>();
        m m2 = af.g();
        String string3 = SystemUtil.getClientFileSeparator();
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string4 = stringArray2[n3];
            af.a a3 = m2.e(string4);
            treeMap.put(a3.b, a3);
            hashSet.add(a3.i);
            ++n3;
        }
        if (bl2) {
            hashSet.stream().forEach(string -> {
                String[] stringArray;
                String[] stringArray2 = stringArray = FileManagerUtil.a((String)string, (String)com.comsol.util.interfaces.m.a, (boolean)true, (boolean)true, null, null);
                int n2 = stringArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    String string2 = stringArray2[n3];
                    if (treeMap.containsKey(string2)) {
                        af.a a2 = m2.e(string2);
                        if (a2.e) {
                            treeMap.put(string2, a2);
                        }
                    }
                    ++n3;
                }
            });
        }
        treeMap.forEach((string2, a2) -> {
            af.a a3 = m2.e(String.valueOf(string2) + string3 + BuilderUtil.Path.MPHDEVSRC.getName());
            if (a3.e) {
                this.a(arrayList, m2, a3);
            }
        });
        return arrayList;
    }

    private void a(List<af.a> list, m m2, af.a a2) {
        FlFileTypes flFileTypes = new FlFileTypes(FlFileTypes.Type.ac);
        String[] stringArray = FileManagerUtil.a((String)a2.b, (String)com.comsol.util.interfaces.m.a, (boolean)true, (boolean)true, null, null);
        if (stringArray == null) {
            return;
        }
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string = stringArray2[n3];
            af.a a3 = m2.e(string);
            if (a3.e) {
                this.a(list, m2, a3);
            } else if (flFileTypes.accept(string)) {
                list.add(a3);
            }
            ++n3;
        }
    }

    public void startLoadingArchiveFiles(k k2) {
        if (this.t == null || !this.t.isAlive()) {
            this.s = false;
            this.t = new Thread(new d(k2));
            this.t.start();
        }
    }

    public void stopLoadingArchiveFiles() {
        if (this.t != null) {
            this.s = true;
            try {
                this.t.join();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public boolean archiveFilesNeedsLoading() {
        int n2 = Preferences.getInstance().getIntegerPreference("physicsbuilder.search.filesmax");
        for (af.a a2 : this.a(false)) {
            if (--n2 < 0) {
                return false;
            }
            if (!this.a(a2)) continue;
            return true;
        }
        return false;
    }

    public void forceFinishLoadingArchiveFiles(k k2) {
        this.stopLoadingArchiveFiles();
        this.s = false;
        new d(k2).run();
    }

    public void startQuickReadingLinkInfo(k k2) {
        if (this.getBuilderArchives().length == 0) {
            return;
        }
        if (this.v == null || !this.v.isAlive()) {
            this.u = false;
            this.v = new Thread(new f(k2, this.a(true)));
            this.v.start();
        }
    }

    public boolean isQuickReadingLinkInfo() {
        return this.v == null || this.v.isAlive();
    }

    public boolean waitForQuickReadingLinkInfo() {
        if (this.v != null && this.v.isAlive()) {
            try {
                int n2 = 10;
                while (this.v.isAlive() && --n2 > 0) {
                    this.wait(2000L);
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        return this.v.isAlive();
    }

    public void stopQuickReadingLinkInfo() {
        if (this.v != null) {
            this.u = true;
            try {
                this.v.join(30000L);
                if (this.v.isAlive()) {
                    throw new RuntimeException("A background process failed to terminate. Consider to restart COMSOL.");
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    public List<String> getLinkSources(t t2) {
        if (this.v == null) {
            this.startQuickReadingLinkInfo((k)new com.comsol.nativeutil.runnable.f());
        }
        if (this.isQuickReadingLinkInfo() || t2 == null) {
            return Collections.emptyList();
        }
        List<String> list = this.n.get(t2.toString());
        return list != null ? Collections.unmodifiableList(list) : Collections.emptyList();
    }

    public BuilderAreaManager removeDevelopmentFile(String string) {
        return this.removeDevelopmentFiles(Collections.singletonList(string));
    }

    public BuilderAreaManager removeDevelopmentFiles(Collection<String> collection) {
        boolean bl2 = false;
        for (String stringArray : collection) {
            if (!this.c.containsKey(stringArray)) continue;
            bl2 = true;
            break;
        }
        if (bl2) {
            String[] stringArray = com.comsol.util.methods.q.f((String[])((String[])com.comsol.util.methods.q.a((Object[])this.getDevelopmentFiles(), (Object[])collection.toArray(new String[0]))));
            Preferences.getInstance().setPreference(prefDevelopmentFiles, stringArray);
        }
        return this;
    }

    public Design importDevelopmentFile(t t2, k k2, boolean bl2, boolean bl3) {
        Throwable throwable = null;
        Object var6_7 = null;
        try (c c2 = new c(t2.toString());){
            Design design = BuilderUtil.loadGeneralDesign(t2, k2, true, bl3);
            if (bl2) {
                this.addImportedDevelopmentFile(t2.toString(), design);
            }
            return design;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public BuilderAreaManager clearDevelopmentFiles() {
        Preferences.getInstance().setPreference(prefDevelopmentFiles, new String[0]);
        this.y = false;
        this.c.clear();
        this.d.clear();
        this.e.clear();
        return this;
    }

    public BuilderAreaManager clearBuilderArchives() {
        this.r.clear();
        Preferences.getInstance().setPreference(prefBuilderArchives, new String[0]);
        return this;
    }

    public BuilderAreaManager updateDevelopmentFile(String string, Design design) {
        this.a();
        boolean bl2 = false;
        if (this.c.containsKey(string)) {
            this.c.put(string, null);
            this.e.keySet().removeAll(this.d.put(string, Collections.emptyList()));
            bl2 = true;
        } else if (com.comsol.util.classes.t.b((String)string)) {
            bl2 = this.e.remove(string) != null;
        } else {
            String string2 = FileManagerUtil.a((String)string);
            if (design != null) {
                b b2 = this.e.get(string2);
                if (b2 != null && b2.a != design) {
                    bl2 = this.e.remove(string2) != null;
                }
            } else {
                boolean bl3 = bl2 = this.e.remove(string2) != null;
            }
        }
        if (bl2) {
            ApplModeCreatorManager.updateCreatorMap();
            PhysicalQuantityManager.setManagerInvalid();
        }
        if (this.k.containsKey(string)) {
            this.k.put(string, null);
        }
        return this;
    }

    public BuilderAreaManager addDevelopmentFile(String string) {
        this.addDevelopmentFiles(Collections.singletonList(string));
        return this;
    }

    public BuilderAreaManager addDevelopmentFiles(List<String> list) {
        this.a();
        boolean bl2 = false;
        for (String stringArray : list) {
            if (this.c.containsKey(stringArray)) continue;
            bl2 = true;
            break;
        }
        if (bl2) {
            String[] stringArray = com.comsol.util.methods.q.f((String[])((String[])com.comsol.util.methods.q.b((Object[][])new String[][]{this.getDevelopmentFiles(), list.toArray(new String[0])})));
            Preferences.getInstance().setPreference(prefDevelopmentFiles, stringArray);
        }
        return this;
    }

    public Design getImportedDevelopmentFile(String string) {
        b b2 = this.e.get(string);
        if (b2 != null) {
            b2.c = System.currentTimeMillis();
            return b2.a;
        }
        return null;
    }

    public BuilderAreaManager addImportedDevelopmentFile(String string2, Design design) {
        if (this.a) {
            throw new IllegalStateException(String.format("Cannot add URI '%s' to cache while it is busy cleaning it up", string2));
        }
        b b2 = new b(design);
        b b4 = this.e.put(string2, b2);
        if (b4 != null) {
            // empty if block
        }
        if (!(design instanceof SimpleDesign) && !design.isReadOnly() && this.g != null && this.g.a.equals(string2)) {
            b2.b = this.g.b;
        }
        this.g = null;
        if (this.e.size() > this.h) {
            try {
                this.a = true;
                ArrayList arrayList = new ArrayList();
                this.e.forEach((string, b3) -> {
                    if (b3 != b2 && !string.startsWith("plugin://")) {
                        arrayList.add(new a((String)string, b3.d, b3.c));
                    }
                });
                arrayList.stream().sorted().limit(this.i).forEach(a2 -> {
                    b b2 = this.e.remove(a2.c);
                    String string = b2.a.getUri().toString();
                    if (!(a2.c.startsWith("file:///") ? "file:/" + a2.c.substring(8) : a2.c).equals(string.startsWith("file:///") ? "file:/" + string.substring(8) : string)) {
                        throw new IllegalStateException(String.format("Builder URI '%s' does not match the URI '%s' to remove", string, a2.c));
                    }
                    for (CachedFileRemovalListener cachedFileRemovalListener : this.l) {
                        cachedFileRemovalListener.handleRemoval(a2.c, b2.a);
                    }
                });
                com.comsol.systemutils.a.c((int)2);
            }
            finally {
                this.a = false;
            }
        }
        return this;
    }

    public BuilderAreaManager disablePreviewModel() {
        if (!this.x && this.j != null) {
            this.x = true;
            ApplModeCreatorManager.updateCreatorMap();
        }
        return this;
    }

    public BuilderAreaManager enablePreviewModel() {
        if (this.x && this.j != null) {
            this.x = false;
            ApplModeCreatorManager.updateCreatorMap();
        }
        return this;
    }

    public BuilderAreaManager setPreviewModel(Design design, String[] stringArray) {
        this.j = SimpleUtil.convertToSimpleDesign(design);
        this.j.compiledVersion(ModelInternalUtil.getCurrentVersion());
        this.x = false;
        ++this.o;
        this.p = stringArray;
        ApplModeCreatorManager.updateCreatorMap();
        ArrayList<String> arrayList = new ArrayList<String>();
        DesignMultiphysicsCouplingList<? extends PropFeature> designMultiphysicsCouplingList = design.multiphysicsCoupling();
        for (PropFeature propFeature : designMultiphysicsCouplingList) {
            arrayList.add(propFeature.getString("type"));
        }
        this.q = arrayList.toArray(new String[0]);
        return this;
    }

    public BuilderAreaManager removePreviewModel() {
        if (this.j != null) {
            this.j = null;
            this.x = false;
            this.p = new String[0];
            this.q = new String[0];
            ApplModeCreatorManager.updateCreatorMap();
        }
        return this;
    }

    public void resetPreviewCounter() {
        this.o = 0;
    }

    public int getPreviewCounter() {
        return this.o;
    }

    public String[] getPreviewPhysicsInterfaceIDs() {
        return this.x ? new String[]{} : this.p;
    }

    public String[] getPreviewMultiphysicsCouplingIDs() {
        return this.x ? new String[]{} : this.q;
    }

    private synchronized void b(boolean bl2) {
        String[] stringArray;
        String[] stringArray2 = stringArray = this.getDevelopmentFiles();
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            block22: {
                String string = stringArray2[n3];
                af.a a2 = af.g().e(string);
                if (this.c.get(string) == null) {
                    if (!ModelType.DESIGN.acceptFileName(string)) {
                        this.c.put(string, null);
                        this.e.keySet().removeAll(this.d.put(string, Collections.emptyList()));
                    } else if (a2.e) {
                        this.c.put(string, null);
                        this.e.keySet().removeAll(this.d.put(string, Collections.emptyList()));
                    } else if (!a2.f) {
                        this.c.put(string, null);
                        this.e.keySet().removeAll(this.d.put(string, Collections.emptyList()));
                    } else {
                        com.comsol.nativeutil.runnable.f f2 = new com.comsol.nativeutil.runnable.f();
                        if (BuilderUtil.containsEmf(string)) {
                            com.comsol.migration.f.f();
                            if (com.comsol.dbmigration.framework.a.a()) {
                                A = true;
                            }
                        }
                        try {
                            Design design = BuilderUtil.loadDesign(a2.b, (k)f2, true, bl2);
                            this.c.put(string, design);
                            this.addImportedDevelopmentFile(a2.d, design);
                            String string2 = BuilderUtil.convertFileToPluginURI(string);
                            if (string2 != null) {
                                List<String> list = Arrays.asList(string2, BuilderUtil.toMphdevsrcUri(string2), a2.d);
                                this.d.put(string, list);
                                b b2 = new b(design);
                                for (String string3 : list) {
                                    this.e.put(string3, b2);
                                }
                            } else {
                                this.d.put(string, Arrays.asList(a2.d));
                            }
                        }
                        catch (IOException iOException) {
                            this.c.put(string, null);
                            this.e.keySet().removeAll(this.d.put(string, Collections.emptyList()));
                            FlLogger.a((Throwable)iOException);
                            if (f2 != null) {
                                f2.e();
                            }
                            break block22;
                        }
                        catch (FlException flException) {
                            try {
                                this.c.put(string, null);
                                this.e.keySet().removeAll(this.d.put(string, Collections.emptyList()));
                                FlLogger.a((Throwable)flException);
                                break block22;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                if (f2 != null) {
                                    f2.e();
                                }
                            }
                        }
                        if (f2 == null) break block22;
                        f2.e();
                    }
                }
            }
            ++n3;
        }
    }

    public boolean hasDevelopmentFile(String string) {
        return this.c.containsKey(string);
    }

    public String[] getDevelopmentFiles() {
        return Preferences.getInstance().getStringArrayPreference(prefDevelopmentFiles);
    }

    public Collection<Design> getValidBuilderModels(boolean bl2, Predicate<Object> predicate) {
        Serializable serializable;
        if (bl2 && this.hasMigrationVersionInDevelopmentFiles()) {
            com.comsol.dbmigration.framework.a.a((IModelAttributeUtil)new AttributeUtil());
        }
        if (this.a()) {
            if (this.B) {
                throw new IllegalStateException("Nested calls to loading of development files was detected when it isn't allowed");
            }
            this.B = true;
            try {
                serializable = null;
                Object var4_5 = null;
                try (DevelopmentFileMigration developmentFileMigration = new DevelopmentFileMigration();){
                    this.b(bl2);
                }
                catch (Throwable throwable) {
                    if (serializable == null) {
                        serializable = throwable;
                    } else if (serializable != throwable) {
                        ((Throwable)serializable).addSuppressed(throwable);
                    }
                    throw serializable;
                }
            }
            finally {
                this.B = false;
            }
        }
        serializable = new ArrayList<Design>(this.c.size());
        if (bl2 && this.j != null && !this.x) {
            serializable.add((Design)this.j);
        }
        this.c.forEach((string, design) -> {
            if (design != null && predicate.test(design)) {
                serializable.add(design);
            }
        });
        return serializable;
    }

    public boolean hasDevelopmentFiles(boolean bl2) {
        return BuilderUtil.usePhysicsBuilder() && (this.j != null && !this.x || this.getDevelopmentFiles().length > 0);
    }

    public BuilderAreaManager addBuilderArchive(String string) {
        this.b();
        if (!this.r.containsKey(string)) {
            this.r.put(string, null);
            Preferences.getInstance().setPreference(prefBuilderArchives, this.r.keySet().toArray(new String[0]));
        }
        return this;
    }

    public BuilderAreaManager removeBuilderArchive(String string) {
        this.removeBuilderArchives(Collections.singleton(string));
        return this;
    }

    public BuilderAreaManager removeBuilderArchives(Collection<String> collection) {
        this.b();
        if (this.r.keySet().removeAll(collection)) {
            Preferences.getInstance().setPreference(prefBuilderArchives, this.r.keySet().toArray(new String[0]));
        }
        return this;
    }

    public String[] getBuilderArchives() {
        return Preferences.getInstance().getStringArrayPreference(prefBuilderArchives);
    }

    public boolean hasBuilderArchive(String string) {
        return this.r.containsKey(string);
    }

    public void checkModelsBeforeRemoval(Model model, String string) {
        Design design = this.c.get(string);
        if (design != null) {
            HashSet<String> hashSet = new HashSet<String>();
            for (PropFeature iModelEntity : design.physicsInterface()) {
                if (!iModelEntity.hasProperty("identifier")) continue;
                hashSet.add(iModelEntity.getString("identifier"));
            }
            this.a(model, hashSet);
            for (IModel iModel : model.getSavePointModels()) {
                this.a(iModel, hashSet);
            }
        }
    }

    private void a(IModel iModel, Collection<String> collection) {
        for (IPhysics iPhysics : iModel.physics()) {
            IApplMode iApplMode = iPhysics.getApp();
            if (iApplMode == null || !collection.contains(iApplMode.getApplModeID().getID())) continue;
            FlException flException = new FlException("An_interface_in_the_builder_resource_is_in_use");
            flException.addParameterPair("Physics_interface", iApplMode.getDescr());
            flException.addParameterPair("Tag", iPhysics.tag());
            throw flException;
        }
    }

    private <T> boolean a(String[] stringArray, Map<String, T> map, T t2) {
        HashSet<String> hashSet = new HashSet<String>(map.keySet());
        boolean bl2 = false;
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string = stringArray2[n3];
            T t3 = map.get(string);
            bl2 |= t3 == null || t3 == t2;
            if (!hashSet.remove(string)) {
                map.put(string, t2);
            }
            ++n3;
        }
        bl2 |= hashSet.size() > 0;
        for (String string : hashSet) {
            map.remove(string);
        }
        return bl2;
    }

    private synchronized boolean a() {
        boolean bl2 = this.a(this.getDevelopmentFiles(), this.c, null);
        if (bl2 && this.a(this.getDevelopmentFiles(), this.d, Collections.emptyList())) {
            for (Map.Entry<String, List<String>> entry : this.d.entrySet()) {
                Design design = this.c.get(entry.getKey());
                if (entry.getValue() == null || design == null) continue;
                b b2 = new b(design);
                for (String string : entry.getValue()) {
                    this.e.put(string, b2);
                }
            }
        }
        return bl2;
    }

    private synchronized boolean b() {
        return this.a(this.getBuilderArchives(), this.r, null);
    }

    public void preferenceChanged(String string, String string2) {
        if (prefDevelopmentFiles.equals(string) || prefUseBuilder.equals(string)) {
            boolean bl2 = BuilderUtil.usePhysicsBuilder();
            Object[] objectArray = bl2 ? new String[]{} : this.c.keySet().toArray(new String[0]);
            this.a();
            if (prefUseBuilder.equals(string) || bl2) {
                ApplModeCreatorManager.updateCreatorMap();
                PhysicalQuantityManager.setManagerInvalid();
                Object[] objectArray2 = bl2 ? this.getDevelopmentFiles() : new String[]{};
                String[] stringArray = (String[])com.comsol.util.methods.q.b((Object[])objectArray2, (Object[])objectArray);
                String[] stringArray2 = (String[])com.comsol.util.methods.q.b((Object[])objectArray, (Object[])objectArray2);
                boolean bl3 = BuilderUtil.hasMigratorVersion(stringArray);
                boolean bl4 = BuilderUtil.hasMigratorVersion(stringArray2);
                if (bl3) {
                    this.y = true;
                } else if (bl4) {
                    this.y = null;
                }
                if (bl3 || bl4) {
                    BuilderAreaManager.c();
                }
            }
        } else if (prefBuilderArchives.equals(string)) {
            this.b();
        } else if ("physicsbuilder.search.filesmax".equals(string)) {
            this.h = Integer.parseInt(string2);
        }
    }

    private static void c() {
        com.comsol.migration.f.g();
        com.comsol.dbmigration.framework.a.b();
        A = false;
    }

    public void updateBuilderFiles() {
        String[] stringArray = this.c.keySet().toArray(new String[0]);
        this.c.clear();
        this.d.clear();
        this.e.clear();
        this.k.clear();
        this.a();
        this.b();
        ApplModeCreatorManager.updateCreatorMap();
        PhysicalQuantityManager.setManagerInvalid();
        if (BuilderUtil.hasMigratorVersion(stringArray)) {
            BuilderAreaManager.c();
            this.y = null;
        }
        this.stopQuickReadingLinkInfo();
        this.v = null;
        this.n.clear();
        this.m.clear();
        this.startQuickReadingLinkInfo((k)new com.comsol.nativeutil.runnable.f());
    }

    private SimpleDesign a(af.a a2, k k2) {
        t t2 = com.comsol.util.classes.t.a((String)a2.d);
        Design design = BuilderUtil.loadGeneralDesign(t2, (k)new com.comsol.nativeutil.runnable.f(), true, false);
        SimpleDesign simpleDesign = SimpleUtil.convertToSimpleDesign(design);
        simpleDesign.setEntityModifyTime(a2.l);
        this.k.put(a2.b, simpleDesign);
        return simpleDesign;
    }

    private boolean a(af.a a2) {
        SimpleDesign simpleDesign = this.k.get(a2.b);
        if (simpleDesign == null) {
            return true;
        }
        long l2 = simpleDesign.getEntityModifyTime();
        if (l2 == 0L) {
            l2 = simpleDesign.getEntityCreationTime();
        }
        return a2.f && a2.l > l2;
    }

    public SimpleDesign getSimpleBuilderFile(String string, k k2) {
        af.a a2 = af.g().e(string);
        if (this.a(a2)) {
            return this.a(a2, k2);
        }
        return this.k.get(a2.b);
    }

    public void clear() {
        this.resetPreviewCounter();
        this.clearDevelopmentFiles();
        this.clearBuilderArchives();
        this.k.clear();
        this.g = null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.r.isEmpty()) {
            stringBuilder.append(this.r.size()).append(" builder archives\n");
        }
        if (!this.c.isEmpty()) {
            stringBuilder.append(this.c.size()).append(" development files\n");
        }
        if (!this.d.isEmpty()) {
            stringBuilder.append(this.d.size()).append(" development file URI:s\n");
        }
        if (!this.e.isEmpty()) {
            stringBuilder.append(this.e.size()).append(" cached imported files\n");
        }
        stringBuilder.append("Max size of imported cache: ").append(this.h).append("\n");
        stringBuilder.append("Files to remove when max reached: ").append(this.i).append("\n");
        if (!this.k.isEmpty()) {
            stringBuilder.append(this.k.size()).append(" archives for builder search\n");
        }
        if (this.j != null) {
            stringBuilder.append("Model for preview:\n").append(this.j.toString()).append("\n");
        }
        if (this.p.length > 0) {
            stringBuilder.append("Physics IDs for preveiw: ").append(Arrays.toString(this.p)).append("\n");
        }
        if (this.q.length > 0) {
            stringBuilder.append("Coupling IDs for preveiw: ").append(Arrays.toString(this.q)).append("\n");
        }
        if (this.g != null) {
            stringBuilder.append("Temporary GUI model storage: ").append(this.g.toString());
        }
        if (this.x) {
            stringBuilder.append("Preview model disabled\n");
        }
        if (this.w) {
            stringBuilder.append("Perpsective has been shown \n");
        }
        stringBuilder.append("Preview counter: ").append(this.o).append("\n");
        if (!this.l.isEmpty()) {
            stringBuilder.append(this.l.size()).append(" cache listeners\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public void loadMisc(Model model, File file, com.comsol.util.file.b b2, String string) throws IOException {
    }

    @Override
    public void loadMiscServer(Model model, File file, com.comsol.util.file.b b2) throws IOException {
    }

    @Override
    public void loadFromTreeNode(t t2, com.comsol.util.interfaces.b b2) {
        this.g = null;
        com.comsol.util.interfaces.b[] bArray = b2.a("GuiModel");
        if (bArray.length > 0) {
            this.g = new e();
            this.g.a = t2.toString();
            StringWriter stringWriter = new StringWriter();
            CsXMLWriter csXMLWriter = new CsXMLWriter(new BufferedWriter(stringWriter));
            bArray[0].a(csXMLWriter);
            csXMLWriter.flush();
            ByteBuffer byteBuffer = StandardCharsets.UTF_8.encode(CharBuffer.wrap(stringWriter.toString()));
            this.g.b = new byte[byteBuffer.limit()];
            byteBuffer.get(this.g.b);
        }
    }

    @Override
    public void loadingOldEmfModel() {
    }

    @Override
    public void saveMisc(AbstractModelSaver abstractModelSaver) throws IOException {
        this.g = null;
        t t2 = abstractModelSaver.getOriginalModelUri();
        b b2 = this.e.get(t2.toString());
        if (b2 != null && b2.b != null && abstractModelSaver instanceof PhysicsBuilderSaver) {
            String string = StandardCharsets.UTF_8.decode(ByteBuffer.wrap(b2.b, 0, b2.b.length)).toString();
            CsXMLWriter csXMLWriter = ((PhysicsBuilderSaver)abstractModelSaver).getWriter();
            csXMLWriter.writeRawData(string);
        }
    }

    private static class a
    implements Comparable<a> {
        final long a;
        final long b;
        final String c;

        public a(String string, long l2, long l3) {
            this.a = l3;
            this.b = l2;
            this.c = string;
        }

        public int hashCode() {
            return this.c.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof a) {
                a a2 = (a)object;
                return this.b == a2.b && this.a == a2.a && this.c.equals(a2.c);
            }
            return super.equals(object);
        }

        public int a(a a2) {
            int n2 = (int)(this.a - a2.a);
            if (n2 != 0) {
                return n2;
            }
            return (int)(this.b - a2.b);
        }

        @Override
        public /* synthetic */ int compareTo(Object object) {
            return this.a((a)object);
        }
    }

    public static interface CachedFileRemovalListener {
        public void handleRemoval(String var1, Design var2);
    }

    private static class b
    implements Comparable<b> {
        final Design a;
        byte[] b;
        long c = 0L;
        final long d;

        b(Design design) {
            this.a = design;
            this.c = this.d = System.currentTimeMillis();
        }

        public int a(b b2) {
            int n2 = (int)(this.c - b2.c);
            if (n2 != 0) {
                return n2;
            }
            return (int)(this.d - b2.d);
        }

        @Override
        public /* synthetic */ int compareTo(Object object) {
            return this.a((b)object);
        }
    }

    public static class DevelopmentFileMigration
    extends a.f {
        private final boolean a = BuilderAreaManager.preventLoadingOfBuilderFiles(true);

        public DevelopmentFileMigration() {
            super((IModelAttributeUtil)new AttributeUtil());
        }

        public void close() {
            super.close();
            BuilderAreaManager.preventLoadingOfBuilderFiles(this.a);
        }
    }

    private class c
    implements AutoCloseable {
        c(String string) {
            if (BuilderAreaManager.this.f.contains(string)) {
                FlException flException = new FlException("#Trying to load a file while it is being loaded.");
                flException.addParameterPair("#URI", string);
                int n2 = BuilderAreaManager.this.f.size() - 1;
                while (n2 >= 0) {
                    flException.addParameterPair("#URI " + (n2 + 1), (String)BuilderAreaManager.this.f.get(n2));
                    --n2;
                }
                throw new IllegalStateException(flException.niceString());
            }
            BuilderAreaManager.this.f.push(string);
        }

        @Override
        public void close() {
            BuilderAreaManager.this.f.pop();
        }
    }

    public static class InhibitDevelopmentFileLoading
    implements Closeable {
        private final Boolean a;

        public InhibitDevelopmentFileLoading() {
            this.a = BuilderAreaManager.preventLoadingOfBuilderFiles(true);
        }

        public InhibitDevelopmentFileLoading(t t2) {
            boolean bl2 = t2.m() && BuilderAreaManager.getInstance().hasDevelopmentFile(FileManagerUtil.b((String)t2.toString()));
            this.a = bl2 ? Boolean.valueOf(BuilderAreaManager.preventLoadingOfBuilderFiles(true)) : null;
        }

        public InhibitDevelopmentFileLoading(String string) {
            boolean bl2 = BuilderAreaManager.getInstance().hasDevelopmentFile(string);
            this.a = bl2 ? Boolean.valueOf(BuilderAreaManager.preventLoadingOfBuilderFiles(true)) : null;
        }

        @Override
        public void close() {
            if (this.a != null) {
                BuilderAreaManager.preventLoadingOfBuilderFiles(this.a);
            }
        }
    }

    private class d
    implements Runnable {
        private final k b;

        public d(k k2) {
            this.b = k2;
        }

        @Override
        public void run() {
            try {
                int n2 = Preferences.getInstance().getIntegerPreference("physicsbuilder.search.filesmax");
                if (BuilderAreaManager.this.s) {
                    return;
                }
                List list = BuilderAreaManager.this.a(false);
                if (list.size() > n2) {
                    list = list.subList(0, n2);
                }
                this.b.b(this.b.h() / (double)list.size());
                for (af.a a2 : list) {
                    if (BuilderAreaManager.this.s) {
                        break;
                    }
                    if (!BuilderAreaManager.this.a(a2)) continue;
                    BuilderAreaManager.this.getSimpleBuilderFile(a2.b, this.b);
                    this.b.a(1.0);
                }
            }
            finally {
                this.b.e();
            }
        }
    }

    private static class e {
        String a;
        byte[] b;

        private e() {
        }

        public String toString() {
            return String.format("%s: byte[%d]", this.a, this.b.length);
        }
    }

    private class f
    implements Runnable {
        private final k b;
        private final List<af.a> c;
        private static /* synthetic */ int[] d;

        public f(k k2, List<af.a> list) {
            this.b = k2;
            this.c = list;
        }

        @Override
        public void run() {
            long l2 = System.nanoTime();
            if (this.c.isEmpty()) {
                return;
            }
            try {
                this.b.b(this.b.h() / (double)this.c.size());
                block8: for (af.a a2 : this.c) {
                    QuickReadUtil.MaxDepthFilter maxDepthFilter;
                    if (BuilderAreaManager.this.u) {
                        return;
                    }
                    t t2 = com.comsol.util.classes.t.a((String)a2.d);
                    BuilderUtil.BuilderFileType builderFileType = BuilderUtil.getBuilderFileType(t2);
                    switch (com.comsol.model.util.BuilderAreaManager$f.a()[builderFileType.ordinal()]) {
                        case 2: {
                            maxDepthFilter = new QuickReadUtil.ImportedUrlQuickReadEmf();
                            break;
                        }
                        case 8: {
                            maxDepthFilter = new QuickReadUtil.ImportedUrlQuickReadDb();
                            break;
                        }
                        default: {
                            FlLogger.a((String)("Ignored unsupported file type '" + builderFileType.name() + "' when reading file '" + t2.toString() + "'"));
                            continue block8;
                        }
                    }
                    List<String> list = BuilderUtil.quickReadAttribute(t2, maxDepthFilter);
                    list.stream().forEach(string -> {
                        ArrayList<String> arrayList = (ArrayList<String>)BuilderAreaManager.this.m.get(a2.d);
                        if (arrayList == null) {
                            arrayList = new ArrayList<String>();
                            BuilderAreaManager.this.m.put(a2.b, arrayList);
                        }
                        t t3 = BuilderUtil.getRelativeURIFromPlugin(string, t2);
                        if ((t3 = BuilderUtil.convertUriToFileUri(t3, t2)) != null) {
                            ArrayList<String> arrayList2 = (ArrayList<String>)BuilderAreaManager.this.n.get(t3.toString());
                            if (arrayList2 == null) {
                                arrayList2 = new ArrayList<String>();
                                BuilderAreaManager.this.n.put(t3.toString(), arrayList2);
                            }
                            arrayList.add(t3.toString());
                            arrayList2.add(a2.d);
                        }
                        this.b.a(1.0);
                    });
                }
                FlLogger.a((String)String.format("Populating link information took %1.3f ms", (double)(System.nanoTime() - l2) / 1000000.0));
            }
            finally {
                this.b.e();
            }
        }

        static /* synthetic */ int[] a() {
            if (d != null) {
                return d;
            }
            int[] nArray = new int[BuilderUtil.BuilderFileType.values().length];
            try {
                nArray[BuilderUtil.BuilderFileType.Db.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[BuilderUtil.BuilderFileType.EMF.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[BuilderUtil.BuilderFileType.EncryptedDb.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[BuilderUtil.BuilderFileType.EncryptedEMF.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[BuilderUtil.BuilderFileType.EncryptedSerializedSimpleDesign.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[BuilderUtil.BuilderFileType.EncryptedSimpleDesign.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[BuilderUtil.BuilderFileType.None.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[BuilderUtil.BuilderFileType.SerializedSimpleDesign.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[BuilderUtil.BuilderFileType.SimpleDesign.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            d = nArray;
            return nArray;
        }
    }
}

