/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.util;

import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.systemutils.SystemUtil;
import com.comsol.util.classes.FileManagerUtil;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.methods.FlStringUtil;

public class ModelPathUtil {
    public static PropFeature getFeature(Model model, String string) {
        String[] stringArray = FlStringUtil.strSplit((String)string, (int)47);
        if (stringArray[0].equals("geom")) {
            if (stringArray.length != 3) {
                throw new RuntimeException("Geometry model path must contain 3 parts.");
            }
            return model.geom(stringArray[1]).feature(stringArray[2]);
        }
        if (stringArray[0].equals("result")) {
            if (stringArray[1].equals("numerical")) {
                return model.result().numerical(stringArray[2]);
            }
            if (stringArray[1].equals("export")) {
                return model.result().export(stringArray[2]);
            }
            if (stringArray[1].equals("dataset")) {
                return model.result().dataset(stringArray[2]);
            }
            if (stringArray.length == 2) {
                return model.result(stringArray[1]);
            }
            if (stringArray.length == 3) {
                return model.result(stringArray[1]).feature(stringArray[2]);
            }
            if (stringArray.length == 4) {
                return model.result(stringArray[1]).feature(stringArray[2]).feature(stringArray[3]);
            }
        } else if (stringArray[0].equals("view")) {
            if (stringArray.length == 4) {
                if (stringArray[2].equals("light")) {
                    return model.view(stringArray[1]).light(stringArray[3]);
                }
            } else {
                if (stringArray.length == 2) {
                    return model.view(stringArray[1]);
                }
                if (stringArray.length == 3 && stringArray[2].equals("camera")) {
                    return model.view(stringArray[1]).camera();
                }
            }
        }
        throw new RuntimeException("Unknown model object path '" + string + "'");
    }

    public static String resolveOutputPath(String string, ModelEntity modelEntity) {
        String string2;
        if (string.trim().length() == 0) {
            throw new FlException("Empty_filename");
        }
        Model model = modelEntity.getModel();
        if (!FileManagerUtil.i((String)string, (String)model.tag()) && (string2 = model.getSaveLocation().b()).length() > 0) {
            return String.valueOf(FileManagerUtil.l((String)string2, (String)model.tag())) + SystemUtil.getClientFileSeparator() + string;
        }
        return string;
    }
}

