/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.util;

import com.comsol.model.analysis.IAnalysisOperation;
import com.comsol.model.applapi.IVariableData;
import com.comsol.model.applapi.VariableInfo;
import com.comsol.model.dbimodel.DEPVAR_TYPE;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.dbimodel.ReducedModel;
import com.comsol.model.dbimodel.SOLSEQ_TYPES;
import com.comsol.model.dbimodel.SOLVER_MODE;
import com.comsol.model.dbimodel.SolutionNative;
import com.comsol.model.dbimodel.SolverSequence;
import com.comsol.model.dbimodel.StudyFeature;
import com.comsol.model.operations.IDatasetOperation;
import com.comsol.model.util.ModelEntityUtil;
import com.comsol.model.util.ReducedModelCandidate;
import com.comsol.nativemph.util.f;
import com.comsol.nativemph.xmesh.Solution;
import com.comsol.nativeutil.properties.dq;
import com.comsol.nativeutil.w;
import com.comsol.util.classes.FlStringList;
import com.comsol.util.methods.FlLocale;
import com.comsol.util.methods.FlStringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.IntStream;

public class ReducedModelUtil {
    public static boolean isPhysicsReconstructionActive(StudyFeature studyFeature, String string) {
        if (studyFeature != null && studyFeature.contributesPhysics() && studyFeature.getModel().physics().hasTag(string) && studyFeature.getModel().reduced().size() > 0 && studyFeature.hasProperty("reconstructors") && studyFeature.hasPropValue("reconstructors")) {
            dq dq2 = (dq)studyFeature.getPropValueInternal("reconstructors").getProperty();
            Map map = dq2.d();
            return !studyFeature.activate(string) && map.containsKey(string) && !"none".equals(map.get(string));
        }
        return false;
    }

    public static boolean canReconstruct(ReducedModel reducedModel, String string) {
        if (!reducedModel.isActive()) {
            return false;
        }
        if (reducedModel.getModel().isCreateReset()) {
            return true;
        }
        if (!ReducedModelUtil.reconstructEnabled(reducedModel) || reducedModel.getSrc() == null || !FlStringUtil.contains((String[])reducedModel.getModel().sol().tags(), (String)reducedModel.getSrc())) {
            return false;
        }
        SolverSequence solverSequence = reducedModel.getModel().sol(reducedModel.getSrc());
        if (solverSequence.getSavePoint() == null) {
            return false;
        }
        IVariableData iVariableData = reducedModel.getModel().physics().getVarData();
        String[] stringArray = FlStringUtil.prepend((String)"root.", (String[])reducedModel.getStringArray("reconstructors"));
        if (stringArray.length == 0) {
            return false;
        }
        boolean bl2 = false;
        String[] stringArray2 = iVariableData.getAllTensorVariableKeys();
        int n2 = stringArray2.length;
        int n3 = 0;
        while (n3 < n2) {
            String string2 = stringArray2[n3];
            if (!(iVariableData.getApplModeName(string2) == null || !iVariableData.getApplModeName(string2).equals(string) || !iVariableData.getVariable(string2).getType().isShape() && iVariableData.getVariable(string2).getType() != VariableInfo.Type.XMesh || !iVariableData.getVariable(string2).getInfo().depVarType().equals(DEPVAR_TYPE.NORMAL) || iVariableData.getVariable(string2).getInfo().isConstrVar() || iVariableData.getVariable(string2).getType().isDeclaration() && iVariableData.getVariable(string2).getType() != VariableInfo.Type.XMesh || iVariableData.getVariable(string2).getType().isExpressionVariable() || !FlStringUtil.containsAny((String[])iVariableData.getVariable(string2).getComponents(), (String[])stringArray))) {
                bl2 = true;
            }
            ++n3;
        }
        return bl2;
    }

    public static boolean canUpdateSolution(ReducedModel reducedModel) {
        if (!reducedModel.getOperation().isReconstructionEnabled() || reducedModel.getSrc() == null || !FlStringUtil.contains((String[])reducedModel.getModel().sol().tags(), (String)reducedModel.getSrc())) {
            return false;
        }
        SolverSequence solverSequence = reducedModel.getModel().sol(reducedModel.getSrc());
        return solverSequence.getSavePoint() != null && solverSequence.getStudyFeature() != null;
    }

    public static boolean outputDepVarEnabled(ReducedModel reducedModel) {
        return reducedModel.hasProperty("depvars") ? reducedModel.getBoolean("depvars") : false;
    }

    public static void updateOnlineModel(ReducedModel reducedModel, Solution solution) {
        String string = reducedModel.getSrc();
        SolverSequence solverSequence = FlStringUtil.contains((String[])reducedModel.getModel().sol().tags(), (String)string) ? reducedModel.getModel().sol(string) : reducedModel.getModel().sol().create(reducedModel.getModel().sol().uniquetag("rd"));
        for (PropFeature object2 : reducedModel.getModel().result().dataset()) {
            if (!((IDatasetOperation)object2.getOperation()).isSolution() || !object2.getString("solution").equals(solverSequence.getTag())) continue;
            object2.addFlag(ModelEntity.Flags.AUTOGENERATED);
        }
        solverSequence.addFlag(ModelEntity.Flags.NOREMOVE);
        solverSequence.setDerivedFrom(reducedModel);
        String string2 = ModelEntityUtil.uniqueNameWithinList(solverSequence, FlLocale.getString((String)"Reduced_model_data", (boolean)true));
        solverSequence.label(string2);
        solverSequence.setStudyFeature(null);
        Iterator iterator = solverSequence.getSolution();
        if (solution != null && !solution.equals(iterator)) {
            solverSequence.setSolverMode(SOLVER_MODE.RUNNING);
            SolutionNative solutionNative = solverSequence.getModel().sol().createSolutionNative();
            solutionNative.setSolution(solution);
            solverSequence.setSolutionnativeData(solutionNative, SOLSEQ_TYPES.ROM);
            solutionNative.updateInfo();
            solverSequence.setSolverMode(SOLVER_MODE.DONE);
            solverSequence.getSolutioninfo().touch();
        } else if (iterator == null) {
            iterator = new Solution();
        }
        solverSequence.getSolution().j("all");
        solverSequence.setClusterStorage("all");
        reducedModel.setSrc(solverSequence.tag());
    }

    public static boolean isApplicableToStudy(ReducedModel reducedModel, IAnalysisOperation iAnalysisOperation) {
        return reducedModel.getOperation().isApplicableToStudy(iAnalysisOperation);
    }

    public static FlStringList getOutcomp(f f2) {
        ArrayList<w> arrayList = new ArrayList<w>(Arrays.asList(f2.Q("variables")));
        FlStringList flStringList = new FlStringList();
        for (w w2 : arrayList) {
            w2.a("solvefor", false);
            if (!w2.A("solvefor").equals("on")) continue;
            w2.k("comp");
            FlStringList flStringList2 = new FlStringList(w2.E("comp"));
            flStringList.add(flStringList2.toArray());
        }
        return flStringList;
    }

    public static String mergeOldConfiguration(String string, String string2, String string3) {
        ReducedModelCandidate reducedModelCandidate = new ReducedModelCandidate(string);
        if (string2 != null) {
            String string4;
            ReducedModelCandidate reducedModelCandidate2 = new ReducedModelCandidate(string2);
            String[] stringArray = reducedModelCandidate2.getControls();
            String[] stringArray2 = reducedModelCandidate.getControls();
            int n2 = stringArray2.length;
            int n3 = 0;
            while (n3 < n2) {
                string4 = stringArray2[n3];
                if (FlStringUtil.contains((String[])stringArray, (String)string4)) {
                    string4 = ReducedModelUtil.clearScope(string3, string4);
                    reducedModelCandidate.setControl(string4, reducedModelCandidate2.getValues(new String[]{string4})[0]);
                }
                ++n3;
            }
            stringArray = reducedModelCandidate2.getActiveProperties();
            stringArray2 = reducedModelCandidate.getActiveProperties();
            n2 = stringArray2.length;
            n3 = 0;
            while (n3 < n2) {
                string4 = stringArray2[n3];
                if (FlStringUtil.contains((String[])stringArray, (String)string4)) {
                    reducedModelCandidate.set(string4, reducedModelCandidate2.getValues(new String[]{string4})[0]);
                }
                ++n3;
            }
            stringArray = reducedModelCandidate2.getParameters();
            stringArray2 = reducedModelCandidate.getParameters();
            n2 = stringArray2.length;
            n3 = 0;
            while (n3 < n2) {
                string4 = stringArray2[n3];
                if (FlStringUtil.contains((String[])stringArray, (String)string4)) {
                    reducedModelCandidate.setParameter(string4, reducedModelCandidate2.getValues(new String[]{string4})[0]);
                }
                ++n3;
            }
            stringArray = FlStringUtil.removeBlanks((String[])reducedModelCandidate2.getOutputs());
            stringArray2 = reducedModelCandidate.getOutputs();
            n2 = stringArray2.length;
            n3 = 0;
            while (n3 < n2) {
                string4 = stringArray2[n3];
                if (FlStringUtil.contains((String[])stringArray, (String)string4)) {
                    String[] stringArray3 = reducedModelCandidate2.getValues(new String[]{string4})[0].split(",");
                    String[] stringArray4 = reducedModelCandidate.getValues(new String[]{string4})[0].split(",");
                    string4 = ReducedModelUtil.clearScope(string3, string4);
                    reducedModelCandidate.setOutput(string4, String.valueOf(stringArray3[0]) + "," + stringArray4[1]);
                }
                ++n3;
            }
        }
        return reducedModelCandidate.getConfiguration();
    }

    public static String[] clearScope(String string, String[] stringArray) {
        String[] stringArray2 = (String[])stringArray.clone();
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray2[n2] = ReducedModelUtil.clearScope(string, stringArray[n2]);
            ++n2;
        }
        return stringArray2;
    }

    public static String clearScope(String string, String string2) {
        if (string2.startsWith("root.")) {
            string2 = string2.substring("root.".length());
        }
        if (string2.startsWith(String.valueOf(string) + ".")) {
            string2 = string2.substring((String.valueOf(string) + ".").length());
        }
        return string2;
    }

    public static boolean supportsReset(ReducedModel reducedModel) {
        return reducedModel.getROMData() != null && reducedModel.getROMData().W() != null && reducedModel.getROMData().W().length() > 0 && reducedModel.getSrc() != null && !reducedModel.getSrc().isEmpty() && reducedModel.getModel().sol(reducedModel.getSrc()).getSolution().W().length() > 0;
    }

    public static void checkAndResetReconstructProperty(PropFeature propFeature, PropFeature propFeature2) {
        if (propFeature2.getOperation().getPropSet().getFromAllProperty("reconstruct") != null) {
            String[] stringArray = propFeature2.getOperation().getPropSet().getFromAllProperty("reconstruct").getExternalCheck().getAllowedValues();
            String[] stringArray2 = propFeature2.getStringArray("comp");
            if (stringArray.length > 0 && stringArray2.length > 0) {
                if (!FlStringUtil.contains((String[])stringArray, (String)propFeature2.getString("reconstruct")) && !"none".equals(propFeature2.getString("reconstruct"))) {
                    propFeature2.set("reconstruct", "none");
                }
            } else if (!"none".equals(propFeature2.getString("reconstruct"))) {
                propFeature2.set("reconstruct", "none");
            }
        }
    }

    public static void updateReconstructProperty(PropFeature propFeature, PropFeature propFeature2) {
        if (propFeature2.getOperation().getPropSet().getFromAllProperty("reconstruct") != null) {
            String[] stringArray = propFeature2.getOperation().getPropSet().getFromAllProperty("reconstruct").getExternalCheck().getAllowedValues();
            String[] stringArray2 = propFeature2.getStringArray("comp");
            if (stringArray.length > 0 && stringArray2.length > 0) {
                String string = ((StudyFeature)propFeature.getPropertyReference("control")).getString("reconstructors");
                if (string == null || string.length() == 0) {
                    if (!"none".equals(propFeature2.getString("reconstruct"))) {
                        propFeature2.set("reconstruct", "none");
                    }
                    return;
                }
                String[] stringArray3 = string == null ? null : FlStringUtil.splitCSVIntoTokens((String)string);
                int n2 = 0;
                while (n2 < stringArray3.length) {
                    String string2 = propFeature2.getModel().physics().getVarData().getApplModeName("root." + stringArray2[0]);
                    if (stringArray3[n2].equals(string2) && !stringArray3[n2 + 1].equals(propFeature2.getString("reconstruct")) && (FlStringUtil.contains((String[])stringArray, (String)stringArray3[n2 + 1]) || "none".equals(stringArray3[n2 + 1]))) {
                        propFeature2.set("reconstruct", stringArray3[n2 + 1]);
                        break;
                    }
                    n2 += 2;
                }
            }
        }
    }

    public static boolean reconstructEnabled(ReducedModel reducedModel) {
        return reducedModel.getOperation().isReconstructionEnabled();
    }

    public static String[] generateVariablesHashMap(PropFeature propFeature, String[] stringArray) {
        int n3 = propFeature.getModel().reduced().size();
        if (n3 == 0) {
            return new String[0];
        }
        String[] stringArray2 = new String[n3 * 2];
        int n4 = 0;
        for (ReducedModel reducedModel : propFeature.getModel().reduced()) {
            stringArray2[n4++] = reducedModel.tag();
            int[] nArray = IntStream.range(0, stringArray.length).filter(n2 -> n2 % 2 == 0 && stringArray[n2].startsWith(String.valueOf(reducedModel.tag()) + ".") && !stringArray[n2].equals(String.valueOf(reducedModel.tag()) + ".loadfact")).toArray();
            ArrayList<String> arrayList = new ArrayList<String>();
            int[] nArray2 = nArray;
            int n5 = nArray.length;
            int n6 = 0;
            while (n6 < n5) {
                int n7;
                int n8 = n7 = nArray2[n6];
                while (n8 >= 0) {
                    arrayList.add(stringArray[n8]);
                    arrayList.add(stringArray[n8 + 1]);
                    n8 = IntStream.range(0, stringArray.length).filter(n2 -> n2 % 2 == 0 && stringArray[n2].equals(arrayList.get(arrayList.size() - 1))).findFirst().orElse(-1);
                }
                ++n6;
            }
            stringArray2[n4++] = FlStringUtil.getKey((String[])arrayList.toArray(new String[0]));
        }
        return stringArray2;
    }
}

