/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.util;

import com.comsol.model.data.IUndoRedoStackListener;
import com.comsol.model.data.UndoRedo;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbmodel.ModelDb;

public class UndoRedoUtil {
    public static boolean startUndoTransaction(Model model) {
        ModelDb modelDb = (ModelDb)model;
        return modelDb.getRootNode().getUndoManager().startTransaction();
    }

    public static void undoTransaction(Model model) {
        ModelDb modelDb = (ModelDb)model;
        modelDb.getRootNode().getUndoManager().undo();
    }

    public static void redoTransaction(Model model) {
        ModelDb modelDb = (ModelDb)model;
        modelDb.getRootNode().getUndoManager().redo();
    }

    public static boolean canUndoTransaction(Model model) {
        ModelDb modelDb = (ModelDb)model;
        return modelDb.getRootNode().getUndoManager().canUndo();
    }

    public static boolean canRedoTransaction(Model model) {
        ModelDb modelDb = (ModelDb)model;
        return modelDb.getRootNode().getUndoManager().canRedo();
    }

    public static void setNumberUndoSteps(Model model, int n2) {
        ModelDb modelDb = (ModelDb)model;
        modelDb.getRootNode().getUndoManager().setMaximalUndoLength(n2);
    }

    public static void addUndoRedoListener(Model model, IUndoRedoStackListener iUndoRedoStackListener) {
        ModelDb modelDb = (ModelDb)model;
        modelDb.getRootNode().getUndoManager().addUndoRedoStackListener(iUndoRedoStackListener);
    }

    public static void removeUndoRedoListener(Model model, IUndoRedoStackListener iUndoRedoStackListener) {
        ModelDb modelDb = (ModelDb)model;
        modelDb.getRootNode().getUndoManager().removeUndoRedoStackListener(iUndoRedoStackListener);
    }

    public static void clearUndoStack(Model model) {
        UndoRedo undoRedo = model.getNode().getRoot().getUndoManager();
        undoRedo.clearUndoStack(true);
    }

    public static void clearRedoStack(Model model) {
        UndoRedo undoRedo = model.getNode().getRoot().getUndoManager();
        undoRedo.clearRedoStack();
    }
}

