/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.util.saveload;

import com.comsol.dbmigration.framework.ModelTypes;
import com.comsol.model.data.CompleteSavePoint;
import com.comsol.model.data.Node;
import com.comsol.model.data.Root;
import com.comsol.model.data.primitive.NativePrim;
import com.comsol.model.database.DatabaseInfoXmlUtil;
import com.comsol.model.database.DatabaseModelDescriptor;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.dbimodel.SavePoint;
import com.comsol.model.dbmodel.ModelDb;
import com.comsol.model.dbmodel.XMeshNativeDb;
import com.comsol.model.operations.IAddinImportOperation;
import com.comsol.model.operations.operationID.AppOperationID;
import com.comsol.model.savepoint.SavePointSaveCache;
import com.comsol.model.savepoint.SpModel;
import com.comsol.model.savepoint.interfaces.IModel;
import com.comsol.model.simple.SimpleUtil;
import com.comsol.model.util.IStoredModel;
import com.comsol.model.util.LibraryFileUtil;
import com.comsol.model.util.LibraryNodeType;
import com.comsol.model.util.ModelInternalUtil;
import com.comsol.model.util.ModelLoadUtil;
import com.comsol.model.util.ModelType;
import com.comsol.model.util.SaveLoadFile;
import com.comsol.model.util.XMeshInitializer;
import com.comsol.model.util.saveload.AbstractModelSaver;
import com.comsol.model.util.saveload.IModelMiscSaver;
import com.comsol.nativemph.binary.BinaryManager;
import com.comsol.nativemph.binary.BinaryType;
import com.comsol.nativemph.util.e;
import com.comsol.nativemph.xmesh.Xmesh;
import com.comsol.nativeutil.preferences.Preferences;
import com.comsol.nativeutil.runnable.k;
import com.comsol.systemutils.SystemUtil;
import com.comsol.util.classes.FileManagerUtil;
import com.comsol.util.classes.FlVersion;
import com.comsol.util.classes.bg;
import com.comsol.util.classes.d;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.file.c;
import com.comsol.util.license.LicenseType;
import com.comsol.util.logger.FlLogger;
import com.comsol.util.methods.FlStringUtil;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.bind.DatatypeConverter;

public abstract class AbstractMphSaver
extends AbstractModelSaver {
    public static boolean addNewHistoryBlockOnSave = false;
    private final c[] a;
    protected final boolean saveCopy;

    public AbstractMphSaver(IStoredModel iStoredModel, SaveLoadFile saveLoadFile, c[] cArray, boolean bl2) {
        this(iStoredModel, saveLoadFile, cArray, bl2, null);
    }

    public AbstractMphSaver(IStoredModel iStoredModel, SaveLoadFile saveLoadFile, c[] cArray, boolean bl2, IModelMiscSaver iModelMiscSaver) {
        super(iStoredModel, saveLoadFile, iModelMiscSaver);
        this.a = cArray;
        this.saveCopy = bl2;
    }

    @Override
    protected void doSave(k k2) throws IOException {
        this.a(k2);
    }

    private void a(k k2) throws IOException {
        Model model = this.getModel();
        this.prepareSave();
        this.disposeUnusedSavePointModels();
        ModelLoadUtil.disposeSolverSequenceListData(this.getModel());
        this.a();
        if (!this.saveCopy) {
            ((ModelDb)model).updateEntityModified();
        }
        ((ModelDb)model).setComsolVersion(FlVersion.currentProductVersionLongString());
        model.setSavedInVersion(this.migrator.a(ModelTypes.a));
        this.saveLicenceNumber(model);
        this.createFileIdWriter();
        k2.a(5.0);
        this.saveFileVersion(ModelTypes.a);
        this.preSaveFileResources(false);
        this.b(model);
        this.b();
        this.c();
        this.saveUpdatedRecoveryFileDescr();
        k2.a(5.0);
        this.saveCompleteSavePointModels();
        k2.a(5.0);
        String string = this.savePassWordInfo(model);
        Map<BinaryManager.g, String> map = null;
        com.comsol.nativemph.binary.a a2 = this.getBinaryManager();
        try {
            a2.initializeSave(this.savingRecovery());
            this.saveModelXML(string);
            this.saveEMFModelXML();
            k2.a(5.0);
            this.d();
            k2.a(10.0);
            this.e();
            this.saveFileResources();
            this.saveDatabaseInfoXml();
            map = this.saveBinaries(a2, k2);
        }
        finally {
            a2.finishedSave();
        }
        this.saveModelInfoFile(LibraryFileUtil.getNodeType(this.getModel()));
        if (this.supportsLibraryIndexing()) {
            this.saveLibraryIndex();
        }
        this.saveFileIDs();
        if (map != null) {
            this.saveClusterIgnore(model, a2, map);
        }
    }

    protected boolean supportsLibraryIndexing() {
        return false;
    }

    protected void prepareSave() throws IOException {
        long l2 = new Date().getTime();
        String string = SystemUtil.getModelUser((String)Preferences.getInstance().getPreference("general.username.name"));
        this.updateModifiedBy(l2, string);
        Model model = this.getModel();
        model.view().storeLocalProperties();
        model.result().storeLocalProperties();
        model.physics().storeLocalProperties();
        model.form().stream().map(formFeature -> formFeature.getAppFeature().view()).forEachOrdered(appViewList -> appViewList.storeLocalProperties());
        if (model.getModelType() == ModelType.APPLICATION_MODEL) {
            model.modelData().view().storeLocalProperties();
        }
        model.storeLocalMethodBreakpoints();
        if (addNewHistoryBlockOnSave) {
            model.hist().addNewBlockIfLastIsLarge();
        }
        this.a(model);
    }

    private void a(Model model) {
        for (PropFeature propFeature : model.appBuilderFeature()) {
            if (!AppOperationID.ADDIN_IMPORT.isOfType(propFeature)) continue;
            ((IAddinImportOperation)((Object)propFeature.getOperation())).storeAddinModel();
        }
    }

    protected void updateModifiedBy(long l2, String string) {
        this.storedModel.setModifiedBy(string, l2);
    }

    protected void saveFileVersion(ModelTypes modelTypes) throws IOException {
        this.addArchiveEntry("", "fileversion", new ByteArrayInputStream(this.getFileVersionString(modelTypes).getBytes(StandardCharsets.UTF_8)), false);
    }

    private void a() {
        Model model = this.getModel();
        model.sol().saveSolverFeatureStateKeys();
        model.batch().saveBatchFeatureStateKeys();
    }

    protected void preSaveFileResources(boolean bl2) throws IOException {
        ModelLoadUtil.preSaveFileResources(this.getModel(), bl2);
        e e2 = ((Root)this.getModel().getNode()).getFileResourceManager();
        e2.a();
    }

    protected void saveFileResources() throws IOException {
        this.doSaveFileResources(this.saveCopy);
    }

    protected void doSaveFileResources(boolean bl2) throws IOException {
        e e2 = ((Root)this.getModel().getNode()).getFileResourceManager();
        e2.a((e.a)new MphResourceSaver(this, bl2));
    }

    protected void fileResourceSaved(String string) {
    }

    private void b(Model model) throws IOException {
        for (bg<String, File> bg2 : ModelLoadUtil.getCadIdsFiles(model)) {
            this.addArchiveEntry("", (String)bg2.a, (File)bg2.b, false);
        }
    }

    private void b() throws IOException {
        ModelLoadUtil.saveModelAndPartImages(this.getModel(), new ModelLoadUtil.SaveEntry(){

            @Override
            public void save(String string, String string2, File file, boolean bl2) throws IOException {
                AbstractMphSaver.this.addArchiveEntry(string, string2, file, bl2);
            }
        });
    }

    protected void saveModelInfoFile(LibraryNodeType libraryNodeType) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(this.getOutputStream("", "modelinfo.xml"), StandardCharsets.UTF_8));
        ModelLoadUtil.writeModelInfo(bufferedWriter, this.getModel(), libraryNodeType);
    }

    private void c() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(this.getOutputStream("", "usedlicenses.txt"), StandardCharsets.UTF_8));){
            for (LicenseType licenseType : ModelInternalUtil.getUsedLicenses(this.getModel())) {
                bufferedWriter.write(String.valueOf(licenseType.name()) + "\n");
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected String savePassWordInfo(Model model) {
        String string = null;
        if (model.isPasswordProtected()) {
            try {
                string = this.savePassword(model);
            }
            catch (Exception exception) {
                throw new FlException("Failed_to_save_model");
            }
        }
        return string;
    }

    protected final String savePassword(Model model) throws IOException {
        String string = ((ModelDb)model).getPassword();
        int n2 = ((ModelDb)model).getPasswordKey();
        String string2 = null;
        Model.ProtectionLevel protectionLevel = model.getProtectionLevel();
        if (protectionLevel == Model.ProtectionLevel.EDITING) {
            String string3 = ((ModelDb)model).getRuntimePassword();
            string2 = this.generateKeyForSaving();
            String string4 = ModelType.APPLICATION_MODEL.getKeyFileName();
            String string5 = string3 != null ? FlStringUtil.decryptString((String)string3, (int)n2) : null;
            SimpleUtil.serializeObject(this.getOutputStream("", string4), true, string5, string4, string2, n2);
            String string6 = ModelType.MODEL.getKeyFileName();
            SimpleUtil.serializeObject(this.getOutputStream("", string6), true, FlStringUtil.decryptString((String)string, (int)n2), string6, string2, n2, string3);
        } else if (protectionLevel == Model.ProtectionLevel.RUNNING) {
            this.a(this.getOutputStream("", ModelType.MODEL.getKeyFileName()), DatatypeConverter.parseBase64Binary((String)FlStringUtil.decryptString((String)string, (int)n2)));
            String string7 = ModelType.APPLICATION_MODEL.getKeyFileName();
            String string8 = ((ModelDb)model).getRuntimePassword();
            byte[] byArray = ((ModelDb)model).getRawByteData();
            this.a(this.getOutputStream("", string7), byArray);
            String string9 = string8 != null ? FlStringUtil.decryptString((String)string8, (int)n2) : null;
            Object[] objectArray = SimpleUtil.deSerializeObject(new ByteArrayInputStream(byArray), true, string9, String.class, String.class);
            string2 = (String)objectArray[1];
        }
        return string2;
    }

    protected String generateKeyForSaving() {
        return d.b();
    }

    private void a(OutputStream outputStream, byte[] byArray) throws FileNotFoundException, IOException {
        if (byArray == null) {
            return;
        }
        try {
            outputStream.write(byArray, 0, byArray.length);
        }
        finally {
            if (outputStream != null) {
                outputStream.flush();
                outputStream.close();
            }
        }
    }

    protected void saveModelXML(String string) throws IOException {
        OutputStream outputStream = this.getOutputStream("", "dmodel.xml");
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return;
        }
        outputStream = new DigestOutputStream(outputStream, messageDigest);
        try {
            Model model;
            if (string != null) {
                outputStream = SimpleUtil.wrapWithEncryptOutputStream(outputStream, true, string);
            }
            if ((model = this.getModel()) != null) {
                Root root = (Root)model.getNode();
                root.toXMLFile(outputStream);
            }
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    protected void saveLibraryIndex() {
        File file;
        Model model = this.getModel();
        if (model != null && (file = ModelInternalUtil.writeModelXmlToTempFile(model)) != null) {
            String[] stringArray = FileManagerUtil.d((String)FileManagerUtil.n((String)model.comments()));
            String[] stringArray2 = com.comsol.util.library.a.a((File)file, (String[])stringArray, null);
            String string = FlStringUtil.delimitedString((String[])stringArray2, (String)System.lineSeparator());
            try {
                this.addArchiveEntry("", "index.txt", new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8)), false);
                file.delete();
            }
            catch (IOException iOException) {
                FlLogger.a((String)"Failed to add search index to placeholder MPH-file.", (Throwable)iOException);
            }
        }
    }

    protected boolean savingRecovery() {
        return false;
    }

    protected void saveEMFModelXML() throws IOException {
        String string = "<?xml version=\"1.0\"?><com.comsol.mph-v15:Model xmi:version=\"2.0\" xmlns:xmi=\"http://www.omg.org/XMI\" xmlns:com.comsol.mph-v15=\"http://www.comsol.com/mph/v15\" savedInVersion=\"10000\"></com.comsol.mph-v15:Model>";
        this.addArchiveEntry("", "model.xml", new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8)), false);
    }

    protected void disposeUnusedSavePointModels() {
        ModelLoadUtil.disposeUnusedSavePointModels(this.getModel());
    }

    private void d() throws IOException {
        Model model = this.getModel();
        List<IModel> list = model.getSavePointModels();
        SavePointSaveCache savePointSaveCache = new SavePointSaveCache();
        for (a a2 : this.prepareSavePointSave(list)) {
            if (a2.b) {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(this.getOutputStream(a2.a.tag(), "savepoint.xml"), StandardCharsets.UTF_8);
                ModelInternalUtil.serializeSavePointModel(a2.a, outputStreamWriter, savePointSaveCache);
                continue;
            }
            a2.a.dryToXML(savePointSaveCache);
        }
    }

    protected List<a> prepareSavePointSave(List<IModel> list) {
        return list.stream().map(iModel -> new a((SpModel)iModel, true)).collect(Collectors.toList());
    }

    protected void saveCompleteSavePointModels() throws IOException {
        Model model = this.getModel();
        CompleteSavePoint.CspMphSaver cspMphSaver = new CompleteSavePoint.CspMphSaver(){

            @Override
            public void save(String string, String string2, InputStream inputStream, boolean bl2) throws IOException {
                AbstractMphSaver.this.addArchiveEntry(string, string2, inputStream, bl2);
            }

            @Override
            public boolean tryReuse(String string, String string2) {
                return AbstractMphSaver.this.tryReuseCompleteSavePoint(string, string2);
            }
        };
        for (String string : model.getSavePointTags()) {
            ((ModelDb)model).saveCompleteSavePointToMphFile(string, cspMphSaver);
        }
    }

    protected boolean tryReuseCompleteSavePoint(String string, String string2) {
        return false;
    }

    private void e() throws IOException {
        if (this.a != null) {
            c[] cArray = this.a;
            int n2 = this.a.length;
            int n3 = 0;
            while (n3 < n2) {
                c c2 = cArray[n3];
                if (c2 != null) {
                    String string = c2.a();
                    for (c.a a2 : c2.b()) {
                        this.addArchiveEntry(string, a2.b(), ModelInternalUtil.getExistingFile(a2.a(), null), a2.c());
                    }
                }
                ++n3;
            }
        }
    }

    protected Map<BinaryManager.g, String> saveBinaries(com.comsol.nativemph.binary.a a2, k k2) throws IOException {
        if (a2 instanceof BinaryManager) {
            for (SavePoint object2 : ModelInternalUtil.getSavePoints(this.getModel())) {
                if (object2 == null) continue;
                int n2 = 0;
                while (n2 < object2.nXmeshes()) {
                    Node node;
                    NativePrim nativePrim;
                    XMeshNativeDb xMeshNativeDb = (XMeshNativeDb)object2.getXmeshNoRecreate(n2);
                    if (xMeshNativeDb != null && xMeshNativeDb.hasXmesh() && (nativePrim = (NativePrim)(node = xMeshNativeDb.getNode()).dGet("xmesh")) != null) {
                        BinaryType binaryType = nativePrim.getType();
                        long l2 = nativePrim.getNativeTag();
                        a2.setResourceInitializer((BinaryManager.c)new XMeshInitializer(object2, Xmesh.XMESH_DISTR_TYPE.c), binaryType, l2);
                    }
                    ++n2;
                }
            }
            HashMap<BinaryManager.g, String> hashMap = new HashMap<BinaryManager.g, String>();
            ((BinaryManager)a2).saveResourses(this.getBinaryResourceSaver(), this.saveCopy, k2, 60.0, hashMap);
            return hashMap;
        }
        return null;
    }

    protected void saveUpdatedRecoveryFileDescr() throws IOException {
    }

    protected void saveDatabaseInfoXml() throws IOException {
        DatabaseModelDescriptor databaseModelDescriptor = this.getModel().getNode().getRoot().getDatabaseModelDescriptor();
        if (databaseModelDescriptor != null) {
            Throwable throwable = null;
            Object var3_4 = null;
            try (OutputStream outputStream = this.getOutputStream("", "databaseinfo.xml");){
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
                DatabaseInfoXmlUtil.writeDatabaseInfoXml(databaseModelDescriptor, bufferedWriter);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
    }

    protected com.comsol.nativemph.binary.a getBinaryManager() {
        return this.getModel().getNode().getRoot().getBinaryManager();
    }

    protected abstract void createFileIdWriter() throws IOException;

    protected abstract void saveFileIDs() throws IOException;

    protected abstract void saveClusterIgnore(Model var1, com.comsol.nativemph.binary.a var2, Map<BinaryManager.g, String> var3) throws IOException;

    protected abstract String getArchivePath();

    protected abstract BinaryManager.b getBinaryResourceSaver() throws IOException;

    protected static class MphResourceSaver
    implements e.a {
        private AbstractMphSaver a;
        private boolean b;

        public MphResourceSaver(AbstractMphSaver abstractMphSaver, boolean bl2) {
            this.a = abstractMphSaver;
            this.b = bl2;
        }

        public String copyFrom(File file, String string) throws IOException {
            this.a.addArchiveEntry("resources", string, file, false);
            this.a.fileResourceSaved(string);
            return "resources/" + string;
        }

        public String getArchiveLocation() {
            return this.a.getArchivePath();
        }

        public boolean saveCopy() {
            return this.b;
        }
    }

    static class a {
        private final SpModel a;
        private final boolean b;

        a(SpModel spModel, boolean bl2) {
            this.a = spModel;
            this.b = bl2;
        }
    }
}

