/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.util.saveload;

import com.comsol.model.database.DatabaseModelDescriptor;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbmodel.ModelDb;
import com.comsol.model.savepoint.SavePointSaveCache;
import com.comsol.model.savepoint.SpModel;
import com.comsol.model.savepoint.interfaces.IModel;
import com.comsol.model.util.IStoredModel;
import com.comsol.model.util.ModelInternalUtil;
import com.comsol.model.util.SaveLoadFile;
import com.comsol.model.util.saveload.AbstractMphSaver;
import com.comsol.model.util.saveload.ClusterIgnoreXmlUtil;
import com.comsol.model.util.saveload.IModelMiscSaver;
import com.comsol.model.util.saveload.RecoveryData;
import com.comsol.nativemph.binary.BinaryManager;
import com.comsol.nativemph.binary.a;
import com.comsol.nativeutil.runnable.k;
import com.comsol.systemutils.SystemUtil;
import com.comsol.util.classes.CsXMLWriter;
import com.comsol.util.file.c;
import com.comsol.util.methods.FlFileUtil;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class RecoveryMphSaver
extends AbstractMphSaver {
    public static final String ZIP_FILE_RECOVERY_XML_TAG = "ZipFile";
    public static final String DATABASE_RECOVERY_XML_TAG = "Database";
    private final CsXMLWriter a;
    private final String b;
    private Collection<String> c;

    public RecoveryMphSaver(IStoredModel iStoredModel, c[] cArray) throws IOException {
        this(iStoredModel, cArray, null);
    }

    public RecoveryMphSaver(IStoredModel iStoredModel, c[] cArray, IModelMiscSaver iModelMiscSaver) throws IOException {
        super(iStoredModel, new SaveLoadFile(new File(iStoredModel.getModel().getRecoveryDir())), cArray, true, iModelMiscSaver);
        this.b = iStoredModel.getModel().getRecoveryDir();
        File file = new File(this.b, "recovery.xml");
        BufferedWriter bufferedWriter = FlFileUtil.z((File)file);
        this.a = new CsXMLWriter(bufferedWriter);
        this.a.startDocument();
        this.a.startSection("MPHRecovery", new String[0]);
        File file2 = ((ModelDb)this.getModel()).getTemporaryServerFile();
        String string = file2 != null ? file2.getAbsolutePath() : this.getModel().getSaveLocation().b();
        DatabaseModelDescriptor databaseModelDescriptor = iStoredModel.getModel().getNode().getRoot().getDatabaseModelDescriptor();
        if (string != null && string.length() > 0) {
            this.a.writeElement(ZIP_FILE_RECOVERY_XML_TAG, new String[]{"path", string});
        } else if (databaseModelDescriptor != null) {
            this.a.writeElement(DATABASE_RECOVERY_XML_TAG, databaseModelDescriptor.toAttributePairs());
        }
        FlFileUtil.m((String)this.b);
    }

    @Override
    protected void prepairForResave() throws IOException {
    }

    @Override
    protected boolean savingRecovery() {
        return true;
    }

    @Override
    protected void createFileIdWriter() throws IOException {
    }

    @Override
    protected void saveFileIDs() throws IOException {
    }

    @Override
    protected void saveClusterIgnore(Model model, a a2, Map<BinaryManager.g, String> map) throws IOException {
        File file = SystemUtil.createTempFile((String)".xml");
        ClusterIgnoreXmlUtil.writeClusterIgnoreXml(model, a2, file, map);
        this.addArchiveEntry("", "clusterignore.xml", file, true);
    }

    @Override
    protected String getArchivePath() {
        return this.b;
    }

    @Override
    protected BinaryManager.b getBinaryResourceSaver() {
        return null;
    }

    @Override
    protected Map<BinaryManager.g, String> saveBinaries(a a2, k k2) throws IOException {
        RecoveryData recoveryData = this.storedModel.getRecoveryData();
        HashMap<BinaryManager.g, String> hashMap = new HashMap<BinaryManager.g, String>();
        recoveryData.setBinaryResources(((BinaryManager)a2).saveRecovery(this.a, recoveryData.getBinaryResources(), hashMap));
        return hashMap;
    }

    @Override
    protected void saveFileResources() throws IOException {
        Collection<String> collection = this.storedModel.getRecoveryData().getFileResources();
        this.c = new HashSet<String>();
        this.doSaveFileResources(true);
        this.storedModel.getRecoveryData().setFileResources(this.c);
        for (String string : collection) {
            if (this.c.contains(string)) continue;
            new File(new File(this.b, "resources"), string).delete();
        }
        this.c = null;
    }

    @Override
    protected void fileResourceSaved(String string) {
        this.c.add(string);
    }

    @Override
    protected void disposeUnusedSavePointModels() {
    }

    @Override
    protected List<AbstractMphSaver.a> prepareSavePointSave(List<IModel> list) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
        if (messageDigest == null) {
            return super.prepareSavePointSave(list);
        }
        SavePointSaveCache savePointSaveCache = new SavePointSaveCache();
        final MessageDigest messageDigest2 = messageDigest;
        Writer writer = new Writer(){

            @Override
            public void close() throws IOException {
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void write(char[] cArray, int n2, int n3) throws IOException {
                messageDigest2.update(new String(cArray, n2, n3).getBytes(StandardCharsets.UTF_8));
            }
        };
        ArrayList<AbstractMphSaver.a> arrayList = new ArrayList<AbstractMphSaver.a>();
        for (IModel iModel : list) {
            byte[] byArray = ((SpModel)iModel).getCheckSum();
            ModelInternalUtil.serializeSavePointModel(iModel, writer, savePointSaveCache);
            byte[] byArray2 = messageDigest.digest();
            ((SpModel)iModel).setCheckSum(byArray2);
            messageDigest.reset();
            arrayList.add(new AbstractMphSaver.a((SpModel)iModel, !Arrays.equals(byArray, byArray2)));
        }
        return arrayList;
    }

    @Override
    protected void saveCompleteSavePointModels() throws IOException {
        ((ModelDb)this.getModel()).ensureCompleteSavePointsInRecoveryFolder();
        ((ModelDb)this.getModel()).addCompleteSavePointsRecoveryInfo(this.a);
        Collection<String> collection = this.storedModel.getRecoveryData().getSavePoints();
        HashSet<String> hashSet = new HashSet<String>(this.getModel().getSavePointTags());
        for (String string : collection) {
            if (hashSet.contains(string)) continue;
            SystemUtil.deleteDirectory((File)new File(this.b, string));
        }
        this.storedModel.getRecoveryData().setSavePoints(hashSet);
    }

    @Override
    protected void saveUpdatedRecoveryFileDescr() throws IOException {
        String string = ModelInternalUtil.getUpdatedRecoveryFileDescr(this.getModel());
        this.addArchiveEntry("", "recoveryDescription.txt", new ByteArrayInputStream(string.getBytes(StandardCharsets.UTF_8)), false);
    }

    @Override
    public void addArchiveEntry(String string, String string2, InputStream inputStream, boolean bl2) throws IOException {
        byte[] byArray = new byte[4096];
        OutputStream outputStream = this.getOutputStream(string, string2);
        try {
            int n2;
            while ((n2 = inputStream.read(byArray)) > 0) {
                outputStream.write(byArray, 0, n2);
            }
        }
        finally {
            outputStream.close();
            inputStream.close();
        }
    }

    @Override
    public OutputStream getOutputStream(String string, String string2) throws IOException {
        File file = new File(this.b, string);
        file.mkdirs();
        return new FileOutputStream(new File(file, string2));
    }

    @Override
    protected void finalizeSave(boolean bl2) throws IOException {
        this.a.endSection("MPHRecovery");
        this.a.endDocument();
    }
}

