/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.nativejni;

import com.comsol.nativejni.BlockDeserialization;
import com.comsol.nativejni.BlockSerialization;
import com.comsol.nativejni.FlNativeDeserialization;
import com.comsol.nativejni.FlNativeException;
import com.comsol.nativejni.FlNativeObject;
import com.comsol.nativejni.FlNativeSerialization;
import com.comsol.nativejni.FlNativeUtil;
import com.comsol.nativejni.SerializableProxy;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.license.d;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public abstract class FlNativeSerializable
extends FlNativeObject {
    public final void writeSerializable(ObjectOutputStream objectOutputStream) throws IOException, FlNativeException {
        try {
            FlNativeSerialization flNativeSerialization = new FlNativeSerialization(this);
            int n = flNativeSerialization.getSize();
            objectOutputStream.writeInt(n);
            int n2 = 65536;
            int n3 = 1 + (n - 1) / n2;
            int n4 = 0;
            while (n4 < n3) {
                int n5 = n4 * n2;
                int n6 = n2;
                if (n5 + n6 > n) {
                    n6 = n - n5;
                }
                byte[] byArray = flNativeSerialization.getBlock(n5, n6);
                objectOutputStream.writeObject(byArray);
                ++n4;
            }
        }
        catch (FlException flException) {
            throw new IOException(flException.getMessage());
        }
    }

    public FlNativeDeserialization readSerialStream(ObjectInputStream objectInputStream) throws IOException, FlException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        FlNativeDeserialization flNativeDeserialization = new FlNativeDeserialization(n);
        int n2 = 0;
        while (n2 < n) {
            byte[] byArray = (byte[])objectInputStream.readObject();
            flNativeDeserialization.setBlock(byArray, n2);
            n2 += byArray.length;
        }
        return flNativeDeserialization;
    }

    public void readSerializable(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException, FlNativeException, FlException {
        FlNativeDeserialization flNativeDeserialization;
        try {
            flNativeDeserialization = this.readSerialStream(objectInputStream);
        }
        catch (FlException flException) {
            try {
                if (!"Unknown_class".equals(flException.getMessage())) {
                    throw flException;
                }
                d.c();
                FlNativeUtil.ensureCadLibIsLoaded();
                FlNativeDeserialization flNativeDeserialization2 = this.readSerialStream(objectInputStream);
            }
            catch (FlException flException2) {
                throw new IOException(flException2.getMessage());
            }
            throw new IOException(flException.getMessage());
        }
        try {
            flNativeDeserialization.getSerializable(this);
        }
        catch (FlException flException) {
            if ("Unknown_class".equals(flException.getMessage())) {
                d.c();
                FlNativeUtil.ensureCadLibIsLoaded();
                flNativeDeserialization.getSerializable(this);
            }
            throw flException;
        }
    }

    public abstract void initProxy(SerializableProxy var1) throws FlNativeException;

    public abstract void updateFromProxy(SerializableProxy var1) throws FlNativeException;

    public BlockSerialization createBlockSerialization() {
        return new BlockSerialization(this);
    }

    public BlockDeserialization createBlockDeserialization() {
        return new BlockDeserialization(this);
    }

    protected abstract FlNativeSerializable a();

    public final synchronized FlNativeSerializable cloneCPtr() {
        FlNativeSerializable flNativeSerializable = this.a();
        SerializableProxy serializableProxy = new SerializableProxy(this);
        try {
            flNativeSerializable.updateFromProxy(serializableProxy);
        }
        finally {
            serializableProxy.cleanup(serializableProxy.getCPointer());
        }
        return flNativeSerializable;
    }
}

