/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.nativejni.geom;

import com.comsol.nativejni.CPointer;
import com.comsol.nativejni.FlNativeException;
import com.comsol.nativejni.FlNativeSerializable;
import com.comsol.nativejni.SerializableProxy;
import com.comsol.nativejni.data.RenderDrawGeomJNI;
import com.comsol.nativejni.geom.Geom0;
import com.comsol.nativejni.geom.Geom1;
import com.comsol.nativejni.geom.Geom2;
import com.comsol.nativejni.geom.Geom3;
import com.comsol.nativejni.geom.GeomManagerJNI;
import com.comsol.nativejni.geom.Manifold;
import com.comsol.nativejni.server.FlRunnable;
import com.comsol.nativejni.util.Prop;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.logger.FlLogger;

public abstract class Geom
extends FlNativeSerializable {
    public abstract int getSDim();

    public static final Geom getBaseInstance(int n) {
        switch (n) {
            case 0: {
                return new Geom0();
            }
            case 1: {
                return new Geom1();
            }
            case 2: {
                return new Geom2();
            }
            case 3: {
                return new Geom3();
            }
        }
        throw new RuntimeException("Invalid sdim (" + n + ").");
    }

    public void setIdentityAssocHistory() {
        this.setIdentityAssocHistory(this.getCPointer());
    }

    public int[] getAssocHistorySerialization() {
        return this.getAssocHistorySerialization(this.getCPointer());
    }

    public int getNInputObjects() {
        return this.getNInputObjects(this.getCPointer());
    }

    public void create35aAssocHistory(Geom[] geomArray) {
        this.create35aAssocHistory(this.getCPointer(), Geom.getCPointers(geomArray));
    }

    public final Geom duplicate() {
        Geom geom = Geom.getBaseInstance(this.getSDim());
        this.duplicate(this.getCPointer(), geom.getCPointer());
        return geom;
    }

    public final Geom duplicateVirtual() {
        Geom geom = Geom.getBaseInstance(this.getSDim());
        this.duplicateVirtual(this.getCPointer(), geom.getCPointer());
        return geom;
    }

    @Override
    protected final void doCleanup(CPointer cPointer) throws FlNativeException {
        this.cleanupWS(cPointer);
    }

    public void move(double[] dArray, Prop prop, Prop prop2) {
        this.move(this.getCPointer(), dArray, prop.getCPointer(), prop2.getCPointer());
    }

    public void transform(double[][] dArray, Prop prop, Prop prop2) {
        this.transform(this.getCPointer(), dArray, prop.getCPointer(), prop2.getCPointer());
    }

    public void transform(double[][] dArray, double[][] dArray2, Prop prop, Prop prop2) {
        this.transform(this.getCPointer(), dArray, dArray2, prop.getCPointer(), prop2.getCPointer());
    }

    public void scale(double[] dArray, double[] dArray2, Prop prop, Prop prop2) {
        this.scale(this.getCPointer(), dArray, dArray2, prop.getCPointer(), prop2.getCPointer());
    }

    public void mirror(double[] dArray, double[] dArray2, Prop prop, Prop prop2) {
        this.mirror(this.getCPointer(), dArray, dArray2, prop.getCPointer(), prop2.getCPointer());
    }

    public void rotate(double d2, double[] dArray, double[] dArray2, Prop prop, Prop prop2) {
        this.rotate(this.getCPointer(), d2, dArray2, dArray, prop.getCPointer(), prop2.getCPointer());
    }

    public void chamfer(Prop prop, Prop prop2) {
        this.chamfer(this.getCPointer(), prop.getCPointer(), prop2.getCPointer());
    }

    public void fillet(Prop prop, Prop prop2) {
        this.fillet(this.getCPointer(), prop.getCPointer(), prop2.getCPointer());
    }

    public void coerce(int n, Prop prop, Prop prop2) {
        this.coerce(this.getCPointer(), n, prop.getCPointer(), prop2.getCPointer());
    }

    public void del(Prop prop, Prop prop2) {
        this.del(this.getCPointer(), prop.getCPointer(), prop2.getCPointer());
    }

    public Geom[] split(Prop prop, Prop prop2) {
        return this.split(this.getCPointer(), prop.getCPointer(), prop2.getCPointer());
    }

    public void splitToPrim(Geom[] geomArray, Prop prop, Prop prop2) {
        this.splitToPrim(this.getCPointer(), Geom.getCPointers(geomArray), prop.getCPointer(), prop2.getCPointer());
    }

    public static Geom convertUnion(int n, Geom[] geomArray, int n2, Prop prop, Prop prop2, FlRunnable flRunnable) {
        Geom geom = Geom.getBaseInstance(n2);
        Geom.convertUnion(geom.getCPointer(), n, Geom.getCPointers(geomArray), n2, prop.getCPointer(), prop2.getCPointer(), flRunnable, FlRunnable.getRunInfoCPtr(flRunnable));
        return geom;
    }

    public static Geom group(Geom[] geomArray, int n, Prop prop, Prop prop2, FlRunnable flRunnable) {
        Geom geom = Geom.getBaseInstance(n);
        Geom.group(geom.getCPointer(), Geom.getCPointers(geomArray), n, prop.getCPointer(), prop2.getCPointer(), flRunnable, FlRunnable.getRunInfoCPtr(flRunnable));
        return geom;
    }

    public void getParts(Geom[] geomArray, Prop prop, Prop prop2) {
        this.getParts(this.getCPointer(), Geom.getCPointers(geomArray), prop.getCPointer(), prop2.getCPointer());
    }

    public static Geom comp(Geom[] geomArray, int n, Prop prop, Prop prop2, FlRunnable flRunnable) {
        Geom geom = Geom.getBaseInstance(n);
        Geom.comp(geom.getCPointer(), Geom.getCPointers(geomArray), n, prop.getCPointer(), prop2.getCPointer(), flRunnable, FlRunnable.getRunInfoCPtr(flRunnable));
        return geom;
    }

    public void canonize(Prop prop) {
        this.canonize(this.getCPointer(), prop.getCPointer());
    }

    public void selfUnion(Prop prop) {
        this.selfUnion(this.getCPointer(), prop.getCPointer());
    }

    public void setUseSurfaceNormal(boolean bl) {
        this.setUseSurfaceNormal(this.getCPointer(), bl);
    }

    public void orientBnd(Prop prop) throws FlException {
        this.orientBnd(this.getCPointer(), prop.getCPointer());
    }

    public void swapBndOrient() throws FlException {
        this.swapBndOrient(this.getCPointer());
    }

    public static Geom partitionDomains(Geom geom, int[] nArray, Geom[] geomArray, Prop prop, Prop prop2, FlRunnable flRunnable) {
        Geom geom2 = Geom.getBaseInstance(geom.getSDim());
        Geom.partitionDomains(geom2.getCPointer(), geom.getCPointer(), nArray, Geom.getCPointers(geomArray), prop.getCPointer(), prop2.getCPointer(), flRunnable, FlRunnable.getRunInfoCPtr(flRunnable));
        return geom2;
    }

    public boolean automaticVirtualProcessing(Prop prop, Prop prop2, FlRunnable flRunnable) {
        return this.automaticVirtualProcessing(this.getCPointer(), prop.getCPointer(), prop2.getCPointer(), flRunnable, FlRunnable.getRunInfoCPtr(flRunnable));
    }

    public final int getType() {
        try {
            return this.getType(this.getCPointer());
        }
        catch (FlException flException) {
            FlLogger.a((Throwable)flException);
            throw new RuntimeException(flException.getMessage());
        }
    }

    public final boolean isAssembly() {
        return this.isAssembly(this.getCPointer());
    }

    public final boolean hasCadRep() {
        try {
            return this.hasCadRep(this.getCPointer());
        }
        catch (FlException flException) {
            throw new RuntimeException(flException.getMessage());
        }
    }

    public final void setType(int n) {
        this.setType(this.getCPointer(), n);
    }

    public final int getNDom(int n) {
        return this.getNDom(this.getCPointer(), n);
    }

    public final int getNFiniteVoids() {
        return this.getNFiniteVoids(this.getCPointer());
    }

    public int[] getNEntitiesMesh() {
        return this.getNEntitiesMesh(this.getCPointer());
    }

    public static Geom getMeshGeom(Geom geom, int[][] nArray) {
        Geom geom2 = Geom.getBaseInstance(geom.getSDim());
        Geom.getMeshGeom(geom2.getCPointer(), geom.getCPointer(), nArray);
        return geom2;
    }

    public final int getNPrimEnt() {
        return this.getNPrimEnt(this.getCPointer());
    }

    public final double getGTol() {
        return this.getGTol(this.getCPointer());
    }

    public final double getGScale() {
        return this.getGScale(this.getCPointer());
    }

    public int[][] adj(int[][] nArray, boolean bl) {
        return this.adj(this.getCPointer(), nArray, bl);
    }

    public final void adjSparse(int[][] nArray, Prop prop) {
        this.adjSparse(this.getCPointer(), nArray, prop.getCPointer());
    }

    public int getNumVtx() {
        return this.getNumVtx(this.getCPointer());
    }

    public int getNumEdg() {
        return this.getNumEdg(this.getCPointer());
    }

    public int getNumSub() {
        return this.getNumSub(this.getCPointer());
    }

    public int getNumParts() {
        return this.getNumParts(this.getCPointer());
    }

    public int getNumConComp() {
        return this.getNumConComp(this.getCPointer());
    }

    public double[][] getVtxCoord() {
        return this.getVtxCoord(this.getCPointer());
    }

    public double[][] getVtxCoordMesh() {
        return this.getVtxCoordMesh(this.getCPointer());
    }

    public int[] getVtxDom() {
        return this.getVtxDom(this.getCPointer());
    }

    public double[][] getEdgParam() {
        return this.getEdgParam(this.getCPointer());
    }

    public int[][] getEdgVtx() {
        return this.getEdgVtx(this.getCPointer());
    }

    public final int[][] getUpDownExt() {
        return this.getUpDownExt(this.getCPointer());
    }

    public int[][] getGeomToMeshMapEncoded(int n) {
        return this.getGeomToMeshMapEncoded(this.getCPointer(), n);
    }

    public void checkValidity() {
        this.checkValidity(this.getCPointer());
    }

    public double getMinCoord(int n, boolean bl) {
        return this.getMinCoord(this.getCPointer(), n, bl);
    }

    public double getMaxCoord(int n, boolean bl) {
        return this.getMaxCoord(this.getCPointer(), n, bl);
    }

    @Override
    public void initProxy(SerializableProxy serializableProxy) throws FlNativeException {
        this.initProxy(this.getCPointer(), serializableProxy.getCPointer());
    }

    @Override
    public void updateFromProxy(SerializableProxy serializableProxy) throws FlNativeException {
        this.updateFromProxy(this.getCPointer(), serializableProxy.getCPointer());
    }

    public boolean voidsAreLabeled() {
        return this.voidsAreLabeled(this.getCPointer());
    }

    public int[][] getVtxInt() throws FlNativeException {
        return this.getVtxInt(this.getCPointer());
    }

    public double[][] getVtxDbl() throws FlNativeException {
        return this.getVtxDbl(this.getCPointer());
    }

    public int[][] getEdgInt() throws FlNativeException {
        return this.getEdgInt(this.getCPointer());
    }

    public double[][] getEdgDbl() throws FlNativeException {
        return this.getEdgDbl(this.getCPointer());
    }

    public Manifold[] getCurves() {
        int n = this.getNrCurves(this.getCPointer());
        Manifold[] manifoldArray = new Manifold[n];
        int n2 = 0;
        while (n2 < n) {
            manifoldArray[n2] = Manifold.createNullManifold();
            ++n2;
        }
        this.getCurves(this.getCPointer(), Manifold.a(manifoldArray));
        return manifoldArray;
    }

    public Manifold[] getSurfaces() {
        int n = this.getNrSurfaces(this.getCPointer());
        Manifold[] manifoldArray = new Manifold[n];
        int n2 = 0;
        while (n2 < n) {
            manifoldArray[n2] = Manifold.createNullManifold();
            ++n2;
        }
        this.getSurfaces(this.getCPointer(), Manifold.a(manifoldArray));
        return manifoldArray;
    }

    public String[] getMfdTypes() throws FlNativeException {
        return this.getMfdTypes(this.getCPointer());
    }

    public static Geom createNativeCurve(int n, Manifold manifold) {
        Geom geom = Geom.getBaseInstance(n);
        Geom.createNativeCurve(geom.getCPointer(), n, manifold.getCPointer());
        return geom;
    }

    public static Geom3 createNativeSurface(Manifold manifold, double d2) {
        Geom3 geom3 = new Geom3();
        Geom.createNativeSurface(geom3.getCPointer(), manifold.getCPointer(), d2);
        return geom3;
    }

    public void createGeom() {
        this.createGeom(this.getCPointer());
    }

    public long getSizeInMemory() throws FlNativeException {
        return this.getSizeInMemory(this.getCPointer());
    }

    public long calculateCheckSum() throws FlNativeException {
        return this.calculateCheckSum(this.getCPointer());
    }

    public int calcAdjChecksum() {
        return this.calcAdjChecksum(this.getCPointer());
    }

    public boolean isEntityLinear(int n, int n2) throws FlNativeException {
        return this.isEntityLinear(this.getCPointer(), n, n2);
    }

    public double[] getEdgLength() {
        return this.getEdgLength(this.getCPointer());
    }

    public void classifyLinearEntities(int n, int[] nArray, Prop prop) {
        this.classifyLinearEntities(this.getCPointer(), n, nArray, prop.getCPointer());
    }

    public void getCurvatureProperties(int n, int n2, boolean bl, Prop prop) {
        this.getCurvatureProperties(this.getCPointer(), n, n2, bl, prop.getCPointer());
    }

    public void getBounds(double[] dArray, boolean bl) {
        this.getBounds(this.getCPointer(), dArray, bl);
    }

    public int[] isEdgeCircular() {
        return this.isEdgeCircular(this.getCPointer());
    }

    public static void findPartitionEdgeProjections(Geom[] geomArray, int[][] nArray, int[][] nArray2, Prop prop) {
        Geom.findPartitionEdgeProjections(Geom.getCPointers(geomArray), nArray, nArray2, prop.getCPointer());
    }

    public void assembleRenderingMeshCache(Geom[] geomArray, GeomManagerJNI geomManagerJNI, Prop prop) {
        this.assembleRenderingMeshCache(this.getCPointer(), Geom.getCPointers(geomArray), geomManagerJNI.getCPointer(), prop.getCPointer());
    }

    public void getRenderDrawGeomFromRenderingMeshCache(RenderDrawGeomJNI renderDrawGeomJNI, int n) {
        this.getRenderDrawGeomFromRenderingMeshCache(this.getCPointer(), renderDrawGeomJNI.getCPointer(), n);
    }

    private native void createGeom(CPointer var1) throws FlNativeException;

    private native void duplicate(CPointer var1, CPointer var2) throws FlNativeException;

    private native void duplicateVirtual(CPointer var1, CPointer var2) throws FlNativeException;

    private static native void comp(CPointer var0, CPointer[] var1, int var2, CPointer var3, CPointer var4, FlRunnable var5, CPointer var6) throws FlNativeException;

    private native void coerce(CPointer var1, int var2, CPointer var3, CPointer var4) throws FlNativeException;

    private static native void convertUnion(CPointer var0, int var1, CPointer[] var2, int var3, CPointer var4, CPointer var5, FlRunnable var6, CPointer var7) throws FlNativeException;

    private static native void group(CPointer var0, CPointer[] var1, int var2, CPointer var3, CPointer var4, FlRunnable var5, CPointer var6) throws FlNativeException;

    private native void getParts(CPointer var1, CPointer[] var2, CPointer var3, CPointer var4) throws FlNativeException;

    private native void del(CPointer var1, CPointer var2, CPointer var3) throws FlNativeException;

    private native void canonize(CPointer var1, CPointer var2) throws FlNativeException;

    private native void selfUnion(CPointer var1, CPointer var2) throws FlNativeException;

    private native void setUseSurfaceNormal(CPointer var1, boolean var2) throws FlNativeException;

    private native void orientBnd(CPointer var1, CPointer var2) throws FlNativeException;

    private native void swapBndOrient(CPointer var1) throws FlNativeException;

    private native Geom[] split(CPointer var1, CPointer var2, CPointer var3) throws FlNativeException;

    private native void splitToPrim(CPointer var1, CPointer[] var2, CPointer var3, CPointer var4) throws FlNativeException;

    private native int[][] adj(CPointer var1, int[][] var2, boolean var3) throws FlNativeException;

    private native void adjSparse(CPointer var1, int[][] var2, CPointer var3) throws FlNativeException;

    private native void move(CPointer var1, double[] var2, CPointer var3, CPointer var4) throws FlNativeException;

    private native void scale(CPointer var1, double[] var2, double[] var3, CPointer var4, CPointer var5) throws FlNativeException;

    private native void transform(CPointer var1, double[][] var2, CPointer var3, CPointer var4) throws FlNativeException;

    private native void transform(CPointer var1, double[][] var2, double[][] var3, CPointer var4, CPointer var5) throws FlNativeException;

    private native void mirror(CPointer var1, double[] var2, double[] var3, CPointer var4, CPointer var5) throws FlNativeException;

    private native void rotate(CPointer var1, double var2, double[] var4, double[] var5, CPointer var6, CPointer var7) throws FlNativeException;

    private native int getNDom(CPointer var1, int var2) throws FlNativeException;

    private native int getNFiniteVoids(CPointer var1) throws FlNativeException;

    private native int[] getNEntitiesMesh(CPointer var1) throws FlNativeException;

    private static native void getMeshGeom(CPointer var0, CPointer var1, int[][] var2);

    private native int getNPrimEnt(CPointer var1) throws FlNativeException;

    private native void setType(CPointer var1, int var2) throws FlNativeException;

    private native int getType(CPointer var1) throws FlNativeException;

    public native boolean isAssembly(CPointer var1) throws FlNativeException;

    public native boolean hasCadRep(CPointer var1) throws FlNativeException;

    private native boolean voidsAreLabeled(CPointer var1) throws FlNativeException;

    private native double getGTol(CPointer var1) throws FlNativeException;

    private native double getGScale(CPointer var1) throws FlNativeException;

    private native int getNumVtx(CPointer var1) throws FlNativeException;

    private native int getNumEdg(CPointer var1) throws FlNativeException;

    private native int getNumSub(CPointer var1) throws FlNativeException;

    private native int getNumParts(CPointer var1) throws FlNativeException;

    private native int getNumConComp(CPointer var1) throws FlNativeException;

    private native double[][] getVtxCoord(CPointer var1) throws FlNativeException;

    private native double[][] getVtxCoordMesh(CPointer var1) throws FlNativeException;

    private native int[] getVtxDom(CPointer var1) throws FlNativeException;

    private native double[][] getEdgParam(CPointer var1) throws FlNativeException;

    private native int[][] getEdgVtx(CPointer var1) throws FlNativeException;

    private native int[][] getUpDownExt(CPointer var1) throws FlNativeException;

    private native int[][] getGeomToMeshMapEncoded(CPointer var1, int var2);

    private native void cleanupWS(CPointer var1) throws FlNativeException;

    private native void checkValidity(CPointer var1) throws FlNativeException;

    private native void chamfer(CPointer var1, CPointer var2, CPointer var3) throws FlNativeException;

    private native void fillet(CPointer var1, CPointer var2, CPointer var3) throws FlNativeException;

    private static native void createNativeCurve(CPointer var0, int var1, CPointer var2) throws FlNativeException;

    private static native void createNativeSurface(CPointer var0, CPointer var1, double var2) throws FlNativeException;

    private native int[][] getVtxInt(CPointer var1) throws FlNativeException;

    private native double[][] getVtxDbl(CPointer var1) throws FlNativeException;

    private native int[][] getEdgInt(CPointer var1) throws FlNativeException;

    private native double[][] getEdgDbl(CPointer var1) throws FlNativeException;

    private native String[] getMfdTypes(CPointer var1) throws FlNativeException;

    private native void getCurves(CPointer var1, CPointer[] var2) throws FlNativeException;

    private native void getSurfaces(CPointer var1, CPointer[] var2) throws FlNativeException;

    private native int getNrCurves(CPointer var1) throws FlNativeException;

    private native int getNrSurfaces(CPointer var1) throws FlNativeException;

    private native double getMinCoord(CPointer var1, int var2, boolean var3) throws FlNativeException;

    private native double getMaxCoord(CPointer var1, int var2, boolean var3) throws FlNativeException;

    private native void setIdentityAssocHistory(CPointer var1) throws FlNativeException;

    private native int[] getAssocHistorySerialization(CPointer var1) throws FlNativeException;

    private native int getNInputObjects(CPointer var1) throws FlNativeException;

    private native void create35aAssocHistory(CPointer var1, CPointer[] var2) throws FlNativeException;

    private native long getSizeInMemory(CPointer var1) throws FlNativeException;

    private native long calculateCheckSum(CPointer var1) throws FlNativeException;

    private native int calcAdjChecksum(CPointer var1) throws FlNativeException;

    private native void initProxy(CPointer var1, CPointer var2) throws FlNativeException;

    private native void updateFromProxy(CPointer var1, CPointer var2) throws FlNativeException;

    private native boolean isEntityLinear(CPointer var1, int var2, int var3) throws FlNativeException;

    private native int[] isEdgeCircular(CPointer var1) throws FlNativeException;

    private native double[] getEdgLength(CPointer var1) throws FlNativeException;

    private native void classifyLinearEntities(CPointer var1, int var2, int[] var3, CPointer var4) throws FlNativeException;

    private native void getCurvatureProperties(CPointer var1, int var2, int var3, boolean var4, CPointer var5) throws FlNativeException;

    private native void getBounds(CPointer var1, double[] var2, boolean var3) throws FlNativeException;

    private static native void findPartitionEdgeProjections(CPointer[] var0, int[][] var1, int[][] var2, CPointer var3) throws FlNativeException;

    private static native void partitionDomains(CPointer var0, CPointer var1, int[] var2, CPointer[] var3, CPointer var4, CPointer var5, FlRunnable var6, CPointer var7);

    private native boolean automaticVirtualProcessing(CPointer var1, CPointer var2, CPointer var3, FlRunnable var4, CPointer var5) throws FlNativeException;

    private native void assembleRenderingMeshCache(CPointer var1, CPointer[] var2, CPointer var3, CPointer var4);

    private native void getRenderDrawGeomFromRenderingMeshCache(CPointer var1, CPointer var2, int var3);
}

