/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.guigraphics.selection;

import com.comsol.renderer.server.graphics3d.SceneGraphObjectEnums;
import com.comsol.util.exceptions.FlException;

public enum SelectionLevel {
    a(-2),
    b(-1),
    c(0),
    d(1),
    e(2),
    f(3);

    private final int intRep;
    private final int[] dimensions;

    private SelectionLevel(int n3) {
        this.intRep = n3;
        if (n3 >= -1) {
            this.dimensions = new int[]{n3};
        } else if (n3 == -2) {
            int[] nArray = new int[2];
            nArray[1] = 1;
            this.dimensions = nArray;
        } else {
            throw new RuntimeException("Illegal integer representation in SelectionLevel: " + n3);
        }
    }

    public int a() {
        return this.intRep;
    }

    public static SelectionLevel a(int n2) {
        return SelectionLevel.values()[n2 + 2];
    }

    public int[] b() {
        return this.dimensions;
    }

    public boolean c() {
        return this.intRep >= -1;
    }

    public boolean d() {
        return this.intRep >= 0;
    }

    public boolean e() {
        return this == b;
    }

    public boolean f() {
        return this == d;
    }

    public boolean b(int n2) {
        if (this == a) {
            return n2 == 0 || n2 == 1;
        }
        return n2 == this.intRep;
    }

    public static SelectionLevel a(SceneGraphObjectEnums.PickedPartType pickedPartType) {
        switch (pickedPartType) {
            case Point: {
                return c;
            }
            case Line: {
                return d;
            }
            case Sheet: {
                return e;
            }
            case Solid: {
                return f;
            }
        }
        throw new FlException("Part type not handled to DrawSelectionType " + pickedPartType);
    }
}

